/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.ICGlobalVariableManager;
import org.eclipse.cdt.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionDelegate;

public class RemoveAllGlobalsActionDelegate
extends ActionDelegate
implements IViewActionDelegate,
IDebugEventSetListener {
    private IAction fAction;

    public void init(IViewPart view) {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void init(IAction action) {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fAction = action;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.update();
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        this.fAction = null;
    }

    public void run(IAction action) {
        ICGlobalVariableManager gvm;
        IAdaptable context = DebugUITools.getDebugContext();
        if (context instanceof IDebugElement && (gvm = (ICGlobalVariableManager)((IDebugElement)context).getDebugTarget().getAdapter(ICGlobalVariableManager.class)) != null) {
            DebugPlugin.getDefault().asyncExec(new Runnable(){

                public void run() {
                    gvm.removeAllGlobals();
                }
            });
        }
    }

    private void update() {
        IAction action = this.fAction;
        if (action != null) {
            ICGlobalVariableManager gvm;
            IAdaptable context = DebugUITools.getDebugContext();
            boolean enabled = false;
            if (context instanceof IDebugElement && (gvm = (ICGlobalVariableManager)((IDebugElement)context).getDebugTarget().getAdapter(ICGlobalVariableManager.class)) != null) {
                IGlobalVariableDescriptor[] globals = gvm.getDescriptors();
                enabled = globals != null && globals.length > 0;
            }
            action.setEnabled(enabled);
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (this.fAction != null) {
            int i = 0;
            while (i < events.length) {
                DebugEvent event = events[i];
                if (event.getSource() instanceof IDebugTarget && event.getKind() == 16 && event.getDetail() == 512) {
                    this.update();
                    break;
                }
                ++i;
            }
        }
    }
}

