/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.disassembly;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.actions.CBreakpointPropertiesRulerAction;
import org.eclipse.cdt.debug.internal.ui.actions.EnableDisableBreakpointRulerAction;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyDocumentProvider;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyInstructionPointerAnnotation;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyViewEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyViewer;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyViewerConfiguration;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.IDisassemblyListener;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.ToggleBreakpointAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class DisassemblyView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
INullSelectionListener,
IPropertyChangeListener,
IDebugExceptionHandler,
IDisassemblyListener {
    private static final int VERTICAL_RULER_WIDTH = 12;
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    private String fViewContextMenuId;
    private String fRulerContextMenuId;
    private IVerticalRuler fVerticalRuler;
    private IOverviewRuler fOverviewRuler;
    protected ICStackFrame fLastStackFrame = null;
    private SourceViewerDecorationSupport fSourceViewerDecorationSupport;
    private IAnnotationAccess fAnnotationAccess;
    private MarkerAnnotationPreferences fAnnotationPreferences;
    private DisassemblyDocumentProvider fDocumentProvider;
    private DisassemblyInstructionPointerAnnotation fInstrPointerAnnotation;
    private IMenuListener fMenuListener;
    private MouseListener fMouseListener;
    private Menu fRulerContextMenu;
    private Menu fTextContextMenu;
    private Map fActions = new HashMap(10);

    protected final IMenuListener getContextMenuListener() {
        if (this.fMenuListener == null) {
            this.fMenuListener = new IMenuListener(){

                public void menuAboutToShow(IMenuManager menu) {
                    String id = menu.getId();
                    if (DisassemblyView.this.getRulerContextMenuId().equals(id)) {
                        DisassemblyView.this.setFocus();
                        DisassemblyView.this.rulerContextMenuAboutToShow(menu);
                    } else if (DisassemblyView.this.getViewContextMenuId().equals(id)) {
                        DisassemblyView.this.setFocus();
                        DisassemblyView.this.viewContextMenuAboutToShow(menu);
                    }
                }
            };
        }
        return this.fMenuListener;
    }

    protected final MouseListener getRulerMouseListener() {
        if (this.fMouseListener == null) {
            this.fMouseListener = new MouseListener(){
                private boolean fDoubleClicked = false;

                private void triggerAction(String actionID) {
                    IAction action = DisassemblyView.this.getAction(actionID);
                    if (action != null) {
                        if (action instanceof IUpdate) {
                            ((IUpdate)action).update();
                        }
                        if (action.isEnabled()) {
                            action.run();
                        }
                    }
                }

                public void mouseUp(MouseEvent e) {
                    DisassemblyView.this.setFocus();
                    if (1 == e.button && !this.fDoubleClicked) {
                        this.triggerAction("RulerClick");
                    }
                    this.fDoubleClicked = false;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    if (1 == e.button) {
                        this.fDoubleClicked = true;
                        this.triggerAction(IInternalCDebugUIConstants.ACTION_TOGGLE_BREAKPOINT);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    StyledText text = DisassemblyView.this.getSourceViewer().getTextWidget();
                    if (text != null && !text.isDisposed()) {
                        Display display = text.getDisplay();
                        Point location = display.getCursorLocation();
                        DisassemblyView.this.getRulerContextMenu().setLocation(location.x, location.y);
                    }
                }
            };
        }
        return this.fMouseListener;
    }

    public DisassemblyView() {
        this.setViewContextMenuId("#DisassemblyViewContext");
        this.setRulerContextMenuId("#DisassemblyViewRulerContext");
        this.fAnnotationPreferences = new MarkerAnnotationPreferences();
    }

    protected Viewer createViewer(Composite parent) {
        this.fVerticalRuler = this.createVerticalRuler();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        SourceViewer viewer = this.createSourceViewer(parent, this.fVerticalRuler, this.getOverviewRuler());
        viewer.configure((SourceViewerConfiguration)new DisassemblyViewerConfiguration());
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        this.getEditorPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.getSite().setSelectionProvider(viewer.getSelectionProvider());
        this.setEventHandler(this.createEventHandler());
        viewer.setDocument(this.getDocumentProvider().getDocument(DisassemblyEditorInput.EMPTY_EDITOR_INPUT), this.getDocumentProvider().getAnnotationModel(null));
        this.resetViewerInput();
        return viewer;
    }

    protected void createActions() {
        IVerticalRuler ruler = this.getVerticalRuler();
        Object action = new ToggleBreakpointAction((IWorkbenchPart)this, null, (IVerticalRulerInfo)ruler);
        this.setAction(IInternalCDebugUIConstants.ACTION_TOGGLE_BREAKPOINT, (IAction)action);
        action = new EnableDisableBreakpointRulerAction((IWorkbenchPart)this, (IVerticalRulerInfo)ruler);
        this.setAction(IInternalCDebugUIConstants.ACTION_ENABLE_DISABLE_BREAKPOINT, (IAction)action);
        action = new CBreakpointPropertiesRulerAction((IWorkbenchPart)this, (IVerticalRulerInfo)ruler);
        this.setAction(IInternalCDebugUIConstants.ACTION_BREAKPOINT_PROPERTIES, (IAction)action);
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.DISASSEMBLY_VIEW;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
        this.updateObjects();
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection == null) {
            this.resetViewerInput();
        } else if (selection instanceof IStructuredSelection) {
            this.computeInput((IStructuredSelection)selection);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (IInternalCDebugUIConstants.DISASSEMBLY_SOURCE_LINE_COLOR.equals(propertyName)) {
            IEditorInput input = this.getInput();
            if (input instanceof DisassemblyEditorInput) {
                this.getSourceViewer().changeTextPresentation(this.createTextPresentation(((DisassemblyEditorInput)input).getSourceRegions()), true);
            }
        } else if (IInternalCDebugUIConstants.DISASSEMBLY_FONT.equals(propertyName)) {
            this.getSourceViewer().getTextWidget().setFont(JFaceResources.getFont((String)IInternalCDebugUIConstants.DISASSEMBLY_FONT));
        }
    }

    public void handleException(DebugException e) {
        this.showMessage(e.getMessage());
    }

    protected IVerticalRuler createVerticalRuler() {
        VerticalRuler ruler = new VerticalRuler(12, this.getAnnotationAccess());
        return ruler;
    }

    private IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        OverviewRuler ruler = new OverviewRuler(this.getAnnotationAccess(), 12, sharedColors);
        for (AnnotationPreference preference : this.fAnnotationPreferences.getAnnotationPreferences()) {
            if (!preference.contributesToHeader()) continue;
            ruler.addHeaderAnnotationType(preference.getAnnotationType());
        }
        return ruler;
    }

    private SourceViewer createSourceViewer(Composite parent, IVerticalRuler vertRuler, IOverviewRuler ovRuler) {
        DisassemblyViewer viewer = new DisassemblyViewer(parent, vertRuler, ovRuler);
        viewer.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        return viewer;
    }

    protected SourceViewer getSourceViewer() {
        return (SourceViewer)this.getViewer();
    }

    protected AbstractDebugEventHandler createEventHandler() {
        return new DisassemblyViewEventHandler(this);
    }

    protected void computeInput(IStructuredSelection ssel) {
        Object element;
        SourceViewer viewer = this.getSourceViewer();
        if (viewer == null) {
            return;
        }
        this.fLastStackFrame = null;
        if (ssel != null && ssel.size() == 1 && (element = ssel.getFirstElement()) instanceof ICStackFrame) {
            this.fLastStackFrame = (ICStackFrame)element;
            IEditorInput input = this.getInput();
            if (input instanceof DisassemblyEditorInput && !((DisassemblyEditorInput)input).contains((ICStackFrame)element)) {
                this.setViewerInput(DisassemblyEditorInput.PENDING_EDITOR_INPUT);
            }
            this.computeInput(input, (ICStackFrame)element, this);
            return;
        }
        this.resetViewerInput();
    }

    public void setViewerInput(IEditorInput input) {
        IRegion[] sourceRegions;
        IEditorInput current;
        SourceViewer viewer = this.getSourceViewer();
        if (viewer == null) {
            return;
        }
        if (input == null) {
            input = DisassemblyEditorInput.EMPTY_EDITOR_INPUT;
        }
        if ((current = this.getInput()) != null && current.equals(input)) {
            this.updateObjects();
            return;
        }
        this.setInput(input);
        this.showViewer();
        try {
            this.getDocumentProvider().connect(input);
        }
        catch (CoreException coreException) {}
        this.getSourceViewer().setDocument(this.getDocumentProvider().getDocument(input), this.getDocumentProvider().getAnnotationModel(input));
        if (input instanceof DisassemblyEditorInput && (sourceRegions = ((DisassemblyEditorInput)input).getSourceRegions()).length > 0) {
            this.getSourceViewer().changeTextPresentation(this.createTextPresentation(sourceRegions), true);
        }
        this.updateObjects();
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        this.getEditorPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.dispose();
            this.fSourceViewerDecorationSupport = null;
        }
        if (this.fDocumentProvider != null) {
            this.fDocumentProvider.dispose();
            this.fDocumentProvider = null;
        }
        if (this.fActions != null) {
            this.fActions.clear();
            this.fActions = null;
        }
        super.dispose();
    }

    public void inputComputed(final ICStackFrame frame, final IStatus status, final IEditorInput input) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (DisassemblyView.this.isAvailable()) {
                    if (DisassemblyView.this.fLastStackFrame != null && DisassemblyView.this.fLastStackFrame.equals(frame)) {
                        DisassemblyView.this.fLastStackFrame = null;
                        if (!status.isOK()) {
                            DisassemblyView.this.setInput(null);
                            DisassemblyView.this.getViewer().setInput(null);
                            DisassemblyView.this.showMessage(status.getMessage());
                            return;
                        }
                    }
                    if (input != null) {
                        DisassemblyView.this.setViewerInput(input);
                        DisassemblyView.this.selectAndReveal(frame, input);
                    } else {
                        DisassemblyView.this.resetViewerInput();
                    }
                }
            }
        };
        this.asyncExec(runnable);
    }

    public void computeInput(final Object current, final ICStackFrame frame, final IDisassemblyListener listener) {
        Runnable runnable = new Runnable(){

            public void run() {
                IStatus status = Status.OK_STATUS;
                DisassemblyEditorInput input = null;
                if (current instanceof DisassemblyEditorInput && ((DisassemblyEditorInput)current).contains(frame)) {
                    input = (IEditorInput)current;
                } else {
                    try {
                        input = DisassemblyEditorInput.create(frame);
                    }
                    catch (DebugException e) {
                        status = new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 0, e.getMessage(), null);
                    }
                }
                listener.inputComputed(frame, status, input);
            }
        };
        DebugPlugin.getDefault().asyncExec(runnable);
    }

    protected void selectAndReveal(ICStackFrame frame, IEditorInput input) {
        IRegion region = this.getLineInformation(frame, input);
        if (region != null) {
            int start = region.getOffset();
            int length = region.getLength();
            StyledText widget = this.getSourceViewer().getTextWidget();
            widget.setRedraw(false);
            this.getSourceViewer().revealRange(start, length);
            this.getSourceViewer().setSelectedRange(start, 0);
            widget.setRedraw(true);
            this.setInstructionPointer(frame, start, length, this.getDocumentProvider().getAnnotationModel(input));
        }
    }

    private IRegion getLineInformation(ICStackFrame frame, IEditorInput input) {
        int line;
        IAddress address;
        if (input instanceof DisassemblyEditorInput && (address = frame.getAddress()) != null && (line = ((DisassemblyEditorInput)input).getInstructionLine(address)) > 0) {
            try {
                return this.getSourceViewer().getDocument().getLineInformation(--line);
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    public IEditorInput getInput() {
        Object input;
        if (this.getSourceViewer() != null && (input = this.getSourceViewer().getInput()) instanceof IEditorInput) {
            return (IEditorInput)input;
        }
        return null;
    }

    protected void setInput(IEditorInput input) {
        this.getSourceViewer().setInput((Object)input);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createViewContextMenu();
        this.createRulerContextMenu();
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.install(this.getEditorPreferenceStore());
        }
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport(viewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    private IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess();
    }

    private void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        Iterator e = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
    }

    private IAnnotationAccess getAnnotationAccess() {
        if (this.fAnnotationAccess == null) {
            this.fAnnotationAccess = this.createAnnotationAccess();
        }
        return this.fAnnotationAccess;
    }

    private ISharedTextColors getSharedColors() {
        ISharedTextColors sharedColors = CDebugUIPlugin.getDefault().getSharedTextColors();
        return sharedColors;
    }

    private IPreferenceStore getEditorPreferenceStore() {
        return EditorsUI.getPreferenceStore();
    }

    public DisassemblyDocumentProvider getDocumentProvider() {
        if (this.fDocumentProvider == null) {
            this.fDocumentProvider = new DisassemblyDocumentProvider();
        }
        return this.fDocumentProvider;
    }

    protected void setInstructionPointer(ICStackFrame frame, int start, int length, IAnnotationModel model) {
        Assert.isNotNull((Object)model);
        boolean tos = this.isTopStackFrame(frame);
        DisassemblyInstructionPointerAnnotation instPtrAnnotation = new DisassemblyInstructionPointerAnnotation(frame, tos);
        Position position = new Position(start, length);
        DisassemblyInstructionPointerAnnotation oldPointer = this.getCurrentInstructionPointer();
        if (oldPointer != null) {
            model.removeAnnotation((Annotation)oldPointer);
        }
        model.addAnnotation((Annotation)instPtrAnnotation, position);
        this.setCurrentInstructionPointer(instPtrAnnotation);
    }

    private boolean isTopStackFrame(ICStackFrame stackFrame) {
        IThread thread = stackFrame.getThread();
        boolean tos = false;
        try {
            tos = stackFrame.equals(thread.getTopStackFrame());
        }
        catch (DebugException debugException) {}
        return tos;
    }

    private DisassemblyInstructionPointerAnnotation getCurrentInstructionPointer() {
        return this.fInstrPointerAnnotation;
    }

    private void setCurrentInstructionPointer(DisassemblyInstructionPointerAnnotation instrPointer) {
        this.fInstrPointerAnnotation = instrPointer;
    }

    protected void removeCurrentInstructionPointer(IAnnotationModel model) {
        Assert.isNotNull((Object)model);
        DisassemblyInstructionPointerAnnotation instrPointer = this.getCurrentInstructionPointer();
        if (instrPointer != null) {
            model.removeAnnotation((Annotation)instrPointer);
            this.setCurrentInstructionPointer(null);
        }
    }

    protected void resetViewerInput() {
        SourceViewer viewer = this.getSourceViewer();
        if (viewer == null) {
            return;
        }
        IEditorInput input = DisassemblyEditorInput.EMPTY_EDITOR_INPUT;
        this.setInput(input);
        this.showViewer();
        try {
            this.getDocumentProvider().connect(input);
        }
        catch (CoreException coreException) {}
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel(input);
        this.getSourceViewer().setDocument(this.getDocumentProvider().getDocument(input), model);
        this.removeCurrentInstructionPointer(model);
        this.updateObjects();
    }

    protected void becomesHidden() {
        this.selectionChanged(null, (ISelection)new StructuredSelection());
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        IViewPart part = this.getSite().getPage().findView("org.eclipse.debug.ui.DebugView");
        if (part != null) {
            ISelection selection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
            this.selectionChanged((IWorkbenchPart)part, selection);
        }
    }

    private IOverviewRuler getOverviewRuler() {
        if (this.fOverviewRuler == null) {
            this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        }
        return this.fOverviewRuler;
    }

    protected String getRulerContextMenuId() {
        return this.fRulerContextMenuId;
    }

    private void setRulerContextMenuId(String rulerContextMenuId) {
        Assert.isNotNull((Object)rulerContextMenuId);
        this.fRulerContextMenuId = rulerContextMenuId;
    }

    protected String getViewContextMenuId() {
        return this.fViewContextMenuId;
    }

    private void setViewContextMenuId(String viewContextMenuId) {
        Assert.isNotNull((Object)viewContextMenuId);
        this.fViewContextMenuId = viewContextMenuId;
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator("additions"));
        this.addAction(menu, IInternalCDebugUIConstants.ACTION_TOGGLE_BREAKPOINT);
        this.addAction(menu, IInternalCDebugUIConstants.ACTION_ENABLE_DISABLE_BREAKPOINT);
        this.addAction(menu, IInternalCDebugUIConstants.ACTION_BREAKPOINT_PROPERTIES);
    }

    protected void viewContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected final void addAction(IMenuManager menu, String group, String actionId) {
        IAction action = this.getAction(actionId);
        if (action != null) {
            IMenuManager subMenu;
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if ((subMenu = menu.findMenuUsingPath(group)) != null) {
                subMenu.add(action);
            } else {
                menu.appendToGroup(group, action);
            }
        }
    }

    protected final void addAction(IMenuManager menu, String actionId) {
        IAction action = this.getAction(actionId);
        if (action != null) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            menu.add(action);
        }
    }

    protected Menu getRulerContextMenu() {
        return this.fRulerContextMenu;
    }

    private void setRulerContextMenu(Menu rulerContextMenu) {
        this.fRulerContextMenu = rulerContextMenu;
    }

    private void createViewContextMenu() {
        String id = this.getViewContextMenuId();
        MenuManager manager = new MenuManager(id, id);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(this.getContextMenuListener());
        StyledText styledText = this.getSourceViewer().getTextWidget();
        this.setTextContextMenu(manager.createContextMenu((Control)styledText));
        styledText.setMenu(this.getTextContextMenu());
        if (this.getSite() != null) {
            this.getSite().registerContextMenu(id, manager, (ISelectionProvider)this.getSourceViewer());
        }
    }

    private void createRulerContextMenu() {
        String id = this.getRulerContextMenuId();
        MenuManager manager = new MenuManager(id, id);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(this.getContextMenuListener());
        Control rulerControl = this.fVerticalRuler.getControl();
        this.setRulerContextMenu(manager.createContextMenu(rulerControl));
        rulerControl.setMenu(this.getRulerContextMenu());
        rulerControl.addMouseListener(this.getRulerMouseListener());
        if (this.getSite() != null) {
            this.getSite().registerContextMenu(id, manager, (ISelectionProvider)this.getSourceViewer());
        }
    }

    private Menu getTextContextMenu() {
        return this.fTextContextMenu;
    }

    private void setTextContextMenu(Menu textContextMenu) {
        this.fTextContextMenu = textContextMenu;
    }

    public void setAction(String actionID, IAction action) {
        Assert.isNotNull((Object)actionID);
        if (action == null) {
            action = (IAction)this.fActions.remove(actionID);
        } else {
            this.fActions.put(actionID, action);
        }
    }

    public IAction getAction(String actionID) {
        Assert.isNotNull((Object)actionID);
        return (IAction)this.fActions.get(actionID);
    }

    private IVerticalRuler getVerticalRuler() {
        return this.fVerticalRuler;
    }

    private TextPresentation createTextPresentation(IRegion[] regions) {
        TextPresentation p = new TextPresentation();
        int i = 0;
        while (i < regions.length) {
            p.addStyleRange(new StyleRange(regions[i].getOffset(), regions[i].getLength(), CDebugUIPlugin.getPreferenceColor(IInternalCDebugUIConstants.DISASSEMBLY_SOURCE_LINE_COLOR), null));
            ++i;
        }
        return p;
    }

    protected void refresh(IDisassembly disassembly) {
        if (!(this.getInput() instanceof DisassemblyEditorInput) || !disassembly.equals(((DisassemblyEditorInput)this.getInput()).getDisassembly())) {
            return;
        }
        this.resetViewerInput();
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        IAdaptable context = DebugUITools.getDebugContext();
        if (context instanceof ICStackFrame) {
            this.fLastStackFrame = (ICStackFrame)context;
            IEditorInput input = this.getInput();
            if (input instanceof DisassemblyEditorInput) {
                this.setViewerInput(DisassemblyEditorInput.PENDING_EDITOR_INPUT);
            }
            this.computeInput(input, (ICStackFrame)context, this);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (this.equals(part)) {
            CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_INSTRUCTION_STEP_MODE_ON, true);
        }
        super.partActivated(part);
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (this.equals(part)) {
            CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_INSTRUCTION_STEP_MODE_ON, false);
        }
        super.partDeactivated(part);
    }

    public Object getAdapter(Class adapter) {
        if (IDocument.class.equals((Object)adapter)) {
            return this.getDocumentProvider().getDocument(this.getInput());
        }
        return super.getAdapter(adapter);
    }

    public int getOrientation() {
        return 0x2000000;
    }
}

