/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.disassembly;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.core.model.IDisassemblyBlock;
import org.eclipse.cdt.debug.internal.core.model.Disassembly;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class GoToAddressActionDelegate
implements IActionDelegate,
IViewActionDelegate {
    private IViewPart fView;
    private IAction fAction;
    private DisassemblyView fDisassemblyView;

    public void init(IViewPart view) {
        this.setView(view);
        if (view instanceof DisassemblyView) {
            this.fDisassemblyView = (DisassemblyView)view;
        }
    }

    private void setView(IViewPart view) {
        this.fView = view;
    }

    protected IViewPart getView() {
        return this.fView;
    }

    public void run(IAction action) {
        InputDialog dialog = new InputDialog(this.fView.getViewSite().getShell(), "Enter address", "Enter address to go to", "", new IInputValidator(){

            public String isValid(String in) {
                String input;
                block5: {
                    try {
                        input = in.trim();
                        if (input.length() != 0) break block5;
                        return "Cannot be empty address";
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "Must be a hexadecimal or decimal address";
                    }
                }
                if (input.toLowerCase().startsWith("0x")) {
                    Long.parseLong(input.substring(2), 16);
                } else {
                    Long.parseLong(input);
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            String address = dialog.getValue();
            this.gotoAddress(address);
        }
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
    }

    private void gotoAddress(String addr) {
        Addr32 address = new Addr32(addr);
        if (this.fDisassemblyView != null) {
            IDebugTarget tar;
            Object element;
            ICDebugTarget target = null;
            ISelection selection = this.fDisassemblyView.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
            if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ICStackFrame && (tar = ((ICStackFrame)element).getDebugTarget()) instanceof ICDebugTarget) {
                target = (ICDebugTarget)tar;
            }
            DisassemblyEditorInput input = null;
            try {
                input = GoToAddressActionDelegate.create(target, (IAddress)address);
                this.fDisassemblyView.setViewerInput(input);
            }
            catch (DebugException debugException) {
                MessageDialog dialog = new MessageDialog(this.fView.getViewSite().getShell(), "Wrong address", null, "Cannot access memory at address " + addr, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
            }
        }
    }

    public static DisassemblyEditorInput create(ICDebugTarget target, IAddress address) throws DebugException {
        DisassemblyEditorInput input = null;
        IDisassembly disassembly = target.getDisassembly();
        if (disassembly instanceof Disassembly) {
            IDisassemblyBlock block = ((Disassembly)disassembly).getDisassemblyBlock(address);
            input = DisassemblyEditorInput.create(block);
        }
        return input;
    }
}

