/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.cdt.debug.core.model.ISteppingModeTarget;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfResumeCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepIntoCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepOverCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepReturnCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfSteppingModeTarget;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfSuspendCommand;
import org.eclipse.cdt.dsf.debug.ui.contexts.DsfSuspendTrigger;
import org.eclipse.cdt.dsf.debug.ui.sourcelookup.DsfSourceDisplayAdapter;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.actions.DefaultRefreshAllTarget;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.actions.IRefreshAllTarget;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.DefaultDsfModelSelectionPolicyFactory;
import org.eclipse.cdt.dsf.gdb.actions.IConnect;
import org.eclipse.cdt.dsf.gdb.actions.IReverseResumeHandler;
import org.eclipse.cdt.dsf.gdb.actions.IReverseStepIntoHandler;
import org.eclipse.cdt.dsf.gdb.actions.IReverseStepOverHandler;
import org.eclipse.cdt.dsf.gdb.actions.IReverseToggleHandler;
import org.eclipse.cdt.dsf.gdb.actions.IUncallHandler;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.DsfTerminateCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.GdbConnectCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.GdbDisconnectCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.GdbRestartCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.GdbReverseResumeCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.GdbReverseStepIntoCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.GdbReverseStepOverCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.GdbReverseToggleCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.GdbSteppingModeTarget;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.GdbUncallCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.GdbViewModelAdapter;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.commands.IDisconnectHandler;
import org.eclipse.debug.core.commands.IResumeHandler;
import org.eclipse.debug.core.commands.IStepIntoHandler;
import org.eclipse.debug.core.commands.IStepOverHandler;
import org.eclipse.debug.core.commands.IStepReturnHandler;
import org.eclipse.debug.core.commands.ISuspendHandler;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicyFactory;
import org.eclipse.debug.ui.contexts.ISuspendTrigger;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;

@ThreadSafe
public class GdbAdapterFactory
implements IAdapterFactory,
ILaunchesListener2 {
    private static Map<GdbLaunch, SessionAdapterSet> fgLaunchAdapterSets = Collections.synchronizedMap(new HashMap());
    private static Map<ILaunch, SessionAdapterSet> fgDisposedLaunchAdapterSets = new WeakHashMap<ILaunch, SessionAdapterSet>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeAdapterSet(ILaunch launch) {
        Map<GdbLaunch, SessionAdapterSet> map = fgLaunchAdapterSets;
        synchronized (map) {
            if (fgLaunchAdapterSets.containsKey(launch)) {
                fgLaunchAdapterSets.remove(launch).dispose();
                fgDisposedLaunchAdapterSets.put(launch, null);
            }
        }
    }

    public GdbAdapterFactory() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        SessionAdapterSet adapterSet;
        if (!(adaptableObject instanceof GdbLaunch)) {
            return null;
        }
        GdbLaunch launch = (GdbLaunch)adaptableObject;
        DsfSession session = launch.getSession();
        if (session == null) {
            return null;
        }
        Map<GdbLaunch, SessionAdapterSet> map = fgLaunchAdapterSets;
        synchronized (map) {
            block11: {
                if (!fgDisposedLaunchAdapterSets.containsKey(launch)) break block11;
                return null;
            }
            adapterSet = fgLaunchAdapterSets.get(launch);
            if (adapterSet == null) {
                adapterSet = new SessionAdapterSet(launch);
                fgLaunchAdapterSets.put(launch, adapterSet);
            }
        }
        if (adapterType.equals(IElementContentProvider.class)) {
            return adapterSet.fViewModelAdapter;
        }
        if (adapterType.equals(IModelProxyFactory.class)) {
            return adapterSet.fViewModelAdapter;
        }
        if (adapterType.equals(IColumnPresentationFactory.class)) {
            return adapterSet.fViewModelAdapter;
        }
        if (adapterType.equals(ISuspendTrigger.class)) {
            return adapterSet.fSuspendTrigger;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IElementContentProvider.class, IModelProxyFactory.class, ISuspendTrigger.class, IColumnPresentationFactory.class};
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof GdbLaunch) {
                GdbAdapterFactory.disposeAdapterSet(launch);
            }
            ++n2;
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    @Immutable
    class SessionAdapterSet {
        final GdbLaunch fLaunch;
        final GdbViewModelAdapter fViewModelAdapter;
        final DsfSourceDisplayAdapter fSourceDisplayAdapter;
        final DsfStepIntoCommand fStepIntoCommand;
        final GdbReverseStepIntoCommand fReverseStepIntoCommand;
        final DsfStepOverCommand fStepOverCommand;
        final GdbReverseStepOverCommand fReverseStepOverCommand;
        final DsfStepReturnCommand fStepReturnCommand;
        final GdbUncallCommand fUncallCommand;
        final DsfSuspendCommand fSuspendCommand;
        final DsfResumeCommand fResumeCommand;
        final GdbReverseResumeCommand fReverseResumeCommand;
        final GdbRestartCommand fRestartCommand;
        final DsfTerminateCommand fTerminateCommand;
        final GdbConnectCommand fConnectCommand;
        final GdbDisconnectCommand fDisconnectCommand;
        final IDebugModelProvider fDebugModelProvider;
        final DsfSuspendTrigger fSuspendTrigger;
        final GdbSteppingModeTarget fSteppingModeTarget;
        final IModelSelectionPolicyFactory fModelSelectionPolicyFactory;
        final SteppingController fSteppingController;
        final DefaultRefreshAllTarget fRefreshAllTarget;
        final GdbReverseToggleCommand fReverseToggleTarget;

        SessionAdapterSet(GdbLaunch launch) {
            this.fLaunch = launch;
            DsfSession session = launch.getSession();
            this.fSteppingController = new SteppingController(session);
            session.registerModelAdapter(SteppingController.class, (Object)this.fSteppingController);
            this.fViewModelAdapter = new GdbViewModelAdapter(session, this.fSteppingController);
            this.fSourceDisplayAdapter = launch.getSourceLocator() instanceof ISourceLookupDirector ? new DsfSourceDisplayAdapter(session, (ISourceLookupDirector)launch.getSourceLocator(), this.fSteppingController) : null;
            session.registerModelAdapter(ISourceDisplay.class, (Object)this.fSourceDisplayAdapter);
            this.fSteppingModeTarget = new GdbSteppingModeTarget(session);
            this.fStepIntoCommand = new DsfStepIntoCommand(session, (DsfSteppingModeTarget)this.fSteppingModeTarget);
            this.fReverseStepIntoCommand = new GdbReverseStepIntoCommand(session, this.fSteppingModeTarget);
            this.fStepOverCommand = new DsfStepOverCommand(session, (DsfSteppingModeTarget)this.fSteppingModeTarget);
            this.fReverseStepOverCommand = new GdbReverseStepOverCommand(session, this.fSteppingModeTarget);
            this.fStepReturnCommand = new DsfStepReturnCommand(session);
            this.fUncallCommand = new GdbUncallCommand(session, this.fSteppingModeTarget);
            this.fSuspendCommand = new DsfSuspendCommand(session);
            this.fResumeCommand = new DsfResumeCommand(session);
            this.fReverseResumeCommand = new GdbReverseResumeCommand(session);
            this.fRestartCommand = new GdbRestartCommand(session, this.fLaunch);
            this.fTerminateCommand = new DsfTerminateCommand(session);
            this.fConnectCommand = new GdbConnectCommand(session);
            this.fDisconnectCommand = new GdbDisconnectCommand(session);
            this.fSuspendTrigger = new DsfSuspendTrigger(session, (ILaunch)this.fLaunch);
            this.fModelSelectionPolicyFactory = new DefaultDsfModelSelectionPolicyFactory();
            this.fRefreshAllTarget = new DefaultRefreshAllTarget();
            this.fReverseToggleTarget = new GdbReverseToggleCommand(session);
            session.registerModelAdapter(ISteppingModeTarget.class, (Object)this.fSteppingModeTarget);
            session.registerModelAdapter(IStepIntoHandler.class, (Object)this.fStepIntoCommand);
            session.registerModelAdapter(IReverseStepIntoHandler.class, (Object)this.fReverseStepIntoCommand);
            session.registerModelAdapter(IStepOverHandler.class, (Object)this.fStepOverCommand);
            session.registerModelAdapter(IReverseStepOverHandler.class, (Object)this.fReverseStepOverCommand);
            session.registerModelAdapter(IStepReturnHandler.class, (Object)this.fStepReturnCommand);
            session.registerModelAdapter(IUncallHandler.class, (Object)this.fUncallCommand);
            session.registerModelAdapter(ISuspendHandler.class, (Object)this.fSuspendCommand);
            session.registerModelAdapter(IResumeHandler.class, (Object)this.fResumeCommand);
            session.registerModelAdapter(IReverseResumeHandler.class, (Object)this.fReverseResumeCommand);
            session.registerModelAdapter(IRestart.class, (Object)this.fRestartCommand);
            session.registerModelAdapter(ITerminateHandler.class, (Object)this.fTerminateCommand);
            session.registerModelAdapter(IConnect.class, (Object)this.fConnectCommand);
            session.registerModelAdapter(IDisconnectHandler.class, (Object)this.fDisconnectCommand);
            session.registerModelAdapter(IModelSelectionPolicyFactory.class, (Object)this.fModelSelectionPolicyFactory);
            session.registerModelAdapter(IRefreshAllTarget.class, (Object)this.fRefreshAllTarget);
            session.registerModelAdapter(IReverseToggleHandler.class, (Object)this.fReverseToggleTarget);
            this.fDebugModelProvider = new IDebugModelProvider(){

                public String[] getModelIdentifiers() {
                    return new String[]{"org.eclipse.cdt.dsf.gdb"};
                }
            };
            session.registerModelAdapter(IDebugModelProvider.class, (Object)this.fDebugModelProvider);
            session.registerModelAdapter(ILaunch.class, (Object)this.fLaunch);
        }

        void dispose() {
            DsfSession session = this.fLaunch.getSession();
            this.fViewModelAdapter.dispose();
            session.unregisterModelAdapter(ISourceDisplay.class);
            if (this.fSourceDisplayAdapter != null) {
                this.fSourceDisplayAdapter.dispose();
            }
            session.unregisterModelAdapter(SteppingController.class);
            this.fSteppingController.dispose();
            session.unregisterModelAdapter(ISteppingModeTarget.class);
            session.unregisterModelAdapter(IStepIntoHandler.class);
            session.unregisterModelAdapter(IReverseStepIntoHandler.class);
            session.unregisterModelAdapter(IStepOverHandler.class);
            session.unregisterModelAdapter(IReverseStepOverHandler.class);
            session.unregisterModelAdapter(IStepReturnHandler.class);
            session.unregisterModelAdapter(IUncallHandler.class);
            session.unregisterModelAdapter(ISuspendHandler.class);
            session.unregisterModelAdapter(IResumeHandler.class);
            session.unregisterModelAdapter(IReverseResumeHandler.class);
            session.unregisterModelAdapter(IRestart.class);
            session.unregisterModelAdapter(ITerminateHandler.class);
            session.unregisterModelAdapter(IConnect.class);
            session.unregisterModelAdapter(IDisconnectHandler.class);
            session.unregisterModelAdapter(IModelSelectionPolicyFactory.class);
            session.unregisterModelAdapter(IRefreshAllTarget.class);
            session.unregisterModelAdapter(IReverseToggleHandler.class);
            this.fSteppingModeTarget.dispose();
            this.fStepIntoCommand.dispose();
            this.fReverseStepIntoCommand.dispose();
            this.fStepOverCommand.dispose();
            this.fReverseStepOverCommand.dispose();
            this.fStepReturnCommand.dispose();
            this.fUncallCommand.dispose();
            this.fSuspendCommand.dispose();
            this.fResumeCommand.dispose();
            this.fReverseResumeCommand.dispose();
            this.fRestartCommand.dispose();
            this.fTerminateCommand.dispose();
            this.fConnectCommand.dispose();
            this.fDisconnectCommand.dispose();
            this.fSuspendTrigger.dispose();
            this.fReverseToggleTarget.dispose();
        }
    }
}

