/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.actions.IReverseResumeHandler;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

@Immutable
public class GdbReverseResumeCommand
implements IReverseResumeHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public GdbReverseResumeCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public boolean canReverseResume(ISelection debugContext) {
        final IRunControl.IExecutionDMContext dmc = this.getContext(debugContext);
        if (dmc == null) {
            return false;
        }
        Query<Boolean> canReverseResume = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IReverseRunControl runControl = (IReverseRunControl)GdbReverseResumeCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null) {
                    runControl.canReverseResume(dmc, rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)canReverseResume);
            return (Boolean)canReverseResume.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        return false;
    }

    public void reverseResume(ISelection debugContext) {
        final IRunControl.IExecutionDMContext dmc = this.getContext(debugContext);
        if (dmc == null) {
            return;
        }
        Query<Object> reverseResume = new Query<Object>(){

            public void execute(DataRequestMonitor<Object> rm) {
                IReverseRunControl runControl = (IReverseRunControl)GdbReverseResumeCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null) {
                    runControl.reverseResume(dmc, rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)reverseResume);
            reverseResume.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    private IRunControl.IExecutionDMContext getContext(ISelection debugContext) {
        Object object;
        IStructuredSelection ss;
        if (debugContext instanceof IStructuredSelection && !(ss = (IStructuredSelection)debugContext).isEmpty() && (object = ss.getFirstElement()) instanceof IDMVMContext) {
            return (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)object).getDMContext(), IRunControl.IExecutionDMContext.class);
        }
        return null;
    }
}

