/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.actions.IReverseToggleHandler;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

@Immutable
public class GdbReverseToggleCommand
implements IReverseToggleHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public GdbReverseToggleCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public boolean canToggleReverse(ISelection debugContext) {
        final ICommandControlService.ICommandControlDMContext controlDmc = this.getCommandControlContext(debugContext);
        final IRunControl.IExecutionDMContext execDmc = this.getExecutionContext(debugContext);
        if (controlDmc == null && execDmc == null) {
            return false;
        }
        Query<Boolean> canSetReverseMode = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IReverseRunControl runControl = (IReverseRunControl)GdbReverseToggleCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null && runControl instanceof IRunControl && ((IRunControl)runControl).isSuspended(execDmc)) {
                    runControl.canEnableReverseMode(controlDmc, rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)canSetReverseMode);
            return (Boolean)canSetReverseMode.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        return false;
    }

    public void toggleReverse(ISelection debugContext) {
        final ICommandControlService.ICommandControlDMContext dmc = this.getCommandControlContext(debugContext);
        if (dmc == null) {
            return;
        }
        Query<Object> setReverseMode = new Query<Object>(){

            public void execute(final DataRequestMonitor<Object> rm) {
                final IReverseRunControl runControl = (IReverseRunControl)GdbReverseToggleCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null) {
                    runControl.isReverseModeEnabled(dmc, (DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)GdbReverseToggleCommand.this.fExecutor, rm){

                        public void handleSuccess() {
                            runControl.enableReverseMode(dmc, (Boolean)this.getData() == false, (RequestMonitor)rm);
                        }
                    });
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)setReverseMode);
            setReverseMode.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    private ICommandControlService.ICommandControlDMContext getCommandControlContext(ISelection debugContext) {
        Object object;
        IStructuredSelection ss;
        if (debugContext instanceof IStructuredSelection && !(ss = (IStructuredSelection)debugContext).isEmpty() && (object = ss.getFirstElement()) instanceof IDMVMContext) {
            return (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)object).getDMContext(), ICommandControlService.ICommandControlDMContext.class);
        }
        return null;
    }

    private IRunControl.IExecutionDMContext getExecutionContext(ISelection debugContext) {
        Object object;
        IStructuredSelection ss;
        if (debugContext instanceof IStructuredSelection && !(ss = (IStructuredSelection)debugContext).isEmpty() && (object = ss.getFirstElement()) instanceof IDMVMContext) {
            return (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)object).getDMContext(), IRunControl.IExecutionDMContext.class);
        }
        return null;
    }

    public boolean isReverseToggled(ISelection debugContext) {
        ICommandControlService.ICommandControlDMContext dmc = this.getCommandControlContext(debugContext);
        return this.isReverseToggled(dmc);
    }

    public boolean isReverseToggled(final ICommandControlService.ICommandControlDMContext dmc) {
        if (dmc == null) {
            return false;
        }
        Query<Boolean> isToggledQuery = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IReverseRunControl runControl = (IReverseRunControl)GdbReverseToggleCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null) {
                    runControl.isReverseModeEnabled(dmc, rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)isToggledQuery);
            return (Boolean)isToggledQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        return false;
    }
}

