/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.AbstractContainerVMNode;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerCountingRequestMonitor;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.VMDelegatingPropertiesUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.ui.IMemento;

public class ContainerVMNode
extends AbstractContainerVMNode
implements IElementMementoProvider {
    private final String MEMENTO_NAME = "CONTAINER_MEMENTO_NAME";

    public ContainerVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session);
    }

    public String toString() {
        return "ContainerVMNode(" + this.getSession().getId() + ")";
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IProcesses processService = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
        ICommandControlService controlService = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        if (processService == null || controlService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        processService.getProcessesBeingDebugged((IDMContext)controlService.getContext(), (DataRequestMonitor)new ViewerDataRequestMonitor<IDMContext[]>(this.getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    ContainerVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                if (this.getData() != null) {
                    ContainerVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                }
                update.done();
            }
        });
    }

    protected void updatePropertiesInSessionThread(IPropertiesUpdate[] updates) {
        IPropertiesUpdate[] parentUpdates = new IPropertiesUpdate[updates.length];
        int i = 0;
        while (i < updates.length) {
            final IPropertiesUpdate update = updates[i];
            final ViewerCountingRequestMonitor countringRm = new ViewerCountingRequestMonitor(ImmediateExecutor.getInstance(), (IViewerUpdate)updates[i]);
            int count = 0;
            parentUpdates[i] = new VMDelegatingPropertiesUpdate(updates[i], (RequestMonitor)countringRm);
            ++count;
            IProcesses processService = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
            IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IProcesses.IProcessDMContext.class);
            if (processService == null || procDmc == null) {
                update.setStatus(DsfUIPlugin.newErrorStatus((int)10002, (String)"Service or handle invalid", null));
            } else {
                processService.getExecutionData((IProcesses.IThreadDMContext)procDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>(this.getExecutor(), (IViewerUpdate)update){

                    public void handleCompleted() {
                        if (this.isSuccess()) {
                            ContainerVMNode.this.fillThreadDataProperties(update, (IProcesses.IThreadDMData)this.getData());
                        } else {
                            update.setStatus(this.getStatus());
                        }
                        countringRm.done();
                    }
                });
                ++count;
            }
            countringRm.setDoneCount(count);
            ++i;
        }
        super.updatePropertiesInSessionThread(parentUpdates);
    }

    protected void fillThreadDataProperties(IPropertiesUpdate update, IProcesses.IThreadDMData data) {
        update.setProperty("name", (Object)data.getName());
        update.setProperty("id", (Object)data.getId());
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof ICommandControlService.ICommandControlShutdownDMEvent) {
            return 1024;
        }
        return super.getDeltaFlags(e);
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (!(e instanceof ICommandControlService.ICommandControlShutdownDMEvent)) {
            super.buildDelta(e, parentDelta, nodeOffset, requestMonitor);
            return;
        }
        parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        requestMonitor.done();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        IElementCompareRequest[] iElementCompareRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IProcesses.IProcessDMContext procDmc;
            IDMContext dmc;
            final IElementCompareRequest request = iElementCompareRequestArray[n2];
            Object element = request.getElement();
            final IMemento memento = request.getMemento();
            String mementoName = memento.getString("CONTAINER_MEMENTO_NAME");
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IRunControl.IContainerDMContext && (procDmc = (IProcesses.IProcessDMContext)this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IProcesses.IProcessDMContext.class)) != null) {
                try {
                    this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            IProcesses processService = (IProcesses)ContainerVMNode.this.getServicesTracker().getService(IProcesses.class);
                            if (processService != null) {
                                processService.getExecutionData((IProcesses.IThreadDMContext)procDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>((Executor)processService.getExecutor(), (IViewerUpdate)request){

                                    protected void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            memento.putString("CONTAINER_MEMENTO_NAME", "Container." + ((IProcesses.IThreadDMData)this.getData()).getName() + ((IProcesses.IThreadDMData)this.getData()).getId());
                                        }
                                        request.done();
                                    }
                                });
                            } else {
                                request.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    request.done();
                }
            } else {
                request.done();
            }
            ++n2;
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        IElementMementoRequest[] iElementMementoRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IProcesses.IProcessDMContext procDmc;
            IDMContext dmc;
            final IElementMementoRequest request = iElementMementoRequestArray[n2];
            Object element = request.getElement();
            final IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IRunControl.IContainerDMContext && (procDmc = (IProcesses.IProcessDMContext)this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IProcesses.IProcessDMContext.class)) != null) {
                try {
                    this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            IProcesses processService = (IProcesses)ContainerVMNode.this.getServicesTracker().getService(IProcesses.class);
                            if (processService != null) {
                                processService.getExecutionData((IProcesses.IThreadDMContext)procDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>((Executor)processService.getExecutor(), (IViewerUpdate)request){

                                    protected void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            memento.putString("CONTAINER_MEMENTO_NAME", "Container." + ((IProcesses.IThreadDMData)this.getData()).getName() + ((IProcesses.IThreadDMData)this.getData()).getId());
                                        }
                                        request.done();
                                    }
                                });
                            } else {
                                request.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    request.done();
                }
            } else {
                request.done();
            }
            ++n2;
        }
    }
}

