/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.index;

import java.net.URI;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.core.filesystem.URIUtil;

public class URIRelativeLocationConverter
implements IIndexLocationConverter {
    private URI baseURI;

    public URIRelativeLocationConverter(URI baseURI) {
        this.baseURI = baseURI;
    }

    public IIndexFileLocation fromInternalFormat(String raw) {
        URI uri = this.baseURI.resolve(URIUtil.toURI((String)raw).getRawPath().substring(1));
        return new IndexFileLocation(uri, null);
    }

    public String toInternalFormat(IIndexFileLocation location) {
        URI relative = this.baseURI.relativize(location.getURI());
        return relative.isAbsolute() ? null : relative.getPath();
    }
}

