/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.resources;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.osgi.util.NLS;

public abstract class ACBuilder
extends IncrementalProjectBuilder
implements IMarkerGenerator {
    private static final String PREF_BUILD_ALL_CONFIGS = "build.all.configs.enabled";
    private static final String PREF_BUILD_CONFIGS_RESOURCE_CHANGES = "build.proj.ref.configs.enabled";
    private static final Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();

    public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        ProblemMarkerInfo problemMarkerInfo = new ProblemMarkerInfo(file, lineNumber, errorDesc, severity, errorVar, null);
        this.addMarker(problemMarkerInfo);
    }

    public void addMarker(ProblemMarkerInfo problemMarkerInfo) {
        try {
            IResource markerResource = problemMarkerInfo.file;
            if (markerResource == null) {
                markerResource = this.getProject();
            }
            IMarker[] cur = markerResource.findMarkers("org.eclipse.cdt.core.problem", true, 1);
            String externalLocation = null;
            if (problemMarkerInfo.externalPath != null) {
                externalLocation = problemMarkerInfo.externalPath.toOSString();
            }
            if (cur != null && cur.length > 0) {
                IMarker[] iMarkerArray = cur;
                int n = cur.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker element = iMarkerArray[n2];
                    int line = (Integer)element.getAttribute("lineNumber");
                    int sev = (Integer)element.getAttribute("severity");
                    String mesg = (String)element.getAttribute("message");
                    String extloc = (String)element.getAttribute("problem.externalLocation");
                    if (line == problemMarkerInfo.lineNumber && sev == this.mapMarkerSeverity(problemMarkerInfo.severity) && mesg.equals(problemMarkerInfo.description) && (extloc == externalLocation || extloc != null && extloc.equals(externalLocation))) {
                        return;
                    }
                    ++n2;
                }
            }
            IMarker marker = markerResource.createMarker("org.eclipse.cdt.core.problem");
            marker.setAttribute("message", (Object)problemMarkerInfo.description);
            marker.setAttribute("severity", this.mapMarkerSeverity(problemMarkerInfo.severity));
            marker.setAttribute("lineNumber", problemMarkerInfo.lineNumber);
            marker.setAttribute("charStart", -1);
            marker.setAttribute("charEnd", -1);
            if (problemMarkerInfo.variableName != null) {
                marker.setAttribute("problem.variable", (Object)problemMarkerInfo.variableName);
            }
            if (externalLocation != null) {
                marker.setAttribute("problem.externalLocation", (Object)externalLocation);
                String locationText = NLS.bind((String)CCorePlugin.getResourceString("ACBuilder.ProblemsView.Location"), (Object)problemMarkerInfo.lineNumber, (Object)externalLocation);
                marker.setAttribute("location", (Object)locationText);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e.getStatus());
        }
    }

    int mapMarkerSeverity(int severity) {
        switch (severity) {
            case 2: 
            case 3: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    public static boolean needAllConfigBuild() {
        return prefs.getBoolean(PREF_BUILD_ALL_CONFIGS);
    }

    public static void setAllConfigBuild(boolean enable) {
        prefs.setValue(PREF_BUILD_ALL_CONFIGS, enable);
    }

    public static boolean buildConfigResourceChanges() {
        return prefs.getBoolean(PREF_BUILD_CONFIGS_RESOURCE_CHANGES);
    }

    public static void setBuildConfigResourceChanges(boolean enable) {
        prefs.setValue(PREF_BUILD_CONFIGS_RESOURCE_CHANGES, enable);
    }
}

