/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;

public class ASTQueries {
    private static NameSearch NAME_SEARCH = new NameSearch();

    public static boolean canContainName(IASTExpression expr) {
        if (expr == null) {
            return false;
        }
        NAME_SEARCH.reset();
        expr.accept(NAME_SEARCH);
        return NAME_SEARCH.foundName();
    }

    public static IASTDeclarator findOutermostDeclarator(IASTDeclarator declarator) {
        IASTDeclarator outermost = null;
        IASTNode candidate = declarator;
        while (candidate instanceof IASTDeclarator) {
            outermost = candidate;
            candidate = outermost.getParent();
        }
        return outermost;
    }

    public static IASTDeclarator findInnermostDeclarator(IASTDeclarator declarator) {
        IASTDeclarator innermost = null;
        while (declarator != null) {
            innermost = declarator;
            declarator = declarator.getNestedDeclarator();
        }
        return innermost;
    }

    public static IASTDeclarator findTypeRelevantDeclarator(IASTDeclarator declarator) {
        IASTDeclarator result = ASTQueries.findInnermostDeclarator(declarator);
        while (!(result.getPointerOperators().length != 0 || result instanceof IASTFieldDeclarator || result instanceof IASTFunctionDeclarator || result instanceof IASTArrayModifier)) {
            IASTNode parent = result.getParent();
            if (parent instanceof IASTDeclarator) {
                result = (IASTDeclarator)parent;
                continue;
            }
            return result;
        }
        return result;
    }

    public static IASTDeclaration[] extractActiveDeclarations(IASTDeclaration[] allDeclarations, int size) {
        Object[] active;
        if (size == 0) {
            active = IASTDeclaration.EMPTY_DECLARATION_ARRAY;
        } else {
            active = new IASTDeclaration[size];
            int j = 0;
            int i = 0;
            while (i < size) {
                IASTDeclaration d = allDeclarations[i];
                if (d.isActive()) {
                    active[j++] = d;
                }
                ++i;
            }
            active = (IASTDeclaration[])ArrayUtil.removeNullsAfter(IASTDeclaration.class, active, j - 1);
        }
        return active;
    }

    private static class NameSearch
    extends ASTVisitor {
        private boolean fFound;

        NameSearch() {
            super(false);
            this.shouldVisitAmbiguousNodes = true;
            this.shouldVisitNames = true;
        }

        public void reset() {
            this.fFound = false;
        }

        public boolean foundName() {
            return this.fFound;
        }

        public int visit(IASTName name) {
            this.fFound = true;
            return 2;
        }

        public int visit(ASTAmbiguousNode node) {
            IASTNode[] alternatives;
            IASTNode[] iASTNodeArray = alternatives = node.getNodes();
            int n = alternatives.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode alt = iASTNodeArray[n2];
                if (!alt.accept(this)) {
                    return 2;
                }
                ++n2;
            }
            return 3;
        }
    }
}

