/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class CPPASTConstructorChainInitializer
extends ASTNode
implements ICPPASTConstructorChainInitializer,
IASTAmbiguityParent,
IASTCompletionContext {
    private IASTName name;
    private IASTExpression value;

    public CPPASTConstructorChainInitializer() {
    }

    public CPPASTConstructorChainInitializer(IASTName memberInitializerid, IASTExpression initializerValue) {
        this.setMemberInitializerId(memberInitializerid);
        this.setInitializerValue(initializerValue);
    }

    public CPPASTConstructorChainInitializer copy() {
        CPPASTConstructorChainInitializer copy = new CPPASTConstructorChainInitializer();
        copy.setMemberInitializerId(this.name == null ? null : this.name.copy());
        copy.setInitializerValue(this.value == null ? null : this.value.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTName getMemberInitializerId() {
        return this.name;
    }

    public void setMemberInitializerId(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(MEMBER_ID);
        }
    }

    public IASTExpression getInitializerValue() {
        return this.value;
    }

    public void setInitializerValue(IASTExpression expression) {
        this.assertNotFrozen();
        this.value = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(INITIALIZER);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitInitializers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (this.value != null && !this.value.accept(action)) {
            return false;
        }
        return !action.shouldVisitInitializers || action.leave(this) != 2;
    }

    public int getRoleForName(IASTName n) {
        if (this.name == n) {
            return 1;
        }
        return 3;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.value) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.value = (IASTExpression)other;
        }
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        Object[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix);
        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] baseClasses = null;
        int i = 0;
        while (i < bindings.length) {
            if (!(bindings[i] instanceof ICPPField) && !(bindings[i] instanceof ICPPNamespace)) {
                if (bindings[i] instanceof ICPPConstructor) {
                    if (baseClasses == null) {
                        baseClasses = this.getBaseClasses(n);
                    }
                    boolean isBaseClassConstructor = false;
                    if (baseClasses != null) {
                        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] iCPPASTBaseSpecifierArray = baseClasses;
                        int n2 = baseClasses.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            char[] baseName;
                            ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier b = iCPPASTBaseSpecifierArray[n3];
                            char[] bindingName = bindings[i].getNameCharArray();
                            if (Arrays.equals(bindingName, baseName = b.getName().getLastName().getSimpleID())) {
                                isBaseClassConstructor = true;
                                break;
                            }
                            ++n3;
                        }
                    }
                    if (!isBaseClassConstructor) {
                        bindings[i] = null;
                    }
                } else {
                    bindings[i] = null;
                }
            }
            ++i;
        }
        return (IBinding[])ArrayUtil.removeNulls(IBinding.class, bindings);
    }

    private ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] getBaseClasses(IASTName name) {
        IASTNode parent = name.getParent();
        while (parent != null) {
            if (parent instanceof ICPPASTCompositeTypeSpecifier) {
                ICPPASTCompositeTypeSpecifier specifier = (ICPPASTCompositeTypeSpecifier)parent;
                return specifier.getBaseSpecifiers();
            }
            parent = parent.getParent();
        }
        return null;
    }
}

