/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNameBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTName
extends CPPASTNameBase
implements IASTCompletionContext {
    private char[] name;

    public CPPASTName(char[] name) {
        this.name = name;
    }

    public CPPASTName() {
        this.name = CharArrayUtils.EMPTY;
    }

    public CPPASTName copy() {
        CPPASTName copy = new CPPASTName(this.name == null ? null : (char[])this.name.clone());
        copy.setOffsetAndLength(this);
        return copy;
    }

    protected IBinding createIntermediateBinding() {
        return CPPVisitor.createBinding(this);
    }

    public IASTCompletionContext getCompletionContext() {
        IASTNode node = this.getParent();
        while (node != null) {
            if (node instanceof IASTCompletionContext) {
                return (IASTCompletionContext)((Object)node);
            }
            node = node.getParent();
        }
        if (this.getLength() > 0) {
            return this;
        }
        return null;
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        IASTNode parent = this.getParent();
        if (parent instanceof ICPPASTElaboratedTypeSpecifier) {
            ICPPASTElaboratedTypeSpecifier specifier = (ICPPASTElaboratedTypeSpecifier)parent;
            int kind = specifier.getKind();
            switch (kind) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    return null;
                }
            }
            IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix);
            return this.filterByElaboratedTypeSpecifier(kind, bindings);
        }
        if (parent instanceof IASTDeclarator) {
            Object[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix);
            int i = 0;
            while (i < bindings.length) {
                if (!(bindings[i] instanceof ICPPNamespace) && !(bindings[i] instanceof ICPPClassType)) {
                    bindings[i] = null;
                }
                ++i;
            }
            return (IBinding[])ArrayUtil.removeNulls(IBinding.class, bindings);
        }
        return null;
    }

    private IBinding[] filterByElaboratedTypeSpecifier(int kind, IBinding[] bindings) {
        int i = 0;
        while (i < bindings.length) {
            if (!(bindings[i] instanceof ICPPNamespace)) {
                if (bindings[i] instanceof ICPPClassType) {
                    ICPPClassType type = (ICPPClassType)bindings[i];
                    try {
                        switch (type.getKey()) {
                            case 1: {
                                if (kind != 1) {
                                    bindings[i] = null;
                                }
                                break;
                            }
                            case 2: {
                                if (kind != 2) {
                                    bindings[i] = null;
                                }
                                break;
                            }
                            case 3: {
                                if (kind == 3) break;
                                bindings[i] = null;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                    catch (DOMException e) {
                        bindings[i] = null;
                        CCorePlugin.log(e);
                    }
                } else {
                    bindings[i] = null;
                }
            }
            ++i;
        }
        return (IBinding[])ArrayUtil.removeNulls(IBinding.class, bindings);
    }

    public char[] toCharArray() {
        return this.name;
    }

    public char[] getSimpleID() {
        return this.name;
    }

    public char[] getLookupKey() {
        return this.name;
    }

    public void setName(char[] name) {
        this.assertNotFrozen();
        this.name = name;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitNames) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitNames) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }
}

