/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTTypeIdExpression
extends ASTNode
implements ICPPASTTypeIdExpression {
    private int op;
    private IASTTypeId typeId;

    public CPPASTTypeIdExpression() {
    }

    public CPPASTTypeIdExpression(int op, IASTTypeId typeId) {
        this.op = op;
        this.setTypeId(typeId);
    }

    public CPPASTTypeIdExpression copy() {
        CPPASTTypeIdExpression copy = new CPPASTTypeIdExpression(this.op, this.typeId == null ? null : this.typeId.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public int getOperator() {
        return this.op;
    }

    public void setOperator(int value) {
        this.assertNotFrozen();
        this.op = value;
    }

    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.typeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.typeId != null && !this.typeId.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public IType getExpressionType() {
        switch (this.getOperator()) {
            case 0: {
                return CPPVisitor.get_SIZE_T(this);
            }
            case 1: {
                return CPPVisitor.get_type_info(this);
            }
        }
        return CPPVisitor.createType(this.getTypeId());
    }
}

