/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitConstructor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ImplicitsAnalysis;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPClassScope
extends CPPScope
implements ICPPClassScope {
    private ICPPMethod[] implicits = null;

    public CPPClassScope(ICPPASTCompositeTypeSpecifier physicalNode) {
        super(physicalNode);
        ((CPPASTCompositeTypeSpecifier)physicalNode).setScope(this);
        this.createImplicitMembers();
    }

    public EScopeKind getKind() {
        return EScopeKind.eClassType;
    }

    private void createImplicitMembers() {
        CPPImplicitMethod m;
        CPPImplicitConstructor m2;
        ICPPASTCompositeTypeSpecifier compTypeSpec = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName name = compTypeSpec.getName().getLastName();
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof ICPPClassType)) {
            return;
        }
        ICPPClassType clsType = (ICPPClassType)binding;
        if (clsType instanceof ICPPClassTemplate) {
            try {
                clsType = CPPTemplates.instantiateWithinClassTemplate((ICPPClassTemplate)clsType);
            }
            catch (DOMException dOMException) {}
        }
        char[] className = name.getLookupKey();
        IParameter[] voidPs = new IParameter[]{new CPPParameter(CPPSemantics.VOID_TYPE)};
        CPPReferenceType pType = new CPPReferenceType(SemanticUtil.addQualifiers(clsType, true, false));
        IParameter[] ps = new IParameter[]{new CPPParameter(pType)};
        int i = 0;
        ImplicitsAnalysis ia = new ImplicitsAnalysis(compTypeSpec);
        this.implicits = new ICPPMethod[ia.getImplicitsToDeclareCount()];
        if (!ia.hasUserDeclaredConstructor()) {
            m2 = new CPPImplicitConstructor(this, className, voidPs);
            this.implicits[i++] = m2;
            this.addBinding(m2);
        }
        if (!ia.hasUserDeclaredCopyConstructor()) {
            m2 = new CPPImplicitConstructor(this, className, ps);
            this.implicits[i++] = m2;
            this.addBinding(m2);
        }
        if (!ia.hasUserDeclaredCopyAssignmentOperator()) {
            CPPReferenceType refType = new CPPReferenceType(clsType);
            ICPPFunctionType ft = CPPVisitor.createImplicitFunctionType(refType, ps, false, false);
            m = new CPPImplicitMethod(this, OverloadableOperator.ASSIGN.toCharArray(), ft, ps);
            this.implicits[i++] = m;
            this.addBinding(m);
        }
        if (!ia.hasUserDeclaredDestructor()) {
            ICPPFunctionType ft = CPPVisitor.createImplicitFunctionType(new CPPBasicType(0, 0), voidPs, false, false);
            char[] dtorName = CharArrayUtils.concat("~".toCharArray(), className);
            m = new CPPImplicitMethod(this, dtorName, ft, voidPs);
            this.implicits[i++] = m;
            this.addBinding(m);
        }
    }

    public IScope getParent() {
        ICPPASTCompositeTypeSpecifier compType = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName compName = compType.getName().getLastName();
        return CPPVisitor.getContainingNonTemplateScope(compName);
    }

    public void addBinding(IBinding binding) {
        if (binding instanceof ICPPConstructor) {
            this.addConstructor(binding);
            return;
        }
        super.addBinding(binding);
    }

    public void addName(IASTName name) throws DOMException {
        IASTNode parent;
        if (!name.isActive()) {
            return;
        }
        if (name instanceof ICPPASTQualifiedName) {
            IBinding b = this.getClassType();
            ICPPASTQualifiedName qname = (ICPPASTQualifiedName)name;
            IASTName[] names = qname.getNames();
            int i = names.length - 2;
            while (i >= 0) {
                if (b == null || !CharArrayUtils.equals(names[i].getLookupKey(), b.getNameCharArray())) {
                    return;
                }
                b = b.getOwner();
                --i;
            }
            if (qname.isFullyQualified() && b != null) {
                return;
            }
        }
        if ((parent = name.getParent()) instanceof IASTDeclarator && CPPVisitor.isConstructor(this, (IASTDeclarator)parent)) {
            this.addConstructor(name);
            return;
        }
        super.addName(name);
    }

    private void addConstructor(Object constructor) {
        Object o;
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        if ((o = this.bindings.get(CONSTRUCTOR_KEY)) != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(constructor);
            } else {
                ObjectSet<Object> set = new ObjectSet<Object>(2);
                set.put(o);
                set.put(constructor);
                this.bindings.put(CONSTRUCTOR_KEY, set);
            }
        } else {
            this.bindings.put(CONSTRUCTOR_KEY, constructor);
        }
    }

    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) throws DOMException {
        char[] c = name.getLookupKey();
        ICPPASTCompositeTypeSpecifier compType = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName compName = compType.getName().getLastName();
        if (compName instanceof ICPPASTTemplateId) {
            compName = ((ICPPASTTemplateId)compName).getTemplateName();
        }
        if (CharArrayUtils.equals(c, compName.getLookupKey())) {
            if (CPPClassScope.isConstructorReference(name)) {
                return CPPSemantics.resolveAmbiguities(name, this.getConstructors(name, resolve));
            }
            return compName.resolveBinding();
        }
        return super.getBinding(name, resolve, fileSet);
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet, boolean checkPointOfDecl) throws DOMException {
        char[] c = name.getLookupKey();
        ICPPASTCompositeTypeSpecifier compType = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName compName = compType.getName().getLastName();
        if (compName instanceof ICPPASTTemplateId) {
            compName = ((ICPPASTTemplateId)compName).getTemplateName();
        }
        Object[] result = null;
        if (!prefixLookup && CharArrayUtils.equals(c, compName.getLookupKey()) || prefixLookup && CharArrayUtils.equals(compName.getLookupKey(), 0, c.length, c, true)) {
            if (CPPClassScope.isConstructorReference(name)) {
                result = (IBinding[])ArrayUtil.addAll(IBinding.class, result, this.getConstructors(name, resolve));
            }
            result = (IBinding[])ArrayUtil.append(IBinding.class, result, compName.resolveBinding());
            if (!prefixLookup) {
                return (IBinding[])ArrayUtil.trim(IBinding.class, result);
            }
        }
        result = (IBinding[])ArrayUtil.addAll(IBinding.class, result, super.getBindings(name, resolve, prefixLookup, fileSet, checkPointOfDecl));
        return (IBinding[])ArrayUtil.trim(IBinding.class, result);
    }

    protected static boolean shouldResolve(boolean force, IASTName candidate, IASTName forName) {
        if (!force || candidate == forName) {
            return false;
        }
        if (forName == null) {
            return true;
        }
        return forName.isReference() || CPPSemantics.declaredBefore(candidate, forName, false);
    }

    public ICPPConstructor[] getConstructors() {
        return this.getConstructors(null, true);
    }

    private ICPPConstructor[] getConstructors(IASTName forName, boolean forceResolve) {
        this.populateCache();
        CharArrayObjectMap nameMap = this.bindings;
        if (nameMap == null) {
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }
        Object o = nameMap.get(CONSTRUCTOR_KEY);
        if (o != null) {
            IBinding binding = null;
            if (o instanceof ObjectSet) {
                ObjectSet set = (ObjectSet)o;
                Object[] bs = null;
                int i = 0;
                while (i < set.size()) {
                    Object obj = set.keyAt(i);
                    if (obj instanceof IASTName) {
                        IASTName n = (IASTName)obj;
                        IBinding iBinding = binding = CPPClassScope.shouldResolve(forceResolve, n, forName) ? n.resolveBinding() : n.getBinding();
                        if (binding instanceof ICPPConstructor) {
                            bs = (IBinding[])ArrayUtil.append(ICPPConstructor.class, bs, binding);
                        }
                    } else if (obj instanceof ICPPConstructor) {
                        bs = (IBinding[])ArrayUtil.append(ICPPConstructor.class, bs, obj);
                    }
                    ++i;
                }
                return (ICPPConstructor[])ArrayUtil.trim(ICPPConstructor.class, bs);
            }
            if (o instanceof IASTName) {
                if (CPPClassScope.shouldResolve(forceResolve, (IASTName)o, forName) || ((IASTName)o).getBinding() != null) {
                    nameMap.put(CONSTRUCTOR_KEY, o);
                    binding = ((IASTName)o).resolveBinding();
                }
            } else if (o instanceof IBinding) {
                binding = (IBinding)o;
            }
            if (binding != null && binding instanceof ICPPConstructor) {
                return new ICPPConstructor[]{(ICPPConstructor)binding};
            }
        }
        return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
    }

    public IBinding[] find(String name) throws DOMException {
        char[] n = name.toCharArray();
        ICPPASTCompositeTypeSpecifier compType = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName compName = compType.getName().getLastName();
        if (compName instanceof ICPPASTTemplateId) {
            compName = ((ICPPASTTemplateId)compName).getTemplateName();
        }
        if (CharArrayUtils.equals(compName.getLookupKey(), n)) {
            return new IBinding[]{compName.resolveBinding()};
        }
        return super.find(name);
    }

    public static boolean isConstructorReference(IASTName name) {
        if (name.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return false;
        }
        IASTNode node = name.getParent();
        if (node instanceof ICPPASTTemplateId) {
            return false;
        }
        if (node instanceof ICPPASTQualifiedName) {
            if (((ICPPASTQualifiedName)node).getLastName() == name) {
                node = node.getParent();
            } else {
                return false;
            }
        }
        if (node instanceof IASTDeclSpecifier) {
            IASTNode parent = node.getParent();
            return parent instanceof IASTTypeId && parent.getParent() instanceof ICPPASTNewExpression;
        }
        return !(node instanceof IASTFieldReference);
    }

    public ICPPClassType getClassType() {
        ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName name = compSpec.getName();
        IBinding binding = name.resolveBinding();
        if (binding instanceof ICPPClassType) {
            return (ICPPClassType)binding;
        }
        return new CPPClassType.CPPClassTypeProblem((IASTNode)name, 10, name.toCharArray());
    }

    public ICPPMethod[] getImplicitMethods() {
        if (this.implicits == null) {
            this.implicits = new ICPPMethod[]{new CPPMethod.CPPMethodProblem(null, 5, CharArrayUtils.EMPTY)};
        }
        return this.implicits;
    }

    public IName getScopeName() {
        IASTNode node = this.getPhysicalNode();
        if (node instanceof ICPPASTCompositeTypeSpecifier) {
            return ((ICPPASTCompositeTypeSpecifier)node).getName();
        }
        return null;
    }
}

