/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPFunctionTemplate
extends CPPTemplateDefinition
implements ICPPFunctionTemplate,
ICPPFunction,
ICPPInternalFunction {
    protected ICPPFunctionType type = null;

    public CPPFunctionTemplate(IASTName name) {
        super(name);
    }

    public void addDefinition(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        this.updateFunctionParameterBindings((IASTName)node);
        super.addDefinition(node);
    }

    public void addDeclaration(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        this.updateFunctionParameterBindings((IASTName)node);
        super.addDeclaration(node);
    }

    private void updateFunctionParameterBindings(IASTName declName) {
        IASTName defName = this.definition != null ? this.definition : this.declarations[0];
        ICPPASTFunctionDeclarator orig = this.getDeclaratorByName(defName);
        IASTParameterDeclaration[] ops = orig.getParameters();
        IASTParameterDeclaration[] nps = this.getDeclaratorByName(declName).getParameters();
        CPPParameter temp = null;
        int i = 0;
        while (i < nps.length) {
            temp = (CPPParameter)ASTQueries.findInnermostDeclarator(ops[i].getDeclarator()).getName().getBinding();
            if (temp != null) {
                IASTName name = ASTQueries.findInnermostDeclarator(nps[i].getDeclarator()).getName();
                name.setBinding(temp);
                ASTInternal.addDeclaration(temp, name);
            }
            ++i;
        }
    }

    public IParameter[] getParameters() {
        IASTName name = this.getTemplateName();
        ICPPASTFunctionDeclarator fdecl = this.getDeclaratorByName(name);
        if (fdecl != null) {
            IASTParameterDeclaration[] params = fdecl.getParameters();
            int size = params.length;
            IParameter[] result = new IParameter[size];
            if (size > 0) {
                int i = 0;
                while (i < size) {
                    IASTParameterDeclaration p = params[i];
                    IASTName pname = ASTQueries.findInnermostDeclarator(p.getDeclarator()).getName();
                    IBinding binding = pname.resolveBinding();
                    result[i] = binding instanceof IParameter ? (IParameter)binding : new CPPParameter.CPPParameterProblem(p, 5, pname.toCharArray());
                    ++i;
                }
            }
            return result;
        }
        return null;
    }

    public IScope getFunctionScope() {
        return null;
    }

    public ICPPFunctionType getType() {
        if (this.type == null) {
            IASTName name = this.getTemplateName();
            IASTNode parent = name.getParent();
            while (parent.getParent() instanceof IASTDeclarator) {
                parent = parent.getParent();
            }
            IType temp = CPPVisitor.createType((IASTDeclarator)parent);
            if (temp instanceof ICPPFunctionType) {
                this.type = (ICPPFunctionType)temp;
            }
        }
        return this.type;
    }

    public boolean hasStorageClass(int storage) {
        IASTName name = (IASTName)this.getDefinition();
        IASTNode[] ns = this.getDeclarations();
        int i = -1;
        do {
            if (name == null) continue;
            IASTNode parent = name.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (declSpec == null || declSpec.getStorageClass() != storage) continue;
            return true;
        } while (ns != null && ++i < ns.length && (name = (IASTName)ns[i]) != null);
        return false;
    }

    public IBinding resolveParameter(IASTParameterDeclaration param) {
        IASTName n;
        ICPPASTFunctionDeclarator fdecl;
        IASTName name = ASTQueries.findInnermostDeclarator(param.getDeclarator()).getName();
        IBinding binding = name.getBinding();
        if (binding != null) {
            return binding;
        }
        ICPPASTFunctionDeclarator fdtor = (ICPPASTFunctionDeclarator)param.getParent();
        IASTParameterDeclaration[] ps = fdtor.getParameters();
        int i = 0;
        while (i < ps.length) {
            if (param == ps[i]) break;
            ++i;
        }
        binding = new CPPParameter(name);
        IASTParameterDeclaration temp = null;
        if (this.definition != null && (fdecl = this.getDeclaratorByName(this.definition)) != null && (n = ASTQueries.findInnermostDeclarator((temp = fdecl.getParameters()[i]).getDeclarator()).getName()) != name) {
            n.setBinding(binding);
            ASTInternal.addDeclaration(binding, n);
        }
        if (this.declarations != null) {
            int j = 0;
            while (j < this.declarations.length && this.declarations[j] != null) {
                IASTName n2;
                ICPPASTFunctionDeclarator fdecl2 = this.getDeclaratorByName(this.declarations[j]);
                if (fdecl2 != null && (n2 = ASTQueries.findInnermostDeclarator((temp = fdecl2.getParameters()[i]).getDeclarator()).getName()) != name) {
                    n2.setBinding(binding);
                    ASTInternal.addDeclaration(binding, n2);
                }
                ++j;
            }
        }
        return binding;
    }

    public boolean isStatic() {
        return this.hasStorageClass(3);
    }

    public boolean isMutable() {
        return this.hasStorageClass(6);
    }

    public boolean isInline() throws DOMException {
        IASTName name = (IASTName)this.getDefinition();
        IASTNode[] ns = this.getDeclarations();
        int i = -1;
        do {
            if (name == null) continue;
            IASTNode parent = name.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (declSpec == null || !declSpec.isInline()) continue;
            return true;
        } while (ns != null && ++i < ns.length && (name = (IASTName)ns[i]) != null);
        return false;
    }

    public boolean isExternC() throws DOMException {
        if (CPPVisitor.isExternC(this.getDefinition())) {
            return true;
        }
        IASTNode[] ds = this.getDeclarations();
        if (ds != null) {
            IASTNode[] iASTNodeArray = ds;
            int n = ds.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode element = iASTNodeArray[n2];
                if (CPPVisitor.isExternC(element)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isExtern() {
        return this.hasStorageClass(2);
    }

    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    public boolean takesVarArgs() {
        IASTName[] ns;
        ICPPASTFunctionDeclarator fdecl = this.getDeclaratorByName(this.getDefinition());
        if (fdecl == null && (ns = (IASTName[])this.getDeclarations()) != null && ns.length > 0) {
            int i = 0;
            while (i < ns.length && fdecl == null) {
                IASTName name = ns[i];
                fdecl = this.getDeclaratorByName(name);
                ++i;
            }
        }
        if (fdecl != null) {
            return fdecl.takesVarArgs();
        }
        return false;
    }

    private ICPPASTFunctionDeclarator getDeclaratorByName(IASTNode node) {
        while (node != null) {
            if (!((node = node.getParent()) instanceof ICPPASTFunctionDeclarator)) continue;
            return (ICPPASTFunctionDeclarator)node;
        }
        return null;
    }

    public boolean isStatic(boolean resolveAll) {
        return this.hasStorageClass(3);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        ICPPFunctionType t = this.getType();
        result.append(t != null ? ASTTypeUtil.getParameterTypeString(t) : "()");
        return result.toString();
    }

    public IType[] getExceptionSpecification() throws DOMException {
        ICPPASTFunctionDeclarator declarator = this.getDeclaratorByName(this.getDefinition());
        if (declarator != null) {
            IASTTypeId[] astTypeIds = declarator.getExceptionSpecification();
            if (astTypeIds.equals(ICPPASTFunctionDeclarator.NO_EXCEPTION_SPECIFICATION)) {
                return null;
            }
            if (astTypeIds.equals(IASTTypeId.EMPTY_TYPEID_ARRAY)) {
                return IType.EMPTY_TYPE_ARRAY;
            }
            IType[] typeIds = new IType[astTypeIds.length];
            int i = 0;
            while (i < astTypeIds.length) {
                typeIds[i] = CPPVisitor.createType(astTypeIds[i]);
                ++i;
            }
            return typeIds;
        }
        return null;
    }

    public static final class CPPFunctionTemplateProblem
    extends ProblemBinding
    implements ICPPFunctionTemplate,
    ICPPFunction {
        public CPPFunctionTemplateProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public ICPPTemplateParameter[] getTemplateParameters() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPClassTemplatePartialSpecialization[] getTemplateSpecializations() throws DOMException {
            throw new DOMException(this);
        }

        public String[] getQualifiedName() throws DOMException {
            throw new DOMException(this);
        }

        public char[][] getQualifiedNameCharArray() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isGloballyQualified() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isMutable() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isInline() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isExternC() throws DOMException {
            throw new DOMException(this);
        }

        public IParameter[] getParameters() throws DOMException {
            throw new DOMException(this);
        }

        public IScope getFunctionScope() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPFunctionType getType() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isStatic() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isExtern() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isAuto() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isRegister() throws DOMException {
            throw new DOMException(this);
        }

        public boolean takesVarArgs() throws DOMException {
            throw new DOMException(this);
        }

        public IType[] getExceptionSpecification() throws DOMException {
            throw new DOMException(this);
        }
    }
}

