/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNamespaceScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.index.IIndexScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPPScopeMapper {
    private final HashMap<IIndexScope, IScope> fMappedScopes = new HashMap();
    private final HashMap<String, NamespaceScopeWrapper> fNamespaceWrappers = new HashMap();
    private final Map<String, List<UsingDirectiveWrapper>> fPerName = new HashMap<String, List<UsingDirectiveWrapper>>();
    private final CPPASTTranslationUnit fTu;
    protected CharArrayMap<IASTName[]> fClasses;

    public CPPScopeMapper(CPPASTTranslationUnit tu) {
        this.fTu = tu;
    }

    public void registerAdditionalDirectives(int offset, List<ICPPUsingDirective> usingDirectives) {
        if (!usingDirectives.isEmpty()) {
            for (ICPPUsingDirective ud : usingDirectives) {
                IScope container = ud.getContainingScope();
                try {
                    String name = this.getReverseQualifiedName(container);
                    List<UsingDirectiveWrapper> list = this.fPerName.get(name);
                    if (list == null) {
                        list = new LinkedList<UsingDirectiveWrapper>();
                        this.fPerName.put(name, list);
                    }
                    list.add(new UsingDirectiveWrapper(offset, ud));
                }
                catch (DOMException dOMException) {}
            }
        }
    }

    public void handleAdditionalDirectives(ICPPNamespaceScope scope) {
        assert (!(scope instanceof IIndexScope));
        if (this.fPerName.isEmpty()) {
            return;
        }
        try {
            String qname = this.getReverseQualifiedName(scope);
            List<UsingDirectiveWrapper> candidates = this.fPerName.remove(qname);
            if (candidates != null) {
                for (UsingDirectiveWrapper ud : candidates) {
                    scope.addUsingDirective(ud);
                }
            }
        }
        catch (DOMException dOMException) {}
    }

    private String getReverseQualifiedName(IScope scope) throws DOMException {
        CPPNamespaceScope tuscope = this.fTu.getScope();
        if (scope == tuscope || scope == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        IName scopeName = scope.getScopeName();
        if (scopeName != null) {
            buf.append(scopeName.getSimpleID());
        }
        scope = scope.getParent();
        while (scope != null && scope != tuscope) {
            buf.append(':');
            scopeName = scope.getScopeName();
            if (scopeName != null) {
                buf.append(scope.getScopeName().getSimpleID());
            }
            scope = scope.getParent();
        }
        return buf.toString();
    }

    public IScope mapToASTScope(IIndexScope scope) {
        if (scope == null) {
            return this.fTu.getScope();
        }
        if (scope instanceof ICPPNamespaceScope) {
            IScope result = this.fMappedScopes.get(scope);
            if (result == null) {
                result = this.fTu.getScope().findNamespaceScope(scope);
                if (result == null) {
                    result = this.wrapNamespaceScope((ICPPNamespaceScope)((Object)scope));
                }
                this.fMappedScopes.put(scope, result);
            }
            return result;
        }
        return scope;
    }

    private IScope wrapNamespaceScope(ICPPNamespaceScope scope) {
        try {
            String rqname = this.getReverseQualifiedName(scope);
            NamespaceScopeWrapper result = this.fNamespaceWrappers.get(rqname);
            if (result == null) {
                result = new NamespaceScopeWrapper(this.getCompositeNamespaceScope(scope));
                this.fNamespaceWrappers.put(rqname, result);
            }
            return result;
        }
        catch (DOMException dOMException) {
            assert (false);
            return null;
        }
    }

    private ICPPNamespaceScope getCompositeNamespaceScope(ICPPNamespaceScope scope) throws DOMException {
        IIndexBinding binding;
        if (scope instanceof IIndexScope && (binding = this.fTu.getIndex().adaptBinding(((IIndexScope)((Object)scope)).getScopeBinding())) instanceof ICPPNamespace) {
            scope = ((ICPPNamespace)((Object)binding)).getNamespaceScope();
        }
        return scope;
    }

    public ICPPClassType mapToAST(ICPPClassType type) {
        IASTName[] names;
        if (type instanceof ICPPTemplateInstance) {
            IBinding mapped;
            ICPPTemplateInstance inst = (ICPPTemplateInstance)((Object)type);
            ICPPTemplateDefinition template = inst.getTemplateDefinition();
            if (template instanceof IIndexBinding && template instanceof ICPPClassType && (mapped = this.mapToAST((ICPPClassType)((Object)template))) != template && mapped instanceof ICPPClassType && (mapped = CPPTemplates.instantiate((ICPPClassTemplate)mapped, inst.getTemplateArguments())) instanceof ICPPClassType) {
                return mapped;
            }
            return type;
        }
        if (this.fClasses == null) {
            this.fClasses = new CharArrayMap();
            this.fTu.accept(new Visitor());
        }
        if ((names = this.fClasses.get(type.getNameCharArray())) != null) {
            IASTName[] iASTNameArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPClassType mapped;
                IASTName name = iASTNameArray[n2];
                if (name == null) break;
                IBinding b = name.resolveBinding();
                if (b instanceof ICPPClassType && (mapped = (ICPPClassType)b).isSameType(type)) {
                    return mapped;
                }
                ++n2;
            }
        }
        return type;
    }

    private class NamespaceScopeWrapper
    implements ICPPNamespaceScope {
        private final ICPPNamespaceScope fScope;
        private ArrayList<ICPPUsingDirective> fUsingDirectives;

        public NamespaceScopeWrapper(ICPPNamespaceScope scope) {
            this.fScope = scope;
        }

        public EScopeKind getKind() {
            return this.fScope.getKind();
        }

        public IBinding[] find(String name) throws DOMException {
            return this.fScope.find(name);
        }

        public IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
            return this.fScope.getBinding(name, resolve);
        }

        public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet acceptLocalBindings) throws DOMException {
            return this.fScope.getBinding(name, resolve, acceptLocalBindings);
        }

        public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup) throws DOMException {
            return this.fScope.getBindings(name, resolve, prefixLookup);
        }

        public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet acceptLocalBindings) throws DOMException {
            return this.fScope.getBindings(name, resolve, prefixLookup, acceptLocalBindings);
        }

        public IScope getParent() throws DOMException {
            IScope parent = this.fScope.getParent();
            if (parent instanceof IIndexScope) {
                return CPPScopeMapper.this.mapToASTScope((IIndexScope)parent);
            }
            return CPPScopeMapper.this.fTu.getScope();
        }

        public IName getScopeName() throws DOMException {
            return this.fScope.getScopeName();
        }

        public void addUsingDirective(ICPPUsingDirective usingDirective) throws DOMException {
            if (this.fUsingDirectives == null) {
                this.fUsingDirectives = new ArrayList(1);
            }
            this.fUsingDirectives.add(usingDirective);
        }

        public ICPPUsingDirective[] getUsingDirectives() throws DOMException {
            if (this.fUsingDirectives == null) {
                return ICPPUsingDirective.EMPTY_ARRAY;
            }
            return this.fUsingDirectives.toArray(new ICPPUsingDirective[this.fUsingDirectives.size()]);
        }
    }

    private class UsingDirectiveWrapper
    implements ICPPUsingDirective {
        private final int fOffset;
        private final ICPPUsingDirective fDirective;

        public UsingDirectiveWrapper(int offset, ICPPUsingDirective ud) {
            this.fOffset = offset;
            this.fDirective = ud;
        }

        public IScope getContainingScope() {
            IScope scope = this.fDirective.getContainingScope();
            if (scope == null) {
                return CPPScopeMapper.this.fTu.getScope();
            }
            return scope;
        }

        public ICPPNamespaceScope getNominatedScope() throws DOMException {
            return this.fDirective.getNominatedScope();
        }

        public int getPointOfDeclaration() {
            return this.fOffset;
        }
    }

    private class Visitor
    extends ASTVisitor {
        Visitor() {
            this.shouldVisitDeclarations = true;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTSimpleDeclaration) {
                IASTDeclSpecifier declspec = ((IASTSimpleDeclaration)declaration).getDeclSpecifier();
                if (declspec instanceof IASTCompositeTypeSpecifier) {
                    IASTCompositeTypeSpecifier cts = (IASTCompositeTypeSpecifier)declspec;
                    IASTName name = cts.getName();
                    char[] nameChars = name.getLookupKey();
                    if (nameChars.length > 0) {
                        Object[] names = CPPScopeMapper.this.fClasses.get(nameChars);
                        names = (IASTName[])ArrayUtil.append(IASTName.class, names, name);
                        CPPScopeMapper.this.fClasses.put(nameChars, (IASTName[])names);
                    }
                    return 3;
                }
                return 1;
            }
            if (declaration instanceof IASTASMDeclaration || declaration instanceof IASTFunctionDefinition) {
                return 1;
            }
            return 3;
        }
    }
}

