/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPTemplateTemplateParameter
extends CPPTemplateParameter
implements ICPPTemplateTemplateParameter,
ICPPClassType,
ICPPInternalTemplate,
ICPPUnknownBinding,
ICPPUnknownType {
    private ICPPTemplateParameter[] templateParameters;
    private ObjectMap instances;
    private ICPPScope unknownScope;

    public CPPTemplateTemplateParameter(IASTName name) {
        super(name);
    }

    public ICPPScope asScope() {
        if (this.unknownScope == null) {
            IASTName n = null;
            IASTName[] nodes = this.getDeclarations();
            if (nodes != null && nodes.length > 0) {
                n = nodes[0];
            }
            this.unknownScope = new CPPUnknownScope(this, n);
        }
        return this.unknownScope;
    }

    public ICPPTemplateParameter[] getTemplateParameters() {
        if (this.templateParameters == null) {
            ICPPASTTemplatedTypeTemplateParameter template = (ICPPASTTemplatedTypeTemplateParameter)this.getPrimaryDeclaration().getParent();
            ICPPASTTemplateParameter[] params = template.getTemplateParameters();
            Object[] result = null;
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTTemplateParameter param = iCPPASTTemplateParameterArray[n2];
                IBinding binding = CPPTemplates.getTemplateParameterName(param).resolveBinding();
                if (binding instanceof ICPPTemplateParameter) {
                    result = (ICPPTemplateParameter[])ArrayUtil.append(ICPPTemplateParameter.class, result, binding);
                }
                ++n2;
            }
            this.templateParameters = (ICPPTemplateParameter[])ArrayUtil.trim(ICPPTemplateParameter.class, result);
        }
        return this.templateParameters;
    }

    public IBinding resolveTemplateParameter(ICPPTemplateParameter templateParameter) {
        return templateParameter;
    }

    public ICPPClassTemplatePartialSpecialization[] getTemplateSpecializations() throws DOMException {
        return ICPPClassTemplatePartialSpecialization.EMPTY_PARTIAL_SPECIALIZATION_ARRAY;
    }

    public IType getDefault() {
        IASTName[] nds = this.getDeclarations();
        if (nds == null || nds.length == 0) {
            return null;
        }
        IASTName[] iASTNameArray = nds;
        int n = nds.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName nd = iASTNameArray[n2];
            if (nd != null) {
                ICPPASTTemplatedTypeTemplateParameter param;
                IASTExpression value;
                IASTNode parent = nd.getParent();
                assert (parent instanceof ICPPASTTemplatedTypeTemplateParameter);
                if (parent instanceof ICPPASTTemplatedTypeTemplateParameter && (value = (param = (ICPPASTTemplatedTypeTemplateParameter)parent).getDefaultValue()) != null) {
                    return CPPVisitor.createType(value);
                }
            }
            ++n2;
        }
        return null;
    }

    public ICPPTemplateArgument getDefaultValue() {
        IType d = this.getDefault();
        if (d == null) {
            return null;
        }
        return new CPPTemplateArgument(d);
    }

    public ICPPBase[] getBases() {
        return ICPPBase.EMPTY_BASE_ARRAY;
    }

    public IField[] getFields() throws DOMException {
        return IField.EMPTY_FIELD_ARRAY;
    }

    public IField findField(String name) throws DOMException {
        return null;
    }

    public ICPPField[] getDeclaredFields() throws DOMException {
        return ICPPField.EMPTY_CPPFIELD_ARRAY;
    }

    public ICPPMethod[] getMethods() throws DOMException {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    public ICPPMethod[] getDeclaredMethods() throws DOMException {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    public ICPPConstructor[] getConstructors() {
        return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
    }

    public IBinding[] getFriends() throws DOMException {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    public ICPPClassType[] getNestedClasses() {
        return ICPPClassType.EMPTY_CLASS_ARRAY;
    }

    public int getKey() throws DOMException {
        return 0;
    }

    public IScope getCompositeScope() throws DOMException {
        return null;
    }

    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (!(type instanceof ICPPTemplateTemplateParameter)) {
            return false;
        }
        return this.getParameterID() == ((ICPPTemplateParameter)((Object)type)).getParameterID();
    }

    public ICPPClassTemplatePartialSpecialization[] getPartialSpecializations() throws DOMException {
        return ICPPClassTemplatePartialSpecialization.EMPTY_PARTIAL_SPECIALIZATION_ARRAY;
    }

    public final void addInstance(ICPPTemplateArgument[] arguments, ICPPTemplateInstance instance) {
        if (this.instances == null) {
            this.instances = new ObjectMap(2);
        }
        String key = ASTTypeUtil.getArgumentListString(arguments, true);
        this.instances.put(key, instance);
    }

    public final ICPPTemplateInstance getInstance(ICPPTemplateArgument[] arguments) {
        if (this.instances != null) {
            String key = ASTTypeUtil.getArgumentListString(arguments, true);
            return (ICPPTemplateInstance)this.instances.get(key);
        }
        return null;
    }

    public ICPPTemplateInstance[] getAllInstances() {
        if (this.instances != null) {
            ICPPTemplateInstance[] result = new ICPPTemplateInstance[this.instances.size()];
            int i = 0;
            while (i < this.instances.size()) {
                result[i] = (ICPPTemplateInstance)this.instances.getAt(i);
                ++i;
            }
            return result;
        }
        return ICPPTemplateInstance.EMPTY_TEMPLATE_INSTANCE_ARRAY;
    }

    public IASTName getUnknownName() {
        return new CPPASTName(this.getNameCharArray());
    }

    public boolean isAnonymous() {
        return false;
    }

    public ICPPDeferredClassInstance asDeferredInstance() {
        return null;
    }
}

