/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTLiteralNode;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.DeclSpecWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.DeclarationWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.DeclaratorWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ExpressionWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.InitializerWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.MacroExpansionHandler;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.NameWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.StatementWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.TemplateParameterWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class ASTWriterVisitor
extends CPPASTVisitor {
    protected Scribe scribe = new Scribe();
    protected NodeCommentMap commentMap;
    protected ExpressionWriter expWriter;
    protected DeclSpecWriter declSpecWriter;
    protected StatementWriter statementWriter;
    protected DeclaratorWriter declaratorWriter;
    protected DeclarationWriter declarationWriter;
    protected InitializerWriter initializerWriter;
    protected NameWriter nameWriter;
    protected TemplateParameterWriter tempParameterWriter;
    protected MacroExpansionHandler macroHandler;

    public ASTWriterVisitor(NodeCommentMap commentMap) {
        this("", commentMap);
    }

    public ASTWriterVisitor(String givenIndentation, NodeCommentMap commentMap) {
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitNames = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitDeclSpecifiers = true;
        this.shouldVisitDeclarators = true;
        this.shouldVisitArrayModifiers = true;
        this.shouldVisitInitializers = true;
        this.shouldVisitBaseSpecifiers = true;
        this.shouldVisitNamespaces = true;
        this.shouldVisitTemplateParameters = true;
        this.shouldVisitParameterDeclarations = true;
        this.shouldVisitTranslationUnit = true;
        this.scribe.setGivenIndentation(givenIndentation);
        this.init(commentMap);
        this.commentMap = commentMap;
    }

    private void init(NodeCommentMap commentMap) {
        this.macroHandler = new MacroExpansionHandler(this.scribe);
        this.statementWriter = new StatementWriter(this.scribe, this, commentMap);
        this.declaratorWriter = new DeclaratorWriter(this.scribe, this, commentMap);
        this.declarationWriter = new DeclarationWriter(this.scribe, this, commentMap);
        this.declSpecWriter = new DeclSpecWriter(this.scribe, this, commentMap);
        this.expWriter = new ExpressionWriter(this.scribe, this, this.macroHandler, commentMap);
        this.initializerWriter = new InitializerWriter(this.scribe, this, commentMap);
        this.nameWriter = new NameWriter(this.scribe, this, commentMap);
        this.tempParameterWriter = new TemplateParameterWriter(this.scribe, this, commentMap);
    }

    public String toString() {
        return this.scribe.toString();
    }

    public int leave(IASTTranslationUnit tu) {
        for (IASTComment comment : this.commentMap.getFreestandingCommentsForNode(tu)) {
            this.scribe.print(comment.getComment());
            this.scribe.newLine();
        }
        return super.leave(tu);
    }

    private void writeLeadingComments(IASTNode node) {
        for (IASTComment comment : this.commentMap.getLeadingCommentsForNode(node)) {
            this.scribe.print(comment.getComment());
            this.scribe.newLine();
        }
    }

    public void visit(ASTLiteralNode lit) {
        this.scribe.print(lit.getRawSignature());
    }

    public int visit(IASTName name) {
        this.writeLeadingComments(name);
        if (!this.macroHandler.checkisMacroExpansionNode(name)) {
            this.nameWriter.writeName(name);
        }
        return 1;
    }

    public int visit(IASTDeclSpecifier declSpec) {
        this.writeLeadingComments(declSpec);
        this.declSpecWriter.writeDelcSpec(declSpec);
        return 1;
    }

    public int visit(IASTExpression expression) {
        this.writeLeadingComments(expression);
        if (!this.macroHandler.checkisMacroExpansionNode(expression)) {
            if (expression instanceof IGNUASTCompoundStatementExpression) {
                IGNUASTCompoundStatementExpression gnuCompStmtExp = (IGNUASTCompoundStatementExpression)expression;
                gnuCompStmtExp.getCompoundStatement().accept(this);
            } else {
                this.expWriter.writeExpression(expression);
            }
        }
        return 1;
    }

    public int visit(IASTStatement statement) {
        this.writeLeadingComments(statement);
        if (this.macroHandler.isStatementWithMixedLocation(statement) && !(statement instanceof IASTCompoundStatement)) {
            return this.statementWriter.writeMixedStatement(statement);
        }
        if (this.macroHandler.checkisMacroExpansionNode(statement)) {
            return 1;
        }
        return this.statementWriter.writeStatement(statement, true);
    }

    public int visit(IASTDeclaration declaration) {
        this.writeLeadingComments(declaration);
        if (!this.macroHandler.checkisMacroExpansionNode(declaration)) {
            this.declarationWriter.writeDeclaration(declaration);
        }
        return 1;
    }

    public int visit(IASTDeclarator declarator) {
        this.writeLeadingComments(declarator);
        if (!this.macroHandler.checkisMacroExpansionNode(declarator)) {
            this.declaratorWriter.writeDeclarator(declarator);
        }
        return 1;
    }

    public int visit(IASTArrayModifier amod) {
        if (!this.macroHandler.checkisMacroExpansionNode(amod)) {
            this.declaratorWriter.writeArrayModifier(amod);
        }
        return 1;
    }

    public int visit(IASTInitializer initializer) {
        this.writeLeadingComments(initializer);
        if (!this.macroHandler.checkisMacroExpansionNode(initializer)) {
            this.initializerWriter.writeInitializer(initializer);
        }
        return 1;
    }

    public int visit(IASTParameterDeclaration parameterDeclaration) {
        this.writeLeadingComments(parameterDeclaration);
        if (!this.macroHandler.checkisMacroExpansionNode(parameterDeclaration)) {
            parameterDeclaration.getDeclSpecifier().accept(this);
            IASTDeclarator declarator = this.getParameterDeclarator(parameterDeclaration);
            if (this.getParameterName(declarator).toString().length() != 0) {
                this.scribe.printSpaces(1);
            }
            declarator.accept(this);
        }
        return 1;
    }

    protected IASTName getParameterName(IASTDeclarator declarator) {
        return declarator.getName();
    }

    protected IASTDeclarator getParameterDeclarator(IASTParameterDeclaration parameterDeclaration) {
        return parameterDeclaration.getDeclarator();
    }

    public int visit(ICPPASTNamespaceDefinition namespace) {
        this.writeLeadingComments(namespace);
        if (!this.macroHandler.checkisMacroExpansionNode(namespace)) {
            this.declarationWriter.writeDeclaration(namespace);
        }
        return 1;
    }

    public int visit(ICPPASTTemplateParameter parameter) {
        this.writeLeadingComments(parameter);
        if (!this.macroHandler.checkisMacroExpansionNode(parameter)) {
            this.tempParameterWriter.writeTemplateParameter(parameter);
        }
        return 1;
    }

    public void cleanCache() {
        this.scribe.cleanCache();
        this.macroHandler.reset();
    }
}

