/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.util;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public class OffsetHelper {
    public static int getOffsetIncludingComment(IASTNode node) {
        int nodeStart = Integer.MAX_VALUE;
        IASTNodeLocation[] nodeLocations = node.getNodeLocations();
        if (nodeLocations.length != 1) {
            IASTNodeLocation[] iASTNodeLocationArray = nodeLocations;
            int n = nodeLocations.length;
            int n2 = 0;
            while (n2 < n) {
                int offset;
                IASTNodeLocation location = iASTNodeLocationArray[n2];
                if (location instanceof IASTMacroExpansionLocation) {
                    IASTMacroExpansionLocation macroLoc = (IASTMacroExpansionLocation)location;
                    offset = macroLoc.asFileLocation().getNodeOffset();
                } else {
                    offset = location.asFileLocation().getNodeOffset();
                }
                if (offset < nodeStart) {
                    nodeStart = offset;
                }
                ++n2;
            }
        } else {
            nodeStart = node.getFileLocation().getNodeOffset();
        }
        return nodeStart;
    }

    public static int getEndOffsetIncludingComments(IASTNode node) {
        int fileOffset = 0;
        int length = 0;
        IASTNodeLocation[] nodeLocations = node.getNodeLocations();
        if (nodeLocations.length != 1) {
            IASTNodeLocation[] iASTNodeLocationArray = nodeLocations;
            int n = nodeLocations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNodeLocation location = iASTNodeLocationArray[n2];
                if (location instanceof IASTMacroExpansionLocation) {
                    IASTMacroExpansionLocation macroLoc = (IASTMacroExpansionLocation)location;
                    fileOffset = macroLoc.asFileLocation().getNodeOffset();
                    length = macroLoc.asFileLocation().getNodeLength();
                } else {
                    fileOffset = location.asFileLocation().getNodeOffset();
                    length = location.asFileLocation().getNodeLength();
                }
                ++n2;
            }
        } else {
            IASTFileLocation loc = node.getFileLocation();
            fileOffset = loc.getNodeOffset();
            length = loc.getNodeLength();
        }
        return fileOffset + length;
    }

    public static int getEndOffsetWithoutComments(IASTNode node) {
        return node.getFileLocation().getNodeOffset() + node.getFileLocation().getNodeLength();
    }

    public static int getLengthIncludingComment(IASTNode node) {
        return OffsetHelper.getEndOffsetIncludingComments(node) - OffsetHelper.getOffsetIncludingComment(node);
    }

    public static int getNodeOffset(ASTNode node) {
        return node.getOffset();
    }

    public static int getNodeEndPoint(ASTNode node) {
        return node.getOffset() + node.getLength();
    }

    public static int getStartingLineNumber(IASTNode node) {
        return node.getFileLocation().getStartingLineNumber();
    }

    public static int getEndingLineNumber(IASTNode node) {
        return node.getFileLocation().getEndingLineNumber();
    }
}

