/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.internal.core.index.CIndex;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.pdom.ASTFilePathResolver;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritableCIndex
extends CIndex
implements IWritableIndex {
    private final IWritableIndexFragment fWritableFragment;
    private boolean fIsWriteLocked = false;

    public WritableCIndex(IWritableIndexFragment writable, IIndexFragment[] readonly) {
        super(WritableCIndex.concat(writable, readonly));
        this.fWritableFragment = writable;
    }

    private static IIndexFragment[] concat(IIndexFragment writable, IIndexFragment[] readonly) {
        IIndexFragment[] result = new IIndexFragment[1 + readonly.length];
        result[0] = writable;
        System.arraycopy(readonly, 0, result, 1, readonly.length);
        return result;
    }

    @Override
    public IWritableIndexFragment getWritableFragment() {
        return this.fWritableFragment;
    }

    @Override
    public IIndexFragmentFile getWritableFile(int linkageID, IIndexFileLocation location) throws CoreException {
        return this.fWritableFragment.getFile(linkageID, location);
    }

    @Override
    public IIndexFragmentFile[] getWritableFiles(IIndexFileLocation location) throws CoreException {
        return this.fWritableFragment.getFiles(location);
    }

    @Override
    public IIndexFragmentFile addFile(int linkageID, IIndexFileLocation fileLocation) throws CoreException {
        return this.fWritableFragment.addFile(linkageID, fileLocation);
    }

    private boolean isWritableFragment(IIndexFragment frag) {
        return frag == this.fWritableFragment;
    }

    @Override
    public void setFileContent(IIndexFragmentFile file, int linkageID, IWritableIndex.IncludeInformation[] includes, IASTPreprocessorStatement[] macros, IASTName[][] names, ASTFilePathResolver resolver) throws CoreException {
        IIndexFragment indexFragment = file.getIndexFragment();
        if (!this.isWritableFragment(indexFragment)) {
            assert (false) : "Attempt to update file of read-only fragment";
        } else {
            IWritableIndex.IncludeInformation[] includeInformationArray = includes;
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                IWritableIndex.IncludeInformation ii = includeInformationArray[n2];
                if (ii.fLocation != null) {
                    ii.fTargetFile = this.addFile(linkageID, ii.fLocation);
                }
                ++n2;
            }
            ((IWritableIndexFragment)indexFragment).addFileContent(file, includes, macros, names, resolver);
        }
    }

    @Override
    public void clear() throws CoreException {
        this.fWritableFragment.clear();
    }

    @Override
    public boolean isWritableFile(IIndexFile file) {
        return file instanceof IIndexFragmentFile && this.isWritableFragment(((IIndexFragmentFile)file).getIndexFragment());
    }

    @Override
    public void clearFile(IIndexFragmentFile file, Collection<IIndexFileLocation> clearedContexts) throws CoreException {
        IIndexFragment indexFragment = file.getIndexFragment();
        if (!this.isWritableFragment(indexFragment)) {
            assert (false) : "Attempt to clear file of read-only fragment";
        } else {
            ((IWritableIndexFragment)indexFragment).clearFile(file, clearedContexts);
        }
    }

    @Override
    public synchronized void acquireReadLock() throws InterruptedException {
        assert (!this.fIsWriteLocked) : "Read locks are not allowed while write-locked.";
        super.acquireReadLock();
    }

    @Override
    public synchronized void releaseReadLock() {
        assert (!this.fIsWriteLocked) : "Read locks are not allowed while write-locked.";
        super.releaseReadLock();
    }

    @Override
    public synchronized void acquireWriteLock(int giveupReadlockCount) throws InterruptedException {
        assert (!this.fIsWriteLocked) : "Multiple write locks is not allowed";
        assert (giveupReadlockCount == this.getReadLockCount()) : "Unexpected read lock is not allowed";
        this.fWritableFragment.acquireWriteLock(giveupReadlockCount);
        this.fIsWriteLocked = true;
    }

    @Override
    public synchronized void releaseWriteLock(int establishReadlockCount) {
        this.releaseWriteLock(establishReadlockCount, true);
    }

    @Override
    public synchronized void releaseWriteLock(int establishReadlockCount, boolean flush) {
        assert (this.fIsWriteLocked) : "No write lock to be released";
        assert (establishReadlockCount == this.getReadLockCount()) : "Unexpected read lock is not allowed";
        this.fIsWriteLocked = false;
        this.fWritableFragment.releaseWriteLock(establishReadlockCount, flush);
        this.clearResultCaches();
    }

    @Override
    public void flush() throws CoreException {
        assert (!this.fIsWriteLocked);
        this.fWritableFragment.flush();
    }

    @Override
    public long getDatabaseSizeBytes() {
        return this.fWritableFragment.getDatabaseSizeBytes();
    }
}

