/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.language;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.language.ProjectLanguageConfiguration;
import org.eclipse.cdt.core.language.WorkspaceLanguageConfiguration;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageMappingStore {
    private static final String LANGUAGE_MAPPING_ID = "org.eclipse.cdt.core.language.mapping";
    private static final String PROJECT_MAPPINGS = "project-mappings";
    private static final String WORKSPACE_MAPPINGS = "workspace-mappings";
    private static final String CONTENT_TYPE_MAPPING = "content-type-mapping";
    private static final String FILE_MAPPING = "file-mapping";
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_CONTENT_TYPE = "content-type";
    private static final String ATTRIBUTE_LANGUAGE = "language";
    private static final String ATTRIBUTE_CONFIGURATION = "configuration";

    public ProjectLanguageConfiguration decodeMappings(IProject project) throws CoreException {
        ProjectLanguageConfiguration config = new ProjectLanguageConfiguration();
        ICDescriptor descriptor = this.getProjectDescription(project);
        ICStorageElement rootElement = descriptor.getProjectStorageElement(LANGUAGE_MAPPING_ID);
        if (rootElement == null) {
            return config;
        }
        ICStorageElement[] mappingElements = rootElement.getChildrenByName(PROJECT_MAPPINGS);
        if (mappingElements.length > 0) {
            ICStorageElement element = mappingElements[0];
            config.setContentTypeMappings(this.decodeProjectContentTypeMappings(element));
            config.setFileMappings(this.decodeFileMappings(element));
        }
        return config;
    }

    private Map<String, Map<String, String>> decodeProjectContentTypeMappings(ICStorageElement rootElement) {
        TreeMap<String, Map<String, String>> decodedMappings = new TreeMap<String, Map<String, String>>();
        ICStorageElement[] mappingElements = rootElement.getChildrenByName(CONTENT_TYPE_MAPPING);
        int j = 0;
        while (j < mappingElements.length) {
            ICStorageElement mapping = mappingElements[j];
            String configuration = mapping.getAttribute(ATTRIBUTE_CONFIGURATION);
            TreeMap<String, String> contentTypeMappings = (TreeMap<String, String>)decodedMappings.get(configuration);
            if (contentTypeMappings == null) {
                contentTypeMappings = new TreeMap<String, String>();
                decodedMappings.put(configuration, contentTypeMappings);
            }
            String contentType = mapping.getAttribute(ATTRIBUTE_CONTENT_TYPE);
            String language = mapping.getAttribute(ATTRIBUTE_LANGUAGE);
            contentTypeMappings.put(contentType, language);
            ++j;
        }
        return decodedMappings;
    }

    protected ICDescriptor getProjectDescription(IProject project) throws CoreException {
        return CCorePlugin.getDefault().getCProjectDescription(project, true);
    }

    private Map<String, String> decodeContentTypeMappings(Element rootElement) throws CoreException {
        return this.decodeMappings(rootElement, CONTENT_TYPE_MAPPING, ATTRIBUTE_CONTENT_TYPE, ATTRIBUTE_LANGUAGE);
    }

    private Map<String, Map<String, String>> decodeFileMappings(ICStorageElement rootElement) throws CoreException {
        TreeMap<String, Map<String, String>> decodedMappings = new TreeMap<String, Map<String, String>>();
        ICStorageElement[] mappingElements = rootElement.getChildrenByName(FILE_MAPPING);
        int j = 0;
        while (j < mappingElements.length) {
            ICStorageElement mapping = mappingElements[j];
            String path = mapping.getAttribute(ATTRIBUTE_PATH);
            TreeMap<String, String> configurationMappings = (TreeMap<String, String>)decodedMappings.get(path);
            if (configurationMappings == null) {
                configurationMappings = new TreeMap<String, String>();
                decodedMappings.put(path, configurationMappings);
            }
            String configuration = mapping.getAttribute(ATTRIBUTE_CONFIGURATION);
            String language = mapping.getAttribute(ATTRIBUTE_LANGUAGE);
            configurationMappings.put(configuration, language);
            ++j;
        }
        return decodedMappings;
    }

    private Map<String, String> decodeMappings(Element rootElement, String category, String keyName, String valueName) {
        TreeMap<String, String> decodedMappings = new TreeMap<String, String>();
        NodeList mappingElements = rootElement.getElementsByTagName(category);
        int j = 0;
        while (j < mappingElements.getLength()) {
            Element mapping = (Element)mappingElements.item(j);
            String key = mapping.getAttribute(keyName);
            String value = mapping.getAttribute(valueName);
            decodedMappings.put(key, value);
            ++j;
        }
        return decodedMappings;
    }

    public void storeMappings(IProject project, ProjectLanguageConfiguration config) throws CoreException {
        ICDescriptor descriptor = this.getProjectDescription(project);
        ICStorageElement rootElement = descriptor.getProjectStorageElement(LANGUAGE_MAPPING_ID);
        rootElement.clear();
        ICStorageElement projectMappings = rootElement.createChild(PROJECT_MAPPINGS);
        this.addProjectContentTypeMappings(config.getContentTypeMappings(), projectMappings);
        this.addFileMappings(config.getFileMappings(), projectMappings);
        descriptor.saveProjectData();
    }

    private void addProjectContentTypeMappings(Map<String, Map<String, String>> contentTypeMappings, ICStorageElement rootElement) {
        for (Map.Entry<String, Map<String, String>> entry : contentTypeMappings.entrySet()) {
            String configuration = entry.getKey();
            for (Map.Entry<String, String> configurationEntry : entry.getValue().entrySet()) {
                String contentType = configurationEntry.getKey();
                String language = configurationEntry.getValue();
                ICStorageElement mapping = rootElement.createChild(CONTENT_TYPE_MAPPING);
                mapping.setAttribute(ATTRIBUTE_CONTENT_TYPE, contentType);
                mapping.setAttribute(ATTRIBUTE_CONFIGURATION, configuration);
                mapping.setAttribute(ATTRIBUTE_LANGUAGE, language);
            }
        }
    }

    public void storeMappings(WorkspaceLanguageConfiguration config) throws CoreException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = doc.createElement(WORKSPACE_MAPPINGS);
            doc.appendChild(rootElement);
            this.addContentTypeMappings(config.getWorkspaceMappings(), rootElement);
            Transformer serializer = this.createSerializer();
            DOMSource source = new DOMSource(doc);
            StringWriter buffer = new StringWriter();
            StreamResult result = new StreamResult(buffer);
            serializer.transform(source, result);
            String encodedMappings = buffer.getBuffer().toString();
            Preferences node = CCorePlugin.getDefault().getPluginPreferences();
            node.setValue("org.eclipse.cdt.core.workspaceLanguageMappings", encodedMappings);
            CCorePlugin.getDefault().savePluginPreferences();
        }
        catch (ParserConfigurationException e) {
            throw new CoreException(Util.createStatus(e));
        }
        catch (TransformerException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public WorkspaceLanguageConfiguration decodeWorkspaceMappings() throws CoreException {
        Preferences node = CCorePlugin.getDefault().getPluginPreferences();
        String encodedMappings = node.getString("org.eclipse.cdt.core.workspaceLanguageMappings");
        WorkspaceLanguageConfiguration config = new WorkspaceLanguageConfiguration();
        if (encodedMappings == null || encodedMappings.length() == 0) {
            return config;
        }
        InputSource input = new InputSource(new StringReader(encodedMappings));
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
            config.setWorkspaceMappings(this.decodeContentTypeMappings(document.getDocumentElement()));
            return config;
        }
        catch (SAXException e) {
            throw new CoreException(Util.createStatus(e));
        }
        catch (IOException e) {
            throw new CoreException(Util.createStatus(e));
        }
        catch (ParserConfigurationException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    private Transformer createSerializer() throws CoreException {
        try {
            return TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new CoreException(Util.createStatus(e));
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    private void addMappings(Map<String, String> mappings, Element rootElement, String category, String keyName, String valueName) {
        Document document = rootElement.getOwnerDocument();
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            Element mapping = document.createElement(category);
            mapping.setAttribute(keyName, entry.getKey());
            mapping.setAttribute(valueName, entry.getValue());
            rootElement.appendChild(mapping);
        }
    }

    private void addContentTypeMappings(Map<String, String> mappings, Element rootElement) {
        this.addMappings(mappings, rootElement, CONTENT_TYPE_MAPPING, ATTRIBUTE_CONTENT_TYPE, ATTRIBUTE_LANGUAGE);
    }

    private void addFileMappings(Map<String, Map<String, String>> mappings, ICStorageElement rootElement) {
        for (Map.Entry<String, Map<String, String>> entry : mappings.entrySet()) {
            ICStorageElement mapping = rootElement.createChild(FILE_MAPPING);
            String path = entry.getKey();
            for (Map.Entry<String, String> configurationEntry : entry.getValue().entrySet()) {
                String configuration = configurationEntry.getKey();
                String language = configurationEntry.getValue();
                mapping.setAttribute(ATTRIBUTE_PATH, path);
                mapping.setAttribute(ATTRIBUTE_CONFIGURATION, configuration);
                mapping.setAttribute(ATTRIBUTE_LANGUAGE, language);
            }
        }
    }
}

