/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPArgumentList {
    public static long putArguments(PDOMNode parent, ICPPTemplateArgument[] templateArguments) throws CoreException {
        long block;
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = Math.min(templateArguments.length, 511);
        long p = block = db.malloc(2 + 8 * len);
        db.putShort(p, (short)len);
        p += 2L;
        int i = 0;
        while (i < len) {
            PDOMNode type;
            ICPPTemplateArgument arg = templateArguments[i];
            boolean isNonType = arg.isNonTypeValue();
            if (isNonType) {
                type = linkage.addType(parent, arg.getTypeOfNonTypeValue());
                db.putRecPtr(p, type == null ? 0L : type.getRecord());
                long valueRec = PDOMValue.store(db, linkage, arg.getNonTypeValue());
                db.putRecPtr(p + 4L, valueRec);
            } else {
                type = linkage.addType(parent, arg.getTypeValue());
                db.putRecPtr(p, type == null ? 0L : type.getRecord());
            }
            ++i;
            p += 8L;
        }
        return block;
    }

    public static void clearArguments(PDOMNode parent, long record) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(record);
        Assert.isTrue((len >= 0 && len <= 511 ? 1 : 0) != 0);
        long p = record + 2L;
        int i = 0;
        while (i < len) {
            long typeRec = db.getRecPtr(p);
            if (typeRec != 0L) {
                IType t = (IType)((Object)linkage.getNode(typeRec));
                linkage.deleteType(t, parent.getRecord());
            }
            long nonTypeValueRec = db.getRecPtr(p + 4L);
            PDOMValue.delete(db, nonTypeValueRec);
            p += 8L;
            ++i;
        }
        db.free(record);
    }

    public static ICPPTemplateArgument[] getArguments(PDOMNode parent, long rec) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(rec);
        Assert.isTrue((len >= 0 && len <= 511 ? 1 : 0) != 0);
        if (len == 0) {
            return ICPPTemplateArgument.EMPTY_ARGUMENTS;
        }
        rec += 2L;
        ICPPTemplateArgument[] result = new ICPPTemplateArgument[len];
        int i = 0;
        while (i < len) {
            long typeRec = db.getRecPtr(rec);
            IType type = typeRec == 0L ? new CPPBasicType(-1, 0) : (IType)((Object)linkage.getNode(typeRec));
            long nonTypeValRec = db.getRecPtr(rec + 4L);
            if (nonTypeValRec != 0L) {
                IValue val = PDOMValue.restore(db, linkage, nonTypeValRec);
                result[i] = new CPPTemplateArgument(val, type);
            } else {
                result[i] = new CPPTemplateArgument(type);
            }
            rec += 8L;
            ++i;
        }
        return result;
    }
}

