/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingContainerFactoryWithListener;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsContainer;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsContainerChangeInfo;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsManager;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CfgExportSettingContainerFactory
extends CExternalSettingContainerFactoryWithListener
implements ICProjectDescriptionListener {
    static final String FACTORY_ID = "org.eclipse.cdt.core.cfg.export.settings.sipplier";
    private static final char DELIMITER = ';';
    private static CfgExportSettingContainerFactory fInstance;

    private CfgExportSettingContainerFactory() {
    }

    public static CfgExportSettingContainerFactory getInstance() {
        if (fInstance == null) {
            fInstance = new CfgExportSettingContainerFactory();
        }
        return fInstance;
    }

    @Override
    public void startup() {
        CProjectDescriptionManager.getInstance().addCProjectDescriptionListener(this, 5);
    }

    @Override
    public void shutdown() {
        CProjectDescriptionManager.getInstance().removeCProjectDescriptionListener(this);
    }

    @Override
    public CExternalSettingsContainer createContainer(String id, IProject project, ICConfigurationDescription cfgDes) {
        try {
            String[] r = CfgExportSettingContainerFactory.parseId(id);
            return new CfgRefContainer(r[0], r[1]);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new CExternalSettingsManager.NullContainer();
        }
    }

    private static void createReference(ICConfigurationDescription cfg, String projName, String cfgId) {
        CExternalSettingsManager.CContainerRef cr = CfgExportSettingContainerFactory.createContainerRef(projName, cfgId);
        CExternalSettingsManager.getInstance().addContainer(cfg, cr);
    }

    private static void removeReference(ICConfigurationDescription cfg, String projName, String cfgId) {
        CExternalSettingsManager.CContainerRef cr = CfgExportSettingContainerFactory.createContainerRef(projName, cfgId);
        CExternalSettingsManager.getInstance().removeContainer(cfg, cr);
    }

    private static CExternalSettingsManager.CContainerRef createContainerRef(String projName, String cfgId) {
        return new CExternalSettingsManager.CContainerRef(FACTORY_ID, CfgExportSettingContainerFactory.createId(projName, cfgId));
    }

    public static Map<String, String> getReferenceMap(ICConfigurationDescription cfg) {
        CExternalSettingsManager.CContainerRef[] refs = CExternalSettingsManager.getInstance().getReferences(cfg, FACTORY_ID);
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < refs.length) {
            try {
                String[] r = CfgExportSettingContainerFactory.parseId(refs[i].getContainerId());
                map.put(r[0], r[1]);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
            ++i;
        }
        return map;
    }

    public static void setReferenceMap(ICConfigurationDescription cfg, Map<String, String> map) {
        Map<String, String> cur = CfgExportSettingContainerFactory.getReferenceMap(cfg);
        HashMap<String, String> newCopy = new HashMap<String, String>(map);
        Iterator<Map.Entry<String, String>> iter = cur.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String projName = entry.getKey();
            if (!newCopy.containsKey(projName) || !entry.getValue().equals(newCopy.get(projName))) continue;
            iter.remove();
            newCopy.remove(projName);
        }
        for (Map.Entry<String, String> entry : cur.entrySet()) {
            CfgExportSettingContainerFactory.removeReference(cfg, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : newCopy.entrySet()) {
            CfgExportSettingContainerFactory.createReference(cfg, entry.getKey(), entry.getValue());
        }
    }

    private static String createId(String projName, String cfgId) {
        return new StringBuffer().append(projName).append(';').append(cfgId).toString();
    }

    private static String[] parseId(String id) throws CoreException {
        String cfgId;
        String projName;
        if (id == null) {
            throw new NullPointerException();
        }
        int index = id.indexOf(59);
        if (index != -1) {
            projName = id.substring(0, index);
            cfgId = id.substring(index + 1);
        } else {
            projName = id;
            cfgId = "";
        }
        projName = projName.trim();
        if (projName.length() == 0) {
            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CfgExportSettingContainerFactory.2"));
        }
        return new String[]{projName, cfgId};
    }

    @Override
    public void handleEvent(CProjectDescriptionEvent event) {
        switch (event.getEventType()) {
            case 1: 
            case 4: {
                String[] ids = this.getContainerIds(event.getProjectDelta());
                if (ids.length == 0) break;
                CExternalSettingsContainerChangeInfo[] changeInfos = new CExternalSettingsContainerChangeInfo[ids.length];
                int i = 0;
                while (i < changeInfos.length) {
                    changeInfos[i] = new CExternalSettingsContainerChangeInfo(2, new CExternalSettingsManager.CContainerRef(FACTORY_ID, ids[i]), null);
                    ++i;
                }
                this.notifySettingsChange(null, null, changeInfos);
            }
        }
    }

    private String[] getContainerIds(ICDescriptionDelta delta) {
        if (delta == null) {
            return new String[0];
        }
        int deltaKind = delta.getDeltaKind();
        ArrayList<String> cfgIds = new ArrayList<String>();
        switch (deltaKind) {
            case 1: 
            case 2: {
                ICProjectDescription des = (ICProjectDescription)delta.getSetting();
                ICConfigurationDescription[] cfgs = des.getConfigurations();
                if (cfgs.length != 0) {
                    int i = 0;
                    while (i < cfgs.length) {
                        cfgIds.add(cfgs[i].getId());
                        ++i;
                    }
                    cfgIds.add("");
                }
            }
            case 3: {
                ICDescriptionDelta[] children = delta.getChildren();
                this.collectCfgIds(children, cfgIds);
                if ((delta.getChangeFlags() & 1) == 0) break;
                cfgIds.add("");
            }
        }
        String[] ids = new String[cfgIds.size()];
        if (ids.length != 0) {
            String projName = ((ICProjectDescription)delta.getSetting()).getProject().getName();
            int i = 0;
            while (i < ids.length) {
                ids[i] = CfgExportSettingContainerFactory.createId(projName, (String)cfgIds.get(i));
                ++i;
            }
        }
        return ids;
    }

    public Collection<String> collectCfgIds(ICDescriptionDelta[] deltas, Collection<String> c) {
        if (c == null) {
            c = new ArrayList<String>();
        }
        int i = 0;
        while (i < deltas.length) {
            ICDescriptionDelta delta = deltas[i];
            int deltaKind = delta.getDeltaKind();
            switch (deltaKind) {
                case 1: 
                case 2: {
                    c.add(delta.getSetting().getId());
                    break;
                }
                case 3: {
                    int changeFlags = delta.getChangeFlags();
                    if ((changeFlags & 0x18000) == 0) break;
                    c.add(delta.getSetting().getId());
                }
            }
            ++i;
        }
        return c;
    }

    private class CfgRefContainer
    extends CExternalSettingsContainer {
        private String fProjName;
        private String fCfgId;

        CfgRefContainer(String projName, String cfgId) {
            this.fProjName = projName;
            this.fCfgId = cfgId;
        }

        public CExternalSetting[] getExternalSettings() {
            ICProjectDescription des;
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.fProjName);
            if (project.exists() && project.isOpen() && (des = CProjectDescriptionManager.getInstance().getProjectDescription(project, false)) != null) {
                ICConfigurationDescription cfg;
                ICConfigurationDescription iCConfigurationDescription = cfg = this.fCfgId.length() != 0 ? des.getConfigurationById(this.fCfgId) : des.getActiveConfiguration();
                if (cfg != null) {
                    ICExternalSetting[] ies = cfg.getExternalSettings();
                    if (ies instanceof CExternalSetting[]) {
                        return (CExternalSetting[])ies;
                    }
                    CExternalSetting[] es = new CExternalSetting[ies.length];
                    System.arraycopy(ies, 0, es, 0, es.length);
                    return es;
                }
            }
            return new CExternalSetting[0];
        }
    }
}

