/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.ISymbolReader;

public class CodeViewReader
implements ISymbolReader {
    private RandomAccessFile file;
    private int cvData;
    private boolean isLe;
    private List<String> fileList;
    private String[] files = null;
    private boolean parsed = false;

    public CodeViewReader(RandomAccessFile accessFile, int dataOffset, boolean littleEndian) {
        this.file = accessFile;
        this.cvData = dataOffset;
        this.isLe = littleEndian;
        this.fileList = new ArrayList<String>();
    }

    public String[] getSourceFiles() {
        if (!this.parsed) {
            try {
                this.parse();
            }
            catch (IOException iOException) {}
            this.parsed = true;
            this.files = new String[this.fileList.size()];
            int i = 0;
            while (i < this.fileList.size()) {
                this.files[i] = this.fileList.get(i);
                ++i;
            }
        }
        return this.files;
    }

    private int getInt(int value) {
        if (this.isLe) {
            int tmp = 0;
            int i = 0;
            while (i < 4) {
                tmp <<= 8;
                tmp |= value & 0xFF;
                value >>= 8;
                ++i;
            }
            return tmp;
        }
        return value;
    }

    private short getShort(short value) {
        if (this.isLe) {
            short tmp = value;
            tmp = (short)(tmp & 0xFF);
            tmp = (short)(tmp << 8);
            tmp = (short)(tmp | value >> 8 & 0xFF);
            return tmp;
        }
        return value;
    }

    private void parse() throws IOException {
        if (this.cvData <= 0) {
            return;
        }
        this.file.seek(this.cvData);
        this.file.skipBytes(4);
        int subsectionDirOffset = this.getInt(this.file.readInt());
        this.file.seek(this.cvData + subsectionDirOffset);
        this.file.skipBytes(4);
        int directoryCount = this.getInt(this.file.readInt());
        this.file.skipBytes(8);
        long directoryOffset = this.file.getFilePointer();
        int i = 0;
        while (i < directoryCount) {
            this.file.seek(directoryOffset + (long)(i * 12));
            short subsectionType = this.getShort(this.file.readShort());
            if (295 == subsectionType) {
                this.file.skipBytes(2);
                int subsectionOffset = this.getInt(this.file.readInt());
                this.file.seek(this.cvData + subsectionOffset);
                int fileCount = this.getShort(this.file.readShort());
                this.file.skipBytes(2);
                long arrayOffset = this.file.getFilePointer();
                int j = 0;
                while (j < fileCount) {
                    this.file.seek(arrayOffset + (long)(j * 4));
                    int offset = this.getInt(this.file.readInt());
                    this.file.seek(this.cvData + subsectionOffset + offset);
                    short segments = this.getShort(this.file.readShort());
                    this.file.skipBytes(2 + segments * 4 + segments * 8);
                    int nameLength = this.file.readUnsignedByte();
                    byte[] nameBuffer = new byte[nameLength];
                    this.file.readFully(nameBuffer);
                    String name = new String(nameBuffer);
                    if (!this.fileList.contains(name)) {
                        this.fileList.add(name);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

