/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.connection.CVSAuthenticationException;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ssh.CVSSSHMessages;
import org.eclipse.team.internal.ccvs.ssh.Cipher;
import org.eclipse.team.internal.ccvs.ssh.ClientPacket;
import org.eclipse.team.internal.ccvs.ssh.KnownHosts;
import org.eclipse.team.internal.ccvs.ssh.Misc;
import org.eclipse.team.internal.ccvs.ssh.Policy;
import org.eclipse.team.internal.ccvs.ssh.ServerPacket;
import org.eclipse.team.internal.core.streams.PollingInputStream;
import org.eclipse.team.internal.core.streams.PollingOutputStream;
import org.eclipse.team.internal.core.streams.TimeoutOutputStream;

public class Client {
    private static final String clientId = "SSH-1.5-Java 1.2.2\n";
    private static String serverId = null;
    private static final int MAX_CLIENT_PACKET_SIZE = 1024;
    private static final int SSH_MSG_DISCONNECT = 1;
    private static final int SSH_SMSG_PUBLIC_KEY = 2;
    private static final int SSH_CMSG_SESSION_KEY = 3;
    private static final int SSH_CMSG_USER = 4;
    private static final int SSH_CMSG_AUTH_PASSWORD = 9;
    private static final int SSH_CMSG_REQUEST_PTY = 10;
    private static final int SSH_CMSG_EXEC_SHELL = 12;
    private static final int SSH_CMSG_EXEC_CMD = 13;
    private static final int SSH_SMSG_SUCCESS = 14;
    private static final int SSH_SMSG_FAILURE = 15;
    private static final int SSH_CMSG_STDIN_DATA = 16;
    private static final int SSH_SMSG_STDOUT_DATA = 17;
    private static final int SSH_SMSG_STDERR_DATA = 18;
    private static final int SSH_SMSG_EXITSTATUS = 20;
    private static final int SSH_CMSG_EXIT_CONFIRMATION = 33;
    private static final int SSH_MSG_DEBUG = 36;
    private static String[] cipherNames = new String[]{"None", "IDEA", "DES", "3DES", "TSS", "RC4", "Blowfish"};
    private static int SSH_CIPHER_BLOWFISH = 6;
    private int[] preferredCipherTypes = new int[]{SSH_CIPHER_BLOWFISH};
    private String host;
    private int port;
    private String username;
    private String password;
    private String command;
    private Socket socket;
    InputStream socketIn;
    private PollingOutputStream socketOut;
    private InputStream is;
    private OutputStream os;
    private boolean connected = false;
    private int timeout = -1;
    private Cipher cipher = null;

    public Client(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public Client(String host, int port, String username, String password, String command) {
        this(host, port, username, password);
        this.command = command;
    }

    public Client(String host, int port, String username, String password, String command, int timeout) {
        this(host, port, username, password, command);
        this.timeout = timeout;
    }

    private void cleanup() throws IOException {
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        finally {
            try {
                if (this.os != null) {
                    this.os.close();
                }
            }
            finally {
                try {
                    if (this.socketIn != null) {
                        this.socketIn.close();
                    }
                }
                finally {
                    try {
                        if (this.socketOut != null) {
                            this.socketOut.close();
                        }
                    }
                    finally {
                        try {
                            if (this.socket != null) {
                                this.socket.close();
                            }
                        }
                        finally {
                            this.socket = null;
                        }
                    }
                }
            }
        }
    }

    public void connect(IProgressMonitor monitor) throws IOException, CVSAuthenticationException {
        if (this.connected || monitor.isCanceled()) {
            return;
        }
        try {
            int c;
            PollingInputStream pollingInputStream = null;
            if (this.socket == null) {
                try {
                    this.socket = Util.createSocket((String)this.host, (int)this.port, (IProgressMonitor)monitor);
                    this.socket.setTcpNoDelay(true);
                }
                catch (InterruptedIOException interruptedIOException) {
                    throw new InterruptedIOException(NLS.bind((String)CVSSSHMessages.Client_socket, (Object[])new Object[]{this.host}));
                }
                if (this.timeout >= 0) {
                    this.socket.setSoTimeout(1000);
                }
                pollingInputStream = new PollingInputStream(this.socket.getInputStream(), this.timeout > 0 ? this.timeout : 1, monitor);
                this.socketIn = new BufferedInputStream((InputStream)pollingInputStream);
                this.socketOut = new PollingOutputStream((OutputStream)new TimeoutOutputStream(this.socket.getOutputStream(), 8192, 1000L, 1000L), this.timeout > 0 ? this.timeout : 1, monitor);
            }
            this.socketOut.setIsCancellable(false);
            pollingInputStream.setIsCancellable(false);
            StringBuffer buf = new StringBuffer();
            while ((c = this.socketIn.read()) != 10) {
                if (c == -1) {
                    throw new IOException(CVSSSHMessages.Client_socketClosed);
                }
                buf.append((char)c);
            }
            serverId = buf.toString();
            if (Policy.DEBUG_SSH_PROTOCOL) {
                System.out.println("SSH > server ID: " + serverId);
                System.out.println("SSH > client ID: SSH-1.5-Java 1.2.2\n");
            }
            if (!serverId.startsWith("SSH-1.")) {
                String sshVersion = serverId.startsWith("SSH-") ? serverId : "";
                throw new IOException(NLS.bind((String)CVSSSHMessages.Client_sshProtocolVersion, (Object[])new String[]{sshVersion}));
            }
            this.socketOut.write(clientId.getBytes());
            this.socketOut.flush();
            this.login();
            this.socketOut.setIsCancellable(true);
            pollingInputStream.setIsCancellable(true);
            if (this.command == null) {
                this.startShell();
            } else {
                this.executeCommand();
            }
            this.is = new StandardInputStream();
            this.os = new StandardOutputStream();
            this.connected = true;
        }
        finally {
            if (!this.connected) {
                this.cleanup();
            }
        }
    }

    public void disconnect() throws IOException {
        if (Policy.DEBUG_SSH_PROTOCOL) {
            System.out.println("Disconnecting.");
        }
        if (this.connected) {
            this.connected = false;
            try {
                this.send(1, null);
            }
            finally {
                this.cleanup();
            }
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            throw new IOException(CVSSSHMessages.Client_notConnected);
        }
        return this.is;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            throw new IOException(CVSSSHMessages.Client_notConnected);
        }
        return this.os;
    }

    private void startShell() throws IOException {
        ServerPacket packet = null;
        this.send_SSH_CMSG_REQUEST_PTY();
        try {
            packet = this.skip_SSH_MSG_DEBUG();
            int packetType = packet.getType();
            if (packetType != 14) {
                throw new IOException(NLS.bind((String)CVSSSHMessages.Client_packetType, (Object[])new Object[]{new Integer(packetType)}));
            }
        }
        finally {
            if (packet != null) {
                packet.close(true);
            }
        }
        this.send(12, null);
    }

    private void executeCommand() throws IOException {
        this.send(13, this.command);
    }

    private void login() throws IOException, CVSAuthenticationException {
        int packetType;
        ServerPacket packet = null;
        try {
            packet = this.skip_SSH_MSG_DEBUG();
            packetType = packet.getType();
            if (packetType != 2) {
                throw new IOException(NLS.bind((String)CVSSSHMessages.Client_packetType, (Object[])new Object[]{new Integer(packetType)}));
            }
            this.receive_SSH_SMSG_PUBLIC_KEY(packet);
        }
        finally {
            if (packet != null) {
                packet.close(true);
            }
        }
        try {
            packet = this.skip_SSH_MSG_DEBUG();
            packetType = packet.getType();
            if (packetType != 14) {
                throw new IOException(NLS.bind((String)CVSSSHMessages.Client_packetType, (Object[])new Object[]{new Integer(packetType)}));
            }
        }
        finally {
            if (packet != null) {
                packet.close(true);
            }
        }
        this.send(4, this.username);
        try {
            packet = this.skip_SSH_MSG_DEBUG();
            packetType = packet.getType();
            if (packetType != 15) {
                throw new IOException(NLS.bind((String)CVSSSHMessages.Client_packetType, (Object[])new Object[]{new Integer(packetType)}));
            }
        }
        finally {
            if (packet != null) {
                packet.close(true);
            }
        }
        this.send(9, this.password);
        try {
            packet = this.skip_SSH_MSG_DEBUG();
            packetType = packet.getType();
            if (packetType == 15) {
                throw new CVSAuthenticationException(CVSSSHMessages.Client_authenticationFailed, 1);
            }
            if (packetType != 14) {
                throw new IOException(NLS.bind((String)CVSSSHMessages.Client_packetType, (Object[])new Object[]{new Integer(packetType)}));
            }
        }
        finally {
            if (packet != null) {
                packet.close(true);
            }
        }
    }

    private void receive_SSH_SMSG_PUBLIC_KEY(ServerPacket packet) throws IOException, CVSAuthenticationException {
        InputStream pis = packet.getInputStream();
        byte[] anti_spoofing_cookie = new byte[8];
        Misc.readFully(pis, anti_spoofing_cookie);
        byte[] server_key_bits = new byte[4];
        Misc.readFully(pis, server_key_bits);
        byte[] server_key_public_exponent = Misc.readMpInt(pis);
        byte[] server_key_public_modulus = Misc.readMpInt(pis);
        byte[] host_key_bits = new byte[4];
        Misc.readFully(pis, host_key_bits);
        byte[] host_key_public_exponent = Misc.readMpInt(pis);
        byte[] host_key_public_modulus = Misc.readMpInt(pis);
        byte[] protocol_flags = new byte[4];
        Misc.readFully(pis, protocol_flags);
        byte[] supported_ciphers_mask = new byte[4];
        Misc.readFully(pis, supported_ciphers_mask);
        byte[] supported_authentications_mask = new byte[4];
        Misc.readFully(pis, supported_authentications_mask);
        pis.close();
        this.send_SSH_CMSG_SESSION_KEY(anti_spoofing_cookie, host_key_bits, server_key_public_modulus, host_key_public_modulus, supported_ciphers_mask, server_key_public_exponent, host_key_public_exponent);
    }

    void send(int packetType, String s) throws IOException {
        byte[] data = s == null ? new byte[]{} : s.getBytes("UTF-8");
        this.send(packetType, data, 0, data.length);
    }

    void send(int packetType, byte[] data, int off, int len) throws IOException {
        data = data == null ? null : Misc.lengthEncode(data, off, len);
        ClientPacket packet = new ClientPacket(packetType, data, this.cipher);
        this.socketOut.write(packet.getBytes());
        this.socketOut.flush();
    }

    private void send_SSH_CMSG_REQUEST_PTY() throws IOException {
        int packet_type = 10;
        byte[] termType = Misc.lengthEncode("dumb".getBytes(), 0, 4);
        byte[] row = new byte[4];
        byte[] col = new byte[4];
        byte[] XPixels = new byte[4];
        byte[] YPixels = new byte[4];
        byte[] terminalModes = new byte[1];
        byte[] data = new byte[termType.length + row.length + col.length + XPixels.length + YPixels.length + terminalModes.length];
        int offset = 0;
        System.arraycopy(termType, 0, data, offset, termType.length);
        System.arraycopy(row, 0, data, offset += termType.length, row.length);
        System.arraycopy(col, 0, data, offset += row.length, col.length);
        System.arraycopy(XPixels, 0, data, offset += col.length, XPixels.length);
        System.arraycopy(YPixels, 0, data, offset += XPixels.length, YPixels.length);
        System.arraycopy(terminalModes, 0, data, offset += YPixels.length, terminalModes.length);
        ClientPacket packet = new ClientPacket(packet_type, data, this.cipher);
        this.socketOut.write(packet.getBytes());
        this.socketOut.flush();
    }

    private void send_SSH_CMSG_SESSION_KEY(byte[] anti_spoofing_cookie, byte[] host_key_bits, byte[] server_key_public_modulus, byte[] host_key_public_modulus, byte[] supported_ciphers_mask, byte[] server_key_public_exponent, byte[] host_key_public_exponent) throws IOException, CVSAuthenticationException {
        byte[] result;
        int packet_type = 3;
        byte[] session_id = new byte[host_key_public_modulus.length + server_key_public_modulus.length + anti_spoofing_cookie.length];
        int offset = 0;
        System.arraycopy(host_key_public_modulus, 0, session_id, offset, host_key_public_modulus.length);
        System.arraycopy(server_key_public_modulus, 0, session_id, offset += host_key_public_modulus.length, server_key_public_modulus.length);
        System.arraycopy(anti_spoofing_cookie, 0, session_id, offset += server_key_public_modulus.length, anti_spoofing_cookie.length);
        session_id = Misc.md5(session_id);
        byte cipher_type = 0;
        boolean foundSupportedCipher = false;
        int i = 0;
        while (i < this.preferredCipherTypes.length && !foundSupportedCipher) {
            cipher_type = (byte)this.preferredCipherTypes[i];
            foundSupportedCipher = (supported_ciphers_mask[3] & (byte)(1 << cipher_type)) != 0;
            ++i;
        }
        if (!foundSupportedCipher) {
            throw new IOException(CVSSSHMessages.Client_cipher);
        }
        byte[] session_key = new byte[32];
        byte[] session_key_xored = new byte[32];
        byte[] session_key_encrypted = null;
        Misc.random(session_key, 0, session_key.length, true);
        System.arraycopy(session_key, 0, session_key_xored, 0, session_key.length);
        Misc.xor(session_key_xored, 0, session_id, 0, session_key_xored, 0, session_id.length);
        BigInteger host_e = new BigInteger(1, host_key_public_exponent);
        BigInteger host_n = new BigInteger(1, host_key_public_modulus);
        if (!new KnownHosts().verifyKey(this.host, host_key_bits, host_e, host_n)) {
            throw new CVSAuthenticationException(CVSSSHMessages.Client_hostIdChanged, 2);
        }
        if (new BigInteger(1, server_key_public_modulus).compareTo(host_n) == -1) {
            result = Misc.encryptRSAPkcs1(session_key_xored, server_key_public_exponent, server_key_public_modulus);
            result = Misc.encryptRSAPkcs1(result, host_key_public_exponent, host_key_public_modulus);
        } else {
            result = Misc.encryptRSAPkcs1(session_key_xored, host_key_public_exponent, host_key_public_modulus);
            result = Misc.encryptRSAPkcs1(result, server_key_public_exponent, server_key_public_modulus);
        }
        session_key_encrypted = new byte[result.length + 2];
        session_key_encrypted[1] = (byte)(8 * result.length & 0xFF);
        session_key_encrypted[0] = (byte)(8 * result.length >> 8 & 0xFF);
        int i2 = 0;
        while (i2 < result.length) {
            session_key_encrypted[i2 + 2] = result[i2];
            ++i2;
        }
        byte[] protocol_flags = new byte[4];
        byte[] data = new byte[1 + anti_spoofing_cookie.length + session_key_encrypted.length + protocol_flags.length];
        offset = 0;
        data[offset++] = cipher_type;
        System.arraycopy(anti_spoofing_cookie, 0, data, offset, anti_spoofing_cookie.length);
        System.arraycopy(session_key_encrypted, 0, data, offset += anti_spoofing_cookie.length, session_key_encrypted.length);
        System.arraycopy(protocol_flags, 0, data, offset += session_key_encrypted.length, protocol_flags.length);
        this.cipher = Cipher.getInstance(cipherNames[cipher_type]);
        this.cipher.setKey(session_key);
        ClientPacket packet = new ClientPacket(packet_type, data, null);
        this.socketOut.write(packet.getBytes());
        this.socketOut.flush();
    }

    ServerPacket skip_SSH_MSG_DEBUG() throws IOException {
        ServerPacket packet = new ServerPacket(this.socketIn, this.cipher);
        while (packet.getType() == 36) {
            packet.close(true);
            packet = new ServerPacket(this.socketIn, this.cipher);
        }
        return packet;
    }

    class StandardInputStream
    extends InputStream {
        private ServerPacket packet = null;
        private InputStream buffer = null;
        private boolean atEnd = false;
        private boolean closed = false;

        StandardInputStream() {
        }

        public int available() throws IOException {
            int available;
            if (this.closed) {
                throw new IOException(CVSSSHMessages.closed);
            }
            int n = available = this.buffer == null ? 0 : this.buffer.available();
            if (available == 0 && Client.this.socketIn.available() > 0) {
                this.fill();
                if (this.atEnd) {
                    return 0;
                }
                available = this.buffer.available();
            }
            return available;
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                if (this.packet != null) {
                    this.packet.close(false);
                    this.buffer = null;
                    this.packet = null;
                }
            }
        }

        public int read() throws IOException {
            if (this.closed) {
                throw new IOException(CVSSSHMessages.closed);
            }
            if (this.atEnd) {
                return -1;
            }
            if (this.buffer == null || this.buffer.available() == 0) {
                this.fill();
                if (this.atEnd) {
                    return -1;
                }
            }
            return this.buffer.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException(CVSSSHMessages.closed);
            }
            if (this.atEnd) {
                return -1;
            }
            if (this.buffer == null || this.buffer.available() == 0) {
                this.fill();
                if (this.atEnd) {
                    return -1;
                }
            }
            return this.buffer.read(b, off, len);
        }

        private void fill() throws IOException {
            if (this.buffer != null) {
                this.buffer.close();
            }
            this.packet = Client.this.skip_SSH_MSG_DEBUG();
            int packetType = this.packet.getType();
            switch (packetType) {
                case 17: 
                case 18: 
                case 36: {
                    this.buffer = this.packet.getInputStream();
                    Misc.readInt(this.buffer);
                    break;
                }
                case 20: {
                    this.buffer = null;
                    this.atEnd = true;
                    InputStream pis = this.packet.getInputStream();
                    Misc.readInt(pis);
                    pis.close();
                    Client.this.send(33, null);
                    break;
                }
                case 1: {
                    this.buffer = null;
                    this.atEnd = true;
                    this.handleDisconnect(this.packet.getInputStream());
                    break;
                }
                default: {
                    throw new IOException(NLS.bind((String)CVSSSHMessages.Client_packetType, (Object[])new Object[]{new Integer(packetType)}));
                }
            }
        }

        private void handleDisconnect(InputStream in) throws IOException {
            String description;
            block6: {
                description = null;
                try {
                    try {
                        description = Misc.readString(in);
                    }
                    catch (IOException iOException) {
                        in.close();
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    in.close();
                    throw throwable;
                }
                in.close();
            }
            if (description == null) {
                description = CVSSSHMessages.Client_noDisconnectDescription;
            }
            throw new IOException(NLS.bind((String)CVSSSHMessages.Client_disconnectDescription, (Object[])new Object[]{description}));
        }
    }

    class StandardOutputStream
    extends OutputStream {
        private int MAX_BUFFER_SIZE = 1024;
        private byte[] buffer = new byte[this.MAX_BUFFER_SIZE];
        private int bufpos = 0;
        private boolean closed = false;

        StandardOutputStream() {
        }

        public void close() throws IOException {
            if (!this.closed) {
                try {
                    this.flush();
                }
                finally {
                    this.closed = true;
                }
            }
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException(CVSSSHMessages.closed);
            }
            if (this.bufpos > 0) {
                Client.this.send(16, this.buffer, 0, this.bufpos);
                this.bufpos = 0;
            }
        }

        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException(CVSSSHMessages.closed);
            }
            this.buffer[this.bufpos++] = (byte)b;
            if (this.bufpos == this.MAX_BUFFER_SIZE) {
                this.flush();
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException(CVSSSHMessages.closed);
            }
            int bytesWritten = 0;
            int totalBytesWritten = 0;
            if (this.bufpos > 0) {
                bytesWritten = Math.min(this.MAX_BUFFER_SIZE - this.bufpos, len);
                System.arraycopy(b, off, this.buffer, this.bufpos, bytesWritten);
                this.bufpos += bytesWritten;
                totalBytesWritten += bytesWritten;
                if (this.bufpos == this.MAX_BUFFER_SIZE) {
                    this.flush();
                }
            }
            while (len - totalBytesWritten >= this.MAX_BUFFER_SIZE) {
                Client.this.send(16, b, off + totalBytesWritten, this.MAX_BUFFER_SIZE);
                totalBytesWritten += this.MAX_BUFFER_SIZE;
            }
            if (totalBytesWritten < len) {
                bytesWritten = len - totalBytesWritten;
                System.arraycopy(b, off + totalBytesWritten, this.buffer, 0, bytesWritten);
                this.bufpos += bytesWritten;
            }
        }
    }
}

