/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.dataextraction.impl;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.Locale;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.engine.api.IDataExtractionOption;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.dataextraction.CommonDataExtractionOption;
import org.eclipse.birt.report.engine.dataextraction.ICommonDataExtractionOption;
import org.eclipse.birt.report.engine.dataextraction.i18n.Messages;
import org.eclipse.birt.report.engine.extension.DataExtractionExtensionBase;

public class CommonDataExtractionImpl
extends DataExtractionExtensionBase {
    protected String PLUGIN_ID = "org.eclipse.birt.report.engine.dataextraction";
    private IReportContext context;
    private IDataExtractionOption options;
    private DateFormatter dateFormatter = null;
    private NumberFormatter numberFormatter = null;
    private ULocale locale = null;
    private TimeZone timeZone = null;
    private boolean isLocaleNeutral;

    public void initialize(IReportContext context, IDataExtractionOption options) throws BirtException {
        this.context = context;
        this.options = options;
        if (options.getOutputStream() == null) {
            throw new BirtException(this.PLUGIN_ID, Messages.getString("exception.dataextraction.options.outputstream_required"), null);
        }
        this.initCommonOptions(options);
    }

    private void initCommonOptions(IDataExtractionOption options) {
        String dateFormat = null;
        ICommonDataExtractionOption commonOptions = options instanceof ICommonDataExtractionOption ? (ICommonDataExtractionOption)options : new CommonDataExtractionOption(options.getOptions());
        this.isLocaleNeutral = commonOptions.isLocaleNeutralFormat();
        dateFormat = commonOptions.getDateFormat();
        Locale aLocale = commonOptions.getLocale();
        this.locale = aLocale == null ? ULocale.forLocale((Locale)Locale.getDefault()) : ULocale.forLocale((Locale)aLocale);
        java.util.TimeZone javaTimeZone = commonOptions.getTimeZone();
        this.timeZone = javaTimeZone != null ? TimeZone.getTimeZone((String)javaTimeZone.getID()) : null;
        if (!this.isLocaleNeutral) {
            this.dateFormatter = this.createDateFormatter(dateFormat, this.locale, this.timeZone);
            this.numberFormatter = new NumberFormatter(this.locale);
        }
    }

    public IReportContext getReportContext() {
        return this.context;
    }

    public IDataExtractionOption getOptions() {
        return this.options;
    }

    public void output(IExtractionResults results) throws BirtException {
        throw new BirtException(this.PLUGIN_ID, Messages.getString("exception.dataextraction.missing_implementation"), null);
    }

    public void release() {
    }

    private DateFormatter createDateFormatter(String dateFormat, ULocale locale, TimeZone timeZone) {
        DateFormatter dateFormatter = null;
        dateFormatter = dateFormat != null ? (timeZone != null ? new DateFormatter(dateFormat, locale, timeZone) : new DateFormatter(dateFormat, locale)) : (timeZone != null ? new DateFormatter(locale, timeZone) : new DateFormatter(locale));
        return dateFormatter;
    }

    protected String getStringValue(Object obj) throws BirtException {
        String value = null;
        value = this.isLocaleNeutral ? DataTypeUtil.toLocaleNeutralString((Object)obj) : (obj instanceof Date ? this.dateFormatter.format((Date)obj) : (obj instanceof Number ? this.numberFormatter.format((Number)obj) : DataTypeUtil.toString((Object)obj, (ULocale)this.locale)));
        return value;
    }
}

