/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dnd;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.IDropAdapter;
import org.eclipse.birt.report.designer.util.IVirtualValidator;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.VirtualCrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

public class LevelAttributeHandleDropAdapter
implements IDropAdapter {
    public int canDrop(Object transfer, Object target, int operation, DNDLocation location) {
        EditPart editPart;
        if (!this.isLevelAttributeHandle(transfer)) {
            return 0;
        }
        if (target instanceof EditPart && (editPart = (EditPart)target).getModel() instanceof IVirtualValidator) {
            if (((IVirtualValidator)editPart.getModel()).handleValidate(transfer)) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    private boolean isLevelAttributeHandle(Object transfer) {
        if (transfer instanceof Object[]) {
            Object[] items = (Object[])transfer;
            int i = 0;
            while (i < items.length) {
                if (!this.isLevelAttributeHandle(items[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return transfer instanceof LevelAttributeHandle;
    }

    public boolean performDrop(Object transfer, Object target, int operation, DNDLocation location) {
        EditPart editPart;
        if (target instanceof EditPart && (editPart = (EditPart)target) != null) {
            CreateRequest request = new CreateRequest();
            request.getExtendedData().put("newObject", transfer);
            request.setLocation(location.getPoint());
            Command command = editPart.getCommand((Request)request);
            if (command != null && command.canExecute()) {
                CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
                stack.startTrans(Messages.getString("LevelHandleDropAdapter.ActionText"));
                editPart.getViewer().getEditDomain().getCommandStack().execute(command);
                CrosstabReportItemHandle crosstab = this.getCrosstab(editPart);
                if (crosstab != null) {
                    AggregationCellProviderWrapper providerWrapper = new AggregationCellProviderWrapper(crosstab);
                    providerWrapper.updateAllAggregationCells(0);
                }
                stack.commit();
                return true;
            }
            return false;
        }
        return false;
    }

    private CrosstabReportItemHandle getCrosstab(EditPart editPart) {
        CrosstabReportItemHandle crosstab = null;
        Object tmp = editPart.getModel();
        if (!(tmp instanceof CrosstabCellAdapter)) {
            return null;
        }
        if (tmp instanceof VirtualCrosstabCellAdapter) {
            return ((VirtualCrosstabCellAdapter)tmp).getCrosstabReportItemHandle();
        }
        CrosstabCellHandle handle = ((CrosstabCellAdapter)tmp).getCrosstabCellHandle();
        if (handle != null) {
            crosstab = handle.getCrosstab();
        }
        return crosstab;
    }
}

