/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.views.provider;

import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RefreshAction;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.actions.ShowPropertyAction;
import org.eclipse.birt.report.designer.ui.cubebuilder.action.EditCubeAction;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.CubeBuilder;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.InsertCubeInLayoutAction;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class TabularCubeNodeProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        menu.add((IContributionItem)new Separator());
        InsertCubeInLayoutAction insertAction = new InsertCubeInLayoutAction(object);
        if (insertAction.isEnabled()) {
            menu.add((IAction)insertAction);
        }
        super.createContextMenu(sourceViewer, object, menu);
        if (((CubeHandle)object).canEdit()) {
            menu.insertAfter("additions", (IAction)new EditCubeAction(object, Messages.getString("InsertCubeInLayoutAction.menu.text")));
        }
        menu.insertBefore("additions-refresh", (IAction)new ShowPropertyAction(object));
        menu.insertAfter("additions-refresh", (IContributionItem)new Separator());
        RefreshAction action = new RefreshAction(sourceViewer);
        if (action.isEnabled()) {
            menu.insertAfter("additions-refresh", (IAction)action);
        }
    }

    public String getNodeDisplayName(Object model) {
        CubeHandle handle = (CubeHandle)model;
        return handle.getName();
    }

    public Object[] getChildren(Object object) {
        CubeHandle handle = (CubeHandle)object;
        return new Object[]{handle.getPropertyHandle("dimensions"), handle.getPropertyHandle("measureGroups")};
    }

    public boolean hasChildren(Object object) {
        return true;
    }

    protected boolean performEdit(ReportElementHandle handle) {
        TabularCubeHandle cubeHandle = (TabularCubeHandle)handle;
        CubeBuilder dialog = new CubeBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), cubeHandle);
        return dialog.open() == 0;
    }

    public Image getNodeIcon(Object model) {
        if (model instanceof DesignElementHandle && ((DesignElementHandle)model).getSemanticErrors().size() > 0) {
            return ReportPlatformUIImages.getImage((String)"IMG_OBJS_ERROR_TSK");
        }
        if (OlapUtil.isFromLibrary((Object)model)) {
            return UIHelper.getImage((String)"icons/obj16/cube_link.gif");
        }
        return UIHelper.getImage((String)"icons/obj16/cube.gif");
    }
}

