/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.HighlightRuleBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.HighlightHandleProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.CrosstabBindingExpressionProvider;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.plugin.CrosstabPlugin;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CrosstabHighlightRuleBuilder
extends HighlightRuleBuilder {
    public CrosstabHighlightRuleBuilder(Shell parentShell, String title, HighlightHandleProvider provider) {
        super(parentShell, title, provider);
    }

    protected void inilializeColumnList(DesignElementHandle handle) {
        super.inilializeColumnList(handle);
        this.expSelListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)CrosstabHighlightRuleBuilder.this.getExpressionControl());
                if (converter != null) {
                    if (CrosstabHighlightRuleBuilder.this.getExpression().equals(VALUE_OF_THIS_DATA_ITEM) && CrosstabHighlightRuleBuilder.this.designHandle instanceof DataItemHandle) {
                        CrosstabHighlightRuleBuilder.this.setExpression(ExpressionUtility.getDataExpression((String)((DataItemHandle)CrosstabHighlightRuleBuilder.this.designHandle).getResultSetColumn(), (IExpressionConverter)converter));
                    } else {
                        String newValue = CrosstabHighlightRuleBuilder.this.getExpression();
                        Object computedColumn = CrosstabHighlightRuleBuilder.this.getResultSetColumn(newValue);
                        if (computedColumn != null) {
                            String value = ExpressionUtility.getDataExpression((String)((ComputedColumnHandle)computedColumn).getName(), (IExpressionConverter)converter);
                            if (value != null) {
                                newValue = value;
                            }
                            CrosstabHighlightRuleBuilder.this.setExpression(newValue);
                        }
                    }
                    CrosstabHighlightRuleBuilder.this.updateButtons();
                }
            }
        };
    }

    protected List getSelectValueList() throws BirtException {
        CubeHandle cube = null;
        CrosstabReportItemHandle crosstab = null;
        if (this.designHandle instanceof ExtendedItemHandle) {
            IReportItem obj = ((ExtendedItemHandle)this.designHandle).getReportItem();
            DesignElementHandle tmp = this.designHandle;
            while (obj != null && !(obj instanceof ReportDesignHandle)) {
                if (obj instanceof CrosstabReportItemHandle) {
                    crosstab = (CrosstabReportItemHandle)obj;
                    cube = crosstab.getCube();
                    break;
                }
                if (!(tmp instanceof ExtendedItemHandle) || !((tmp = tmp.getContainer()) instanceof ExtendedItemHandle)) continue;
                obj = ((ExtendedItemHandle)tmp).getReportItem();
            }
        }
        if (cube == null || !(cube instanceof TabularCubeHandle) || this.getExpression().length() == 0) {
            return new ArrayList();
        }
        String expr = null;
        IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)this.getExpressionControl());
        if (converter != null) {
            int i = 0;
            while (i < this.columnList.size()) {
                String value;
                ComputedColumnHandle column = (ComputedColumnHandle)this.columnList.get(i);
                if (column != null && (value = ExpressionUtility.getDataExpression((String)column.getName(), (IExpressionConverter)converter)).equals(this.getExpression())) {
                    expr = ExpressionUtility.getDataExpression((String)column.getName(), (IExpressionConverter)ExpressionUtility.getExpressionConverter((String)"javascript"));
                    break;
                }
                ++i;
            }
        }
        Iterator iter = null;
        ICubeQueryDefinition cubeQueryDefn = null;
        DataRequestSession session = null;
        session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
        cubeQueryDefn = CrosstabUIHelper.createBindingQuery(crosstab);
        iter = session.getCubeQueryUtil().getMemberValueIterator((TabularCubeHandle)cube, expr, cubeQueryDefn);
        ArrayList valueList = new ArrayList();
        int count = 0;
        int MAX_COUNT = PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)CrosstabPlugin.getDefault(), UIUtil.getCurrentProject()).getInt("Filter.Limit");
        while (iter != null && iter.hasNext()) {
            Object obj = iter.next();
            if (obj == null || valueList.indexOf(obj) >= 0) continue;
            valueList.add(obj);
            if (++count >= MAX_COUNT) break;
        }
        if (session != null) {
            session.shutdown();
        }
        return valueList;
    }

    protected ExpressionProvider getExpressionProvider() {
        if (this.expressionProvider == null) {
            this.expressionProvider = new CrosstabBindingExpressionProvider(this.designHandle, null);
        }
        return this.expressionProvider;
    }

    protected String getSelectionValue(Combo combo) {
        String retValue = null;
        try {
            List selectValueList = this.getSelectValueList();
            if (selectValueList == null || selectValueList.size() == 0) {
                MessageDialog.openInformation(null, (String)Messages.getString("SelectValueDialog.selectValue"), (String)Messages.getString("SelectValueDialog.messages.info.selectVauleUnavailable"));
            } else {
                SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString("ExpressionValueCellEditor.title"));
                dialog.setSelectedValueList((Collection)selectValueList);
                if (dialog.open() == 0) {
                    retValue = dialog.getSelectedExprValue();
                }
            }
        }
        catch (Exception ex) {
            MessageDialog.openError(null, (String)Messages.getString("SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString("SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + ex.getMessage()));
        }
        return retValue;
    }

    protected void selectMultiValues(Combo combo) {
        String[] retValue = null;
        try {
            List selectValueList = this.getSelectValueList();
            if (selectValueList == null || selectValueList.size() == 0) {
                MessageDialog.openInformation(null, (String)Messages.getString("SelectValueDialog.selectValue"), (String)Messages.getString("SelectValueDialog.messages.info.selectVauleUnavailable"));
            } else {
                SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString("ExpressionValueCellEditor.title"));
                dialog.setSelectedValueList((Collection)selectValueList);
                dialog.setMultipleSelection(true);
                if (dialog.open() == 0) {
                    retValue = dialog.getSelectedExprValues();
                }
            }
        }
        catch (Exception ex) {
            MessageDialog.openError(null, (String)Messages.getString("SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString("SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + ex.getMessage()));
        }
        if (retValue != null) {
            this.addBtn.setEnabled(false);
            if (retValue.length == 1) {
                combo.setText(DEUtil.resolveNull((String)retValue[0]));
            } else if (retValue.length > 1) {
                combo.setText("");
            }
            boolean change = false;
            int i = 0;
            while (i < retValue.length) {
                Expression expression = new Expression((Object)retValue[i], ExpressionButtonUtil.getExpression((Control)combo).getType());
                if (this.valueList.indexOf(expression) < 0) {
                    this.valueList.add(expression);
                    change = true;
                }
                ++i;
            }
            if (change) {
                this.tableViewer.refresh();
                this.updateButtons();
                combo.setFocus();
            }
        }
    }

    protected int getHighlightExpCtrType(DesignElementHandle handle) {
        if (handle instanceof ExtendedItemHandle) {
            try {
                IReportItem obj = ((ExtendedItemHandle)handle).getReportItem();
                if (obj instanceof CrosstabReportItemHandle) {
                    return 1;
                }
            }
            catch (ExtendedElementException extendedElementException) {
                return 0;
            }
            return 0;
        }
        return 0;
    }

    protected void initilizeDlgDescription(DesignElementHandle handle) {
        if (!(handle instanceof ExtendedItemHandle)) {
            super.initilizeDlgDescription(handle);
            return;
        }
        Class[] classList = new Class[]{CrosstabReportItemHandle.class, CrosstabCellHandle.class};
        String[] desList = new String[]{Messages.getString("CrosstabHighlightRuleBuilderDialog.text.Description.Element.Crosstab"), Messages.getString("CrosstabHighlightRuleBuilderDialog.text.Description.Element.Crosstabcell")};
        try {
            IReportItem reportItem = ((ExtendedItemHandle)handle).getReportItem();
            Class<?> handleClass = reportItem.getClass();
            int i = 0;
            while (i < classList.length) {
                if (classList[i] == handleClass) {
                    this.dlgDescription = desList[i];
                    break;
                }
                ++i;
            }
            if (this.dlgDescription == null || this.dlgDescription.length() == 0) {
                this.dlgDescription = Messages.getString("CrosstabHighlightRuleBuilderDialog.text.Description.Element.ReportElement");
            }
            this.dlgDescription = Messages.getFormattedString("CrosstabHighlightRuleBuilderDialog.text.Description", new Object[]{this.dlgDescription});
        }
        catch (ExtendedElementException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }
}

