/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.parts.TablePart;
import org.eclipse.pde.internal.ui.util.PDELabelUtility;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Version;

public class PluginVersionPart {
    private Text fMinVersionText;
    private Text fMaxVersionText;
    private Combo fMinVersionBound;
    private Combo fMaxVersionBound;
    private VersionRange fVersionRange;
    private boolean fIsRanged;
    private boolean fRangeAllowed;

    public PluginVersionPart(boolean rangeAllowed) {
        this.fRangeAllowed = rangeAllowed;
    }

    public void setVersion(String version) {
        try {
            if (version != null && !version.equals("")) {
                this.fVersionRange = new VersionRange(version);
                Version max = this.fVersionRange.getMaximum();
                if (max.getMajor() != Integer.MAX_VALUE && this.fVersionRange.getMinimum().compareTo((Object)this.fVersionRange.getMaximum()) < 0) {
                    this.fIsRanged = true;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fVersionRange = new VersionRange("[1.0.0,1.0.0]");
        }
    }

    private void setVersion(String min, String max) {
        this.fMinVersionBound.select(0);
        this.fMinVersionText.setText(min);
        this.fMaxVersionBound.select(1);
        this.fMaxVersionText.setText(max);
    }

    public void createVersionFields(Composite comp, boolean createGroup, boolean editable) {
        if (this.fRangeAllowed) {
            this.createRangeField(comp, createGroup, editable);
        } else {
            this.createSingleField(comp, createGroup, editable);
        }
        this.preloadFields();
    }

    public void createVersionSelectionField(Composite comp, String id) {
        Group group = new Group(comp, 0);
        group.setText(PDEUIMessages.PluginVersionPart_groupTitle);
        group.setLayoutData((Object)new GridData(770));
        group.setLayout((Layout)new GridLayout(2, false));
        PluginVersionTablePart part = new PluginVersionTablePart(new String[]{PDEUIMessages.PluginVersionPart_buttonTitle});
        part.createControl((Composite)group, 66050, 1, null);
        part.setMinimumSize(0, 75);
        part.getViewer().setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        part.getViewer().setContentProvider((IContentProvider)new PluginVersionContentProvider());
        part.getViewer().setComparator(new ViewerComparator());
        part.getViewer().setInput((Object)PluginRegistry.findEntry((String)id));
        part.setButtonEnabled(0, false);
    }

    private void createRangeField(Composite parent, boolean createGroup, boolean editable) {
        if (createGroup) {
            parent = new Group(parent, 0);
            ((Group)parent).setText(this.getGroupText());
            parent.setLayoutData((Object)new GridData(768));
            parent.setLayout((Layout)new GridLayout(3, false));
        }
        String[] comboItems = new String[]{PDEUIMessages.DependencyPropertiesDialog_comboInclusive, PDEUIMessages.DependencyPropertiesDialog_comboExclusive};
        Label minlabel = new Label(parent, 0);
        minlabel.setText(PDEUIMessages.DependencyPropertiesDialog_minimumVersion);
        this.fMinVersionText = new Text(parent, 2052);
        this.fMinVersionText.setLayoutData((Object)new GridData(768));
        this.fMinVersionText.setEnabled(editable);
        this.fMinVersionBound = new Combo(parent, 2060);
        this.fMinVersionBound.setEnabled(editable);
        this.fMinVersionBound.setItems(comboItems);
        Label maxlabel = new Label(parent, 0);
        maxlabel.setText(PDEUIMessages.DependencyPropertiesDialog_maximumVersion);
        this.fMaxVersionText = new Text(parent, 2052);
        this.fMaxVersionText.setLayoutData((Object)new GridData(768));
        this.fMaxVersionText.setEnabled(editable);
        this.fMaxVersionBound = new Combo(parent, 2060);
        this.fMaxVersionBound.setEnabled(editable);
        this.fMaxVersionBound.setItems(comboItems);
    }

    private void createSingleField(Composite parent, boolean createGroup, boolean editable) {
        if (createGroup) {
            parent = new Group(parent, 0);
            ((Group)parent).setText(this.getGroupText());
            parent.setLayoutData((Object)new GridData(770));
            parent.setLayout((Layout)new GridLayout(2, false));
        }
        Label label = new Label(parent, 0);
        label.setText(PDEUIMessages.DependencyPropertiesDialog_version);
        this.fMinVersionText = new Text(parent, 2052);
        this.fMinVersionText.setLayoutData((Object)new GridData(768));
        this.fMinVersionText.setEnabled(editable);
    }

    public void preloadFields() {
        if (this.fRangeAllowed) {
            this.fMinVersionText.setText(this.fVersionRange != null ? this.fVersionRange.getMinimum().toString() : "");
            this.fMaxVersionText.setText(this.fVersionRange != null && this.fVersionRange.getMaximum().getMajor() != Integer.MAX_VALUE ? this.fVersionRange.getMaximum().toString() : "");
            if (this.fVersionRange != null) {
                this.fMinVersionBound.select(this.fVersionRange.getIncludeMinimum() ? 0 : 1);
            } else {
                this.fMinVersionBound.select(0);
            }
            if (this.fVersionRange != null && this.getMaxVersion().length() > 0) {
                this.fMaxVersionBound.select(this.fVersionRange.getIncludeMaximum() ? 0 : 1);
            } else {
                this.fMaxVersionBound.select(1);
            }
        }
        this.fMinVersionText.setText(this.fVersionRange != null ? this.fVersionRange.getMinimum().toString() : "");
    }

    private IStatus validateVersion(String text, Text textWidget, boolean shortErrorMessage) {
        if (text.length() == 0) {
            return Status.OK_STATUS;
        }
        if (VersionUtil.validateVersion((String)text).getSeverity() != 0) {
            String errorMessage = null;
            errorMessage = shortErrorMessage ? PDEUIMessages.DependencyPropertiesDialog_invalidFormat : PDECoreMessages.BundleErrorReporter_InvalidFormatInBundleVersion;
            return new Status(4, "org.eclipse.pde.ui", 4, PDELabelUtility.qualifyMessage(PDELabelUtility.getFieldLabel((Control)textWidget), errorMessage), null);
        }
        return Status.OK_STATUS;
    }

    private IStatus validateVersionRange(boolean shortErrorMessage) {
        Version v2;
        Version v1;
        if (!this.fRangeAllowed && this.getMinVersion().length() == 0 || this.fRangeAllowed && (this.getMinVersion().length() == 0 || this.getMaxVersion().length() == 0)) {
            this.fIsRanged = false;
            return Status.OK_STATUS;
        }
        String errorMessage = null;
        errorMessage = shortErrorMessage ? PDEUIMessages.DependencyPropertiesDialog_invalidFormat : PDECoreMessages.BundleErrorReporter_InvalidFormatInBundleVersion;
        try {
            v1 = new Version(this.getMinVersion());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new Status(4, "org.eclipse.pde.ui", 4, PDELabelUtility.qualifyMessage(PDELabelUtility.getFieldLabel((Control)this.fMinVersionText), errorMessage), null);
        }
        if (!this.fRangeAllowed) {
            return Status.OK_STATUS;
        }
        try {
            v2 = new Version(this.getMaxVersion());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new Status(4, "org.eclipse.pde.ui", 4, PDELabelUtility.qualifyMessage(PDELabelUtility.getFieldLabel((Control)this.fMaxVersionText), errorMessage), null);
        }
        if (v1.compareTo((Object)v2) == 0 || v1.compareTo((Object)v2) < 0) {
            this.fIsRanged = true;
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.pde.ui", 4, PDEUIMessages.DependencyPropertiesDialog_versionRangeError, null);
    }

    public IStatus validateFullVersionRangeText(boolean shortErrorMessage) {
        IStatus status = this.validateVersion(this.getMinVersion(), this.fMinVersionText, shortErrorMessage);
        if (status.isOK()) {
            status = this.validateVersion(this.getMaxVersion(), this.fMaxVersionText, shortErrorMessage);
        }
        if (status.isOK()) {
            status = this.validateVersionRange(shortErrorMessage);
        }
        return status;
    }

    private String getMinVersion() {
        return this.fMinVersionText.getText().trim();
    }

    private String getMaxVersion() {
        if (this.fMaxVersionText != null) {
            return this.fMaxVersionText.getText().trim();
        }
        return "";
    }

    private boolean getMinInclusive() {
        if (this.fMinVersionBound != null) {
            return this.fMinVersionBound.getSelectionIndex() == 0;
        }
        return false;
    }

    private boolean getMaxInclusive() {
        if (this.fMaxVersionBound != null) {
            return this.fMaxVersionBound.getSelectionIndex() == 0;
        }
        return true;
    }

    private String extractSingleVersionFromText() {
        if (!this.fRangeAllowed) {
            return this.getMinVersion();
        }
        if (this.getMinVersion().length() == 0) {
            return this.getMaxVersion();
        }
        return this.getMinVersion();
    }

    public String getVersion() {
        String version;
        if (this.fIsRanged) {
            String minV = this.getMinVersion();
            String maxV = this.getMaxVersion();
            boolean minI = this.getMinInclusive();
            boolean maxI = this.getMaxInclusive();
            if (minV.equals(maxV)) {
                maxI = true;
                minI = true;
            }
            version = new VersionRange(new Version(minV), minI, new Version(maxV), maxI).toString();
        } else {
            String singleversion = this.extractSingleVersionFromText();
            version = singleversion == null || singleversion.length() == 0 ? "" : new Version(singleversion).toString();
        }
        return version;
    }

    public void addListeners(ModifyListener minListener, ModifyListener maxListener) {
        if (this.fMinVersionText != null && minListener != null) {
            this.fMinVersionText.addModifyListener(minListener);
        }
        if (this.fRangeAllowed && this.fMaxVersionText != null && maxListener != null) {
            this.fMaxVersionText.addModifyListener(maxListener);
        }
    }

    protected String getGroupText() {
        return PDEUIMessages.DependencyPropertiesDialog_groupText;
    }

    private class PluginVersionContentProvider
    implements IStructuredContentProvider {
        private PluginVersionContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof ModelEntry) {
                ModelEntry entry = (ModelEntry)element;
                return entry.getActiveModels();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class PluginVersionTablePart
    extends TablePart {
        public PluginVersionTablePart(String[] buttonLabels) {
            super(buttonLabels);
        }

        protected void selectionChanged(IStructuredSelection selection) {
            if (selection.size() < 1) {
                this.setButtonEnabled(0, false);
            } else {
                this.setButtonEnabled(0, true);
            }
        }

        protected void handleDoubleClick(IStructuredSelection selection) {
            if (selection.size() == 1) {
                IPluginModelBase entry = (IPluginModelBase)selection.getFirstElement();
                String version = VersionUtil.computeInitialPluginVersion((String)entry.getBundleDescription().getVersion().toString());
                PluginVersionPart.this.setVersion(version, "");
            }
        }

        protected void buttonSelected(Button button, int index) {
            IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
            if (selection.size() == 1) {
                IPluginModelBase entry = (IPluginModelBase)selection.getFirstElement();
                String version = VersionUtil.computeInitialPluginVersion((String)entry.getBundleDescription().getVersion().toString());
                PluginVersionPart.this.setVersion(version, "");
            } else {
                Object[] objects = selection.toArray();
                IPluginModelBase min = (IPluginModelBase)objects[0];
                IPluginModelBase max = (IPluginModelBase)objects[objects.length - 1];
                String minVersion = VersionUtil.computeInitialPluginVersion((String)min.getBundleDescription().getVersion().toString());
                String maxVersion = VersionUtil.computeInitialPluginVersion((String)max.getBundleDescription().getVersion().toString());
                PluginVersionPart.this.setVersion(minVersion, maxVersion);
            }
        }
    }
}

