/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.rename;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.wst.xsd.ui.internal.refactor.INameUpdating;
import org.eclipse.wst.xsd.ui.internal.refactor.IReferenceUpdating;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringComponent;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.TextChangeManager;
import org.eclipse.xsd.XSDSchema;

public class RenameTargetNamespaceProcessor
extends RenameProcessor
implements INameUpdating,
IReferenceUpdating {
    private String newNamespace;
    private boolean updateReferences = true;
    private TextChangeManager changeManager;
    private XSDSchema model;
    public static final String IDENTIFIER = "org.eclipse.wst.ui.xsd.renameComponentProcessor";

    public RenameTargetNamespaceProcessor(XSDSchema model, String newName) {
        this.model = model;
        this.newNamespace = newName;
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public String getCurrentElementName() {
        return this.model.getTargetNamespace();
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return new String[]{"org.eclipse.jdt.core.javanature"};
    }

    protected void loadDerivedParticipants(RefactoringStatus status, List result, String[] natures, SharableParticipants shared) throws CoreException {
        String newCUName = this.getNewElementName();
        RenameArguments arguments = new RenameArguments(newCUName, this.getUpdateReferences());
        this.loadDerivedParticipants(status, result, this.computeDerivedElements(), arguments, natures, shared);
    }

    protected void loadDerivedParticipants(RefactoringStatus status, List result, Object[] derivedElements, RenameArguments arguments, String[] natures, SharableParticipants shared) throws CoreException {
        if (derivedElements != null) {
            int i = 0;
            while (i < derivedElements.length) {
                RenameParticipant[] participants = ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)derivedElements[i], (RenameArguments)arguments, (String[])natures, (SharableParticipants)shared);
                result.addAll(Arrays.asList(participants));
                ++i;
            }
        }
    }

    private Object[] computeDerivedElements() {
        Object[] elements = this.getElements();
        Object[] results = new Object[elements.length];
        int i = 0;
        while (i < elements.length) {
            RefactoringComponent component = (RefactoringComponent)elements[i];
            results[i] = component.getModelObject();
            ++i;
        }
        return results;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus refactoringStatus;
        try {
            RefactoringStatus result = new RefactoringStatus();
            pm.beginTask("", 9);
            this.changeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
            refactoringStatus = result;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange;
        try {
            String changeName = RefactoringMessages.getString("RenameComponentProcessor.Component_Refactoring_updates");
            compositeChange = new CompositeChange(changeName, (Change[])this.changeManager.getAllChanges());
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return compositeChange;
    }

    public Object[] getElements() {
        return new Object[]{this.model};
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return RefactoringMessages.getFormattedString("RenameComponentRefactoring.name", new String[]{this.getCurrentElementName(), this.getNewElementName()});
    }

    public boolean isApplicable() throws CoreException {
        return this.getModel() != null;
    }

    public RefactoringStatus checkNewElementName(String newName) {
        Assert.isNotNull((Object)newName, (String)"new name");
        return new RefactoringStatus();
    }

    public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        RenameArguments arguments = new RenameArguments(this.getNewElementName(), true);
        String[] natures = this.getAffectedProjectNatures();
        ArrayList result = new ArrayList();
        this.loadElementParticipants(status, result, arguments, natures, sharedParticipants);
        this.loadDerivedParticipants(status, result, natures, sharedParticipants);
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    protected void loadElementParticipants(RefactoringStatus status, List result, RenameArguments arguments, String[] natures, SharableParticipants shared) throws CoreException {
        Object[] elements = this.getElements();
        int i = 0;
        while (i < elements.length) {
            result.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)elements[i], (RenameArguments)arguments, (String[])natures, (SharableParticipants)shared)));
            ++i;
        }
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        TextChangeManager manager = new TextChangeManager(false);
        this.addDeclarationUpdate(manager);
        return manager;
    }

    private void addDeclarationUpdate(TextChangeManager manager) {
        String fileStr = this.getModel().getSchemaLocation();
        URI uri = URI.createPlatformResourceURI((String)fileStr);
        try {
            IWorkspaceRoot root;
            IFile file;
            URL url = new URL(uri.toString());
            url = Platform.resolve((URL)url);
            if (url != null && (file = (root = ResourcesPlugin.getWorkspace().getRoot()).getFileForLocation((IPath)new Path(url.getFile()))) != null) {
                TextChange change = manager.get(file);
                this.addDeclarationUpdate(change);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    final void addDeclarationUpdate(TextChange change) {
    }

    public void setNewElementName(String newName) {
        this.newNamespace = newName;
    }

    public String getNewElementName() {
        return this.newNamespace;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public boolean getUpdateReferences() {
        return this.updateReferences;
    }

    public void setUpdateReferences(boolean update) {
        this.updateReferences = update;
    }

    public final TextChangeManager getChangeManager() {
        return this.changeManager;
    }

    public final XSDSchema getModel() {
        return this.model;
    }
}

