/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.javascript;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.script.IScriptContext;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptableParameters;
import org.eclipse.birt.report.engine.executor.ScriptablePageVariables;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class JavascriptContext
implements IScriptContext {
    protected static Logger logger = Logger.getLogger(JavascriptContext.class.getName());
    protected Scriptable scope;
    private ScriptContext scriptContext;

    public JavascriptContext(ScriptContext scriptContext, Scriptable scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Scope can't be null.");
        }
        this.scope = scope;
        this.scriptContext = scriptContext;
    }

    public void setAttribute(String name, Object value) {
        value = this.wrap(this.scope, name, value);
        Object jsValue = Context.javaToJS((Object)value, (Scriptable)this.scope);
        this.scope.put(name, this.scope, jsValue);
    }

    public void removeAttribute(String name) {
        this.scope.delete(name);
    }

    public Scriptable getScope() {
        return this.scope;
    }

    private Object wrap(Scriptable scope, String name, Object value) {
        if (this.scriptContext.getParent() != null) {
            return value;
        }
        if ("params".equals(name) && value instanceof HashMap) {
            return new ScriptableParameters((Map)value, scope);
        }
        if ("vars".equals(name)) {
            return new ScriptablePageVariables((Map)value, scope);
        }
        return value;
    }

    private Object javaToJs(Object value, Scriptable scope) {
        return Context.javaToJS((Object)value, (Scriptable)scope);
    }
}

