/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.util.StringTokenizer;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BP2011
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    private final char[] OMMITED_XML_DECLARATION_DELIMITERS = new char[]{' ', '\t', '\r', '\n', '\'', '\"'};
    private final char[] XML_DECLARATION_DELIMITERS = new char[]{'='};
    private final String VERSION_TOKEN = "version";
    private final String VERSION = "1.0";

    public BP2011(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "notApplicable";
        Types types = (Types)entryContext.getEntry().getEntryDetail();
        List exts = null;
        if (types != null) {
            exts = types.getExtensibilityElements();
        }
        if (exts != null) {
            Definition definition = null;
            definition = this.validator.analyzerContext.getCandidateInfo().getDefinition(types);
            if (definition == null) {
                throw new WSIException("Could not find types definition in any WSDL document.");
            }
            Iterator it = exts.iterator();
            while (it.hasNext()) {
                ExtensibilityElement el = (ExtensibilityElement)it.next();
                if (!(el instanceof Schema)) continue;
                this.searchForSchema(((Schema)el).getElement(), definition.getDocumentBaseURI(), new ArrayList());
            }
        }
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private void searchForSchema(Node n, String context, List processedSchemas) {
        if (n != null && !processedSchemas.contains(n)) {
            while (n != null) {
                if (1 == n.getNodeType()) {
                    if (XMLUtils.equals(n, ELEM_XSD_SCHEMA)) {
                        this.processSchema(n, context, processedSchemas);
                    } else if (XMLUtils.equals(n, ELEM_XSD_IMPORT) && XMLUtils.equals(n.getParentNode(), ELEM_XSD_SCHEMA)) {
                        this.loadSchema(n, context, processedSchemas);
                    } else {
                        this.searchForSchema(n.getFirstChild(), context, processedSchemas);
                    }
                }
                n = n.getNextSibling();
            }
        }
    }

    private void loadSchema(Node importNode, String context, List processedSchemas) {
        Element im = (Element)importNode;
        Attr schemaLocation = XMLUtils.getAttribute(im, ATTR_XSD_SCHEMALOCATION);
        if (schemaLocation != null && schemaLocation.getValue() != null) {
            try {
                Document schema;
                String decl = this.readXMLDeclarationStatement(schemaLocation.getValue(), context);
                if (!this.validVersion(decl)) {
                    Attr a = XMLUtils.getAttribute(im, ATTR_XSD_NAMESPACE);
                    this.errors.add(a != null ? a.getValue() : "");
                }
                if (XMLUtils.equals((schema = this.validator.parseXMLDocumentURL(schemaLocation.getValue(), context)).getDocumentElement(), ELEM_XSD_SCHEMA)) {
                    this.processSchema(schema.getDocumentElement(), XMLUtils.createURLString(schemaLocation.getValue(), context), processedSchemas);
                }
                this.result = "passed";
            }
            catch (Throwable throwable) {}
        } else if (XMLUtils.getAttribute(im, ATTR_XSD_NAMESPACE) != null) {
            this.result = "passed";
        }
    }

    /*
     * Exception decompiling
     */
    private String readXMLDeclarationStatement(String location, String baseURI) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 296->299)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean validVersion(String xmlDecl) {
        boolean result = true;
        if (xmlDecl != null) {
            StringTokenizer st = new StringTokenizer(this.OMMITED_XML_DECLARATION_DELIMITERS, this.XML_DECLARATION_DELIMITERS);
            Enumeration tokens = st.parse(xmlDecl);
            boolean found = false;
            while (tokens.hasMoreElements() && !found) {
                String token = (String)tokens.nextElement();
                if (!token.equalsIgnoreCase("version")) continue;
                found = true;
                tokens.nextElement();
                String ver = (String)tokens.nextElement();
                result = "1.0".equals(ver);
            }
        }
        return result;
    }

    private void processSchema(Node schema, String context, List processedSchemas) {
        if (schema != null && !processedSchemas.contains(schema)) {
            processedSchemas.add(schema);
            Node n = schema.getFirstChild();
            while (n != null) {
                if (1 == n.getNodeType() && XMLUtils.equals(n, ELEM_XSD_IMPORT)) {
                    this.loadSchema(n, context, processedSchemas);
                }
                n = n.getNextSibling();
            }
        }
    }
}

