/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config.postscript;

import java.util.Locale;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.emitter.config.AbstractConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.AbstractEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.ConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.IOptionValue;
import org.eclipse.birt.report.engine.emitter.config.OptionValue;
import org.eclipse.birt.report.engine.emitter.config.postscript.i18n.Messages;

public class PostscriptEmitterDescriptor
extends AbstractEmitterDescriptor {
    private static final String FONT_SUBSTITUTION = "FontSubstitution";
    private static final String BIDI_PROCESSING = "BIDIProcessing";
    private static final String TEXT_WRAPPING = "TextWrapping";
    private static final String CHART_DPI = "ChartDpi";
    private IConfigurableOption[] options;
    private Locale locale;

    public PostscriptEmitterDescriptor() {
        this.initOptions();
    }

    public void setLocale(Locale locale) {
        if (this.locale != locale) {
            this.locale = locale;
            this.initOptions();
        }
    }

    private void initOptions() {
        ConfigurableOption bidiProcessing = new ConfigurableOption(BIDI_PROCESSING);
        bidiProcessing.setDisplayName(this.getMessage("OptionDisplayValue.BidiProcessing"));
        bidiProcessing.setDataType(IConfigurableOption.DataType.BOOLEAN);
        bidiProcessing.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        bidiProcessing.setDefaultValue((Object)Boolean.TRUE);
        bidiProcessing.setToolTip(null);
        bidiProcessing.setDescription(this.getMessage("OptionDescription.BidiProcessing"));
        ConfigurableOption textWrapping = new ConfigurableOption(TEXT_WRAPPING);
        textWrapping.setDisplayName(this.getMessage("OptionDisplayValue.TextWrapping"));
        textWrapping.setDataType(IConfigurableOption.DataType.BOOLEAN);
        textWrapping.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        textWrapping.setDefaultValue((Object)Boolean.TRUE);
        textWrapping.setToolTip(null);
        textWrapping.setDescription(this.getMessage("OptionDescription.TextWrapping"));
        ConfigurableOption fontSubstitution = new ConfigurableOption(FONT_SUBSTITUTION);
        fontSubstitution.setDisplayName(this.getMessage("OptionDisplayValue.FontSubstitution"));
        fontSubstitution.setDataType(IConfigurableOption.DataType.BOOLEAN);
        fontSubstitution.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        fontSubstitution.setDefaultValue((Object)Boolean.TRUE);
        fontSubstitution.setToolTip(null);
        fontSubstitution.setDescription(this.getMessage("OptionDescription.FontSubstitution"));
        ConfigurableOption pageOverFlow = new ConfigurableOption("pdfRenderOption.pageOverflow");
        pageOverFlow.setDisplayName(this.getMessage("OptionDisplayValue.PageOverFlow"));
        pageOverFlow.setDataType(IConfigurableOption.DataType.INTEGER);
        pageOverFlow.setDisplayType(IConfigurableOption.DisplayType.COMBO);
        pageOverFlow.setChoices((IOptionValue[])new OptionValue[]{new OptionValue((Object)1, this.getMessage("OptionDisplayValue.CLIP_CONTENT")), new OptionValue((Object)2, this.getMessage("OptionDisplayValue.FIT_TO_PAGE_SIZE")), new OptionValue((Object)4, this.getMessage("OptionDisplayValue.OUTPUT_TO_MULTIPLE_PAGES")), new OptionValue((Object)8, this.getMessage("OptionDisplayValue.ENLARGE_PAGE_SIZE"))});
        pageOverFlow.setDefaultValue((Object)1);
        pageOverFlow.setToolTip(null);
        pageOverFlow.setDescription(this.getMessage("OptionDescription.PageOverFlow"));
        ConfigurableOption copies = new ConfigurableOption("OptionCopies");
        copies.setDisplayName(this.getMessage("OptionDisplayValue.Copies"));
        copies.setDataType(IConfigurableOption.DataType.INTEGER);
        copies.setDisplayType(IConfigurableOption.DisplayType.TEXT);
        copies.setDefaultValue((Object)1);
        copies.setToolTip(null);
        copies.setDescription(this.getMessage("OptionDescription.Copies"));
        ConfigurableOption collate = new ConfigurableOption("OptionCollate");
        collate.setDisplayName(this.getMessage("OptionDisplayValue.Collate"));
        collate.setDataType(IConfigurableOption.DataType.BOOLEAN);
        collate.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        collate.setDefaultValue((Object)Boolean.FALSE);
        collate.setToolTip(null);
        collate.setDescription(this.getMessage("OptionDescription.Collate"));
        ConfigurableOption duplex = new ConfigurableOption("OptionDuplex");
        duplex.setDisplayName(this.getMessage("OptionDisplayValue.Duplex"));
        duplex.setDataType(IConfigurableOption.DataType.STRING);
        duplex.setDisplayType(IConfigurableOption.DisplayType.TEXT);
        duplex.setDefaultValue(null);
        duplex.setToolTip(null);
        duplex.setDescription(this.getMessage("OptionDescription.Duplex"));
        ConfigurableOption paperSize = new ConfigurableOption("OptionPagerSize");
        paperSize.setDisplayName(this.getMessage("OptionDisplayValue.PaperSize"));
        paperSize.setDataType(IConfigurableOption.DataType.STRING);
        paperSize.setDisplayType(IConfigurableOption.DisplayType.TEXT);
        paperSize.setDefaultValue((Object)"A4");
        paperSize.setToolTip(null);
        paperSize.setDescription(this.getMessage("OptionDescription.PaperSize"));
        ConfigurableOption paperTray = new ConfigurableOption("OptionPageTray");
        paperTray.setDisplayName(this.getMessage("OptionDisplayValue.PaperTray"));
        paperTray.setDataType(IConfigurableOption.DataType.STRING);
        paperTray.setDisplayType(IConfigurableOption.DisplayType.TEXT);
        paperTray.setDefaultValue(null);
        paperTray.setToolTip(null);
        paperTray.setDescription(this.getMessage("OptionDescription.PaperTray"));
        ConfigurableOption chartDpi = new ConfigurableOption(CHART_DPI);
        chartDpi.setDisplayName(this.getMessage("OptionDisplayValue.ChartDpi"));
        chartDpi.setDataType(IConfigurableOption.DataType.INTEGER);
        chartDpi.setDisplayType(IConfigurableOption.DisplayType.TEXT);
        chartDpi.setDefaultValue((Object)new Integer(192));
        chartDpi.setToolTip(null);
        chartDpi.setDescription(this.getMessage("OptionDescription.ChartDpi"));
        this.options = new IConfigurableOption[]{bidiProcessing, textWrapping, fontSubstitution, pageOverFlow, copies, collate, duplex, paperSize, paperTray, chartDpi};
    }

    private String getMessage(String key) {
        return Messages.getString(key, this.locale);
    }

    public IConfigurableOptionObserver createOptionObserver() {
        return new PostscriptOptionObserver();
    }

    public String getDescription() {
        return this.getMessage("PostscriptEmitter.Description");
    }

    public String getDisplayName() {
        return this.getMessage("PostscriptEmitter.DisplayName");
    }

    public String getID() {
        return "org.eclipse.birt.report.engine.emitter.postscript";
    }

    public String getRenderOptionName(String name) {
        assert (name != null);
        if (TEXT_WRAPPING.equals(name)) {
            return "pdfRenderOption.textWrapping";
        }
        if (BIDI_PROCESSING.equals(name)) {
            return "pdfRenderOption.bidiProcessing";
        }
        if (FONT_SUBSTITUTION.equals(name)) {
            return "pdfRenderOption.fontSubstitution";
        }
        if (CHART_DPI.equals(name)) {
            return CHART_DPI;
        }
        return name;
    }

    class PostscriptOptionObserver
    extends AbstractConfigurableOptionObserver {
        PostscriptOptionObserver() {
        }

        public IConfigurableOption[] getOptions() {
            return PostscriptEmitterDescriptor.this.options;
        }

        public IRenderOption getPreferredRenderOption() {
            RenderOption renderOption = new RenderOption();
            renderOption.setEmitterID(PostscriptEmitterDescriptor.this.getID());
            renderOption.setOutputFormat("postscript");
            IOptionValue[] iOptionValueArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                IOptionValue optionValue = iOptionValueArray[n2];
                if (optionValue != null) {
                    renderOption.setOption(PostscriptEmitterDescriptor.this.getRenderOptionName(optionValue.getName()), optionValue.getValue());
                }
                ++n2;
            }
            return renderOption;
        }
    }
}

