/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.DatePicker;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.AbstractRetrieveTitleFromUrlJob;
import org.eclipse.mylyn.internal.tasks.ui.views.Messages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TaskInputDialog
extends Dialog {
    private String taskName = "";
    private String priority = "P3";
    private String taskURL = "http://";
    private Date reminderDate;
    private Text taskNameTextWidget;
    private Text issueURLTextWidget;
    private Button getDescButton;

    public TaskInputDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(5, false);
        composite.setLayout((Layout)gl);
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(480);
        composite.setLayoutData((Object)data);
        Label taskNameLabel = new Label(composite, 64);
        taskNameLabel.setText(Messages.TaskInputDialog_Description);
        taskNameLabel.setFont(parent.getFont());
        this.taskNameTextWidget = new Text(composite, 2052);
        GridData taskNameGD = new GridData(768);
        taskNameGD.widthHint = 200;
        taskNameGD.horizontalSpan = 1;
        this.taskNameTextWidget.setLayoutData((Object)taskNameGD);
        final Combo c = new Combo(composite, 262670);
        c.setItems(TaskListView.PRIORITY_LEVELS);
        c.setText(this.priority);
        c.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TaskInputDialog.this.priority = c.getText();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        final DatePicker datePicker = new DatePicker(composite, 2048, DatePicker.LABEL_CHOOSE, true, TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour"));
        datePicker.addPickerSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (datePicker.getDate() != null) {
                    TaskInputDialog.this.reminderDate = datePicker.getDate().getTime();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Button removeReminder = new Button(composite, 0x1000008);
        removeReminder.setText(Messages.TaskInputDialog_Clear);
        removeReminder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                datePicker.setDate(null);
                TaskInputDialog.this.reminderDate = null;
            }
        });
        Label urlLabel = new Label(composite, 64);
        urlLabel.setText(Messages.TaskInputDialog_Web_Link);
        urlLabel.setFont(parent.getFont());
        this.issueURLTextWidget = new Text(composite, 2052);
        this.issueURLTextWidget.setText(this.getDefaultIssueUrl());
        GridData urlData = new GridData(768);
        urlData.horizontalSpan = 3;
        urlData.grabExcessHorizontalSpace = true;
        this.issueURLTextWidget.setLayoutData((Object)urlData);
        this.getDescButton = new Button(composite, 8);
        this.getDescButton.setText(Messages.TaskInputDialog_Get_Description);
        this.getDescButton.setLayoutData((Object)new GridData(128));
        this.setButtonStatus();
        this.issueURLTextWidget.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                TaskInputDialog.this.setButtonStatus();
            }

            public void keyReleased(KeyEvent e) {
                TaskInputDialog.this.setButtonStatus();
            }
        });
        this.getDescButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TaskInputDialog.this.retrieveTaskDescription(TaskInputDialog.this.issueURLTextWidget.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    protected void setButtonStatus() {
        String url = this.issueURLTextWidget.getText();
        if (url.length() > 10 && (url.startsWith("http://") || url.startsWith("https://"))) {
            this.getDescButton.setEnabled(true);
        } else {
            this.getDescButton.setEnabled(false);
        }
    }

    protected String getDefaultIssueUrl() {
        String clipboardText = this.getClipboardText();
        if (clipboardText.startsWith("http://") || clipboardText.startsWith("https://") && clipboardText.length() > 10) {
            return clipboardText;
        }
        return this.taskURL;
    }

    protected void retrieveTaskDescription(String url) {
        try {
            AbstractRetrieveTitleFromUrlJob job = new AbstractRetrieveTitleFromUrlJob(this.issueURLTextWidget.getText()){

                protected void titleRetrieved(String pageTitle) {
                    TaskInputDialog.this.taskNameTextWidget.setText(pageTitle);
                }
            };
            job.schedule();
        }
        catch (RuntimeException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not open task web page", (Throwable)e));
        }
    }

    protected String getClipboardText() {
        TextTransfer transfer;
        Clipboard clipboard = new Clipboard(Display.getDefault());
        String contents = (String)clipboard.getContents((Transfer)(transfer = TextTransfer.getInstance()));
        if (contents != null) {
            return contents;
        }
        return "";
    }

    public String getSelectedPriority() {
        return this.priority;
    }

    public String getTaskname() {
        return this.taskName;
    }

    public Date getReminderDate() {
        return this.reminderDate;
    }

    public String getIssueURL() {
        return this.taskURL;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.taskName = this.taskNameTextWidget.getText();
            this.taskURL = this.issueURLTextWidget.getText();
        } else {
            this.taskName = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.TaskInputDialog_New_Task);
    }
}

