/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.parsers.sql.query.postparse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCast;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionFunction;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNested;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionVariable;
import org.eclipse.datatools.modelbase.sql.query.helper.ValueExpressionHelper;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParseErrorInfo;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserLogger;
import org.eclipse.datatools.sqltools.parsers.sql.postparse.PostParseProcessor;
import org.eclipse.datatools.sqltools.parsers.sql.postparse.PostParseProcessorConfiguration;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserMessages;

public class DataTypeResolver
implements PostParseProcessor {
    protected static Class[] CANDIDATE_TYPES = new Class[]{QueryStatement.class, QueryValueExpression.class, Predicate.class};
    public static final String ERROR_CODE_DATATYPE_UNRESOLVED = "SQL_?DTU";
    public static final String ERROR_CODE_VARIABLE_TYPE_UNCLEAR = "SQL_?HVTU";
    public static final String ERROR_CODE_DATATYPES_INCOMPATIBLE = "SQL_?DTI";
    protected static final String ERROR_MESSAGE_KEY_DATATYPE_UNRESOLVED = "DataTypeResolver.DATA_TYPE_UNDETERMINED";
    protected static final String ERROR_MESSAGE_KEY_VARIABLE_TYPE_UNCLEAR = "DataTypeResolver.VARIABLE_TYPE_UNDETERMINED";
    protected static final String ERROR_MESSAGE_KEY_DATATYPES_INCOMPATIBLE = "DataTypeResolver.DATA_TYPES_INCOMPATIBLE";
    protected List unresolvedExprList = new ArrayList();
    protected HashMap resolvedVariableMap = new HashMap();
    protected boolean logError = true;

    public DataTypeResolver() {
    }

    public DataTypeResolver(boolean logError) {
        this();
        this.logError = logError;
    }

    public Class[] getProcessCandidateTypes() {
        return CANDIDATE_TYPES;
    }

    public void config(PostParseProcessorConfiguration config) {
    }

    public List process(SQLQueryObject sqlQuery) throws SQLParserException {
        ArrayList errorList = new ArrayList();
        if (sqlQuery == null) {
            return errorList;
        }
        if (sqlQuery instanceof QueryValueExpression) {
            QueryValueExpression valueExpr = (QueryValueExpression)sqlQuery;
            errorList.addAll(this.resolveDataType(valueExpr));
            if (valueExpr.getDataType() == null) {
                this.unresolvedExprList.add(valueExpr);
            }
        }
        if (sqlQuery instanceof QueryStatement) {
            this.backtrackDataTypes();
            errorList.addAll(this.checkForUnresolvedDataTypes());
        }
        return errorList;
    }

    public void resetState() {
        this.unresolvedExprList.clear();
    }

    public Map getParsedObjectsReplacementMap() {
        return null;
    }

    protected List resolveDataType(QueryValueExpression valueExpr) {
        ArrayList errorList = new ArrayList();
        ValueExpressionHelper.resolveValueExpressionDatatype((QueryValueExpression)valueExpr);
        if (valueExpr instanceof ValueExpressionVariable) {
            ArrayList<QueryValueExpression> sameNameVars = (ArrayList<QueryValueExpression>)this.resolvedVariableMap.get(valueExpr.getName());
            if (valueExpr.getDataType() != null) {
                if (sameNameVars == null) {
                    sameNameVars = new ArrayList<QueryValueExpression>();
                    this.resolvedVariableMap.put(valueExpr.getName(), sameNameVars);
                }
                sameNameVars.add(valueExpr);
            } else if (sameNameVars != null && sameNameVars.size() > 0) {
                ValueExpressionVariable otherOccurence = (ValueExpressionVariable)sameNameVars.get(0);
                ValueExpressionHelper.copyDataType((QueryValueExpression)otherOccurence, (QueryValueExpression)valueExpr);
            }
        } else if (valueExpr instanceof ValueExpressionCast) {
            errorList.addAll(this.checkCastExpressionType(valueExpr.getDataType()));
        }
        return errorList;
    }

    protected void backtrackDataTypes() {
        int unresolved = this.unresolvedExprList.size();
        int prevUnresolved = unresolved + 1;
        boolean reverseIt = true;
        ListIterator resolveIt = null;
        boolean hasMoreElements = false;
        if (reverseIt) {
            resolveIt = this.unresolvedExprList.listIterator(unresolved);
            hasMoreElements = resolveIt.hasPrevious();
        }
        while (hasMoreElements) {
            Object element = reverseIt ? resolveIt.previous() : resolveIt.next();
            QueryValueExpression valueExpr = (QueryValueExpression)element;
            this.resolveDataType(valueExpr);
            if (valueExpr.getDataType() != null) {
                resolveIt.remove();
                --unresolved;
            }
            boolean bl = hasMoreElements = reverseIt ? resolveIt.hasPrevious() : resolveIt.hasNext();
            if (hasMoreElements || unresolved <= 0 || unresolved >= prevUnresolved) continue;
            reverseIt = !reverseIt;
            hasMoreElements = true;
            prevUnresolved = unresolved;
        }
    }

    protected List checkForUnresolvedDataTypes() {
        ArrayList<SQLParseErrorInfo> errorList = new ArrayList<SQLParseErrorInfo>();
        for (QueryValueExpression expr : this.unresolvedExprList) {
            if (expr.getDataType() != null) continue;
            if (expr instanceof ValueExpressionVariable) {
                errorList.add(new SQLParseErrorInfo(expr.getSourceInfo(), null, SQLQueryParserMessages.getString(ERROR_MESSAGE_KEY_VARIABLE_TYPE_UNCLEAR, new String[]{expr.getSQL()}), ERROR_CODE_VARIABLE_TYPE_UNCLEAR));
                continue;
            }
            if (expr instanceof ValueExpressionFunction || expr instanceof ValueExpressionNested && ((ValueExpressionNested)expr).getNestedValueExpr() != null && ((ValueExpressionNested)expr).getNestedValueExpr().getDataType() == null) continue;
            errorList.add(new SQLParseErrorInfo(expr.getSourceInfo(), null, SQLQueryParserMessages.getString(ERROR_MESSAGE_KEY_DATATYPE_UNRESOLVED, new String[]{expr.getSQL()}), ERROR_CODE_DATATYPE_UNRESOLVED));
        }
        this.printErrorList(errorList);
        errorList.clear();
        return errorList;
    }

    protected void printErrorList(List errorList) {
        if (errorList == null || errorList.isEmpty()) {
            return;
        }
        SQLParserLogger.getLogger().writeInfo("Errors encountered by " + this.getClass().getName() + ":");
        for (SQLParseErrorInfo errorInfo : errorList) {
            String expected = errorInfo.getExpectedText() != null ? ", expected: \"" + errorInfo.getExpectedText() + "\"" : "";
            SQLParserLogger.getLogger().writeInfo(String.valueOf(errorInfo.getParserErrorMessage()) + " at line:column " + errorInfo.getLineNumberStart() + ":" + errorInfo.getColumnNumberStart() + " to line:column " + errorInfo.getLineNumberEnd() + ":" + errorInfo.getColumnNumberEnd() + " \"" + errorInfo.getErrorSourceText() + "\"" + expected);
        }
    }

    protected List checkCastExpressionType(DataType castType) {
        PrimitiveType primitiveType;
        ArrayList errorList = new ArrayList();
        if (castType != null && castType instanceof PredefinedDataType && (primitiveType = ((PredefinedDataType)castType).getPrimitiveType()) != null && castType instanceof CharacterStringDataType) {
            CharacterStringDataType charType = (CharacterStringDataType)castType;
            if ((primitiveType.equals(PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL) || primitiveType.equals(PrimitiveType.NATIONAL_CHARACTER_LARGE_OBJECT_LITERAL)) && charType.getLength() == 0) {
                charType.setLength(0x100000);
            } else if ((primitiveType.equals(PrimitiveType.CHARACTER_LITERAL) || primitiveType.equals(PrimitiveType.NATIONAL_CHARACTER_LITERAL)) && charType.getLength() == 0) {
                charType.setLength(1);
            }
        }
        return errorList;
    }
}

