/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.deltaddl;

import org.eclipse.datatools.enablement.sybase.asa.ISybaseASADdlConstants;
import org.eclipse.datatools.enablement.sybase.asa.ddl.SybaseASADdlBuilder;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseIndex;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseIndexDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASAIndexDeltaDdlGenProvider
extends SybaseIndexDeltaDdlGenProvider
implements IDeltaDdlGenProvider,
ISybaseASADdlConstants {
    protected void getModificationResult(SQLObject e, EStructuralFeature feature, Object oldValue, Object newValue, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        SybaseASABaseIndex index = (SybaseASABaseIndex)e;
        int featureId = feature.getFeatureID();
        Table table = index.getTable();
        String owner = table.getSchema().getName();
        String tableName = table.getName();
        StringBuffer statement = new StringBuffer(256);
        switch (featureId) {
            case 1: {
                statement.append("ALTER INDEX ");
                statement.append(quoteIdentifiers ? SQLUtil.quote((String)oldValue.toString(), (String)"\"") : oldValue.toString());
                statement.append(" ON ");
                statement.append(quoteIdentifiers ? SQLUtil.quote((String)owner, (String)"\"") : owner);
                statement.append(".");
                statement.append(quoteIdentifiers ? SQLUtil.quote((String)tableName, (String)"\"") : tableName);
                statement.append(" RENAME AS ");
                statement.append(quoteIdentifiers ? SQLUtil.quote((String)newValue.toString(), (String)"\"") : newValue);
                script.addAlterOtherStatements(statement.toString());
                break;
            }
            case 8: {
                statement.append("ALTER INDEX ");
                statement.append(quoteIdentifiers ? SQLUtil.quote((String)index.getName(), (String)"\"") : index.getName());
                statement.append(" ON ");
                statement.append(quoteIdentifiers ? SQLUtil.quote((String)owner, (String)"\"") : owner);
                statement.append(".");
                statement.append(quoteIdentifiers ? SQLUtil.quote((String)tableName, (String)"\"") : tableName);
                if (newValue instanceof Boolean && ((Boolean)newValue).booleanValue()) {
                    statement.append(" CLUSTERED");
                } else {
                    statement.append(" NONCLUSTERED");
                }
                if (((Boolean)newValue).booleanValue()) {
                    script.addAlterIndexClusteredStatements(statement.toString());
                    break;
                }
                script.addAlterIndexNonclusteredStatements(statement.toString());
                break;
            }
            case 3: {
                script.addAlterOtherStatements(SybaseASADdlBuilder.getInstance().createComment(e, quoteIdentifiers, qualifyNames));
                break;
            }
            default: {
                return;
            }
        }
    }

    protected boolean needRecreate(EStructuralFeature feature) {
        if (feature != null) {
            switch (feature.getFeatureID()) {
                case 1: {
                    return false;
                }
                case 8: {
                    return false;
                }
                case 3: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }
}

