/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.script.ParameterAttribute;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IBookmarkInfo;
import org.eclipse.birt.report.engine.api.IReportDocumentHelper;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.impl.BookmarkInfo;
import org.eclipse.birt.report.engine.api.impl.IReportletDocument;
import org.eclipse.birt.report.engine.api.impl.LinkedObjectManager;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentConstants;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.impl.BookmarkContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.executor.ApplicationClassLoader;
import org.eclipse.birt.report.engine.extension.engine.IReportDocumentExtension;
import org.eclipse.birt.report.engine.extension.engine.IReportEngineExtension;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.IPageHintReader;
import org.eclipse.birt.report.engine.internal.document.PageHintReader;
import org.eclipse.birt.report.engine.internal.document.v3.ReportContentReaderV3;
import org.eclipse.birt.report.engine.internal.document.v4.InstanceIDComparator;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.index.DocumentIndexReader;
import org.eclipse.birt.report.engine.internal.index.IDocumentIndexReader;
import org.eclipse.birt.report.engine.ir.EngineIRReader;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.toc.ITOCReader;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCReader;
import org.eclipse.birt.report.engine.toc.TOCView;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportDocumentReader
implements IReportletDocument,
ReportDocumentConstants,
IReportDocumentHelper {
    private static Logger logger = Logger.getLogger(ReportDocumentReader.class.getName());
    private ReportEngine engine;
    private IDocArchiveReader archive;
    private Map moduleOptions;
    private String coreVersion;
    private Map properties = new HashMap();
    private HashMap parameters;
    private HashMap globalVariables;
    private IPageHintReader pageHintReader;
    private ITOCReader tocReader;
    private IDocumentIndexReader indexReader;
    private String systemId;
    private int checkpoint = 0;
    private long pageCount;
    private boolean sharedArchive;
    private ApplicationClassLoader applicationClassLoader;
    private ReportRunnable preparedRunnable = null;
    private ReportRunnable reportRunnable = null;
    private boolean coreStreamLoaded = false;
    private LinkedObjectManager.LinkedEntry<ReportDocumentReader> engineCacheEntry;
    private Boolean isReportlet;
    private String reportletBookmark;
    private String reportletInstanceID;
    HashMap<String, IReportDocumentExtension> extensions = new HashMap();

    public ReportDocumentReader(ReportEngine engine, IDocArchiveReader archive, boolean sharedArchive) throws EngineException {
        this(null, engine, archive, sharedArchive);
    }

    public ReportDocumentReader(ReportEngine engine, IDocArchiveReader archive) throws EngineException {
        this(null, engine, archive, false);
    }

    public ReportDocumentReader(String systemId, ReportEngine engine, IDocArchiveReader archive, Map options) throws EngineException {
        this(systemId, engine, archive, false, options);
    }

    public ReportDocumentReader(String systemId, ReportEngine engine, IDocArchiveReader archive, boolean sharedArchive) throws EngineException {
        this(systemId, engine, archive, sharedArchive, null);
    }

    public ReportDocumentReader(String systemId, ReportEngine engine, IDocArchiveReader archive, boolean sharedArchive, Map options) throws EngineException {
        this.engine = engine;
        this.archive = archive;
        this.systemId = systemId;
        this.sharedArchive = sharedArchive;
        this.moduleOptions = new HashMap();
        this.moduleOptions.put("semanticCheck", Boolean.FALSE);
        if (options != null) {
            this.moduleOptions.putAll(options);
        }
        this.loadCoreStreamHeader();
    }

    @Override
    public IDocArchiveReader getArchive() {
        return this.archive;
    }

    @Override
    public String getVersion() {
        return (String)this.properties.get("BIRT ENGINE VERSION");
    }

    @Override
    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCoreStreamHeader() throws EngineException {
        try {
            Object lock = this.archive.lock("/core");
            try {
                Object object = lock;
                synchronized (object) {
                    RAInputStream in = this.archive.getStream("/core");
                    try {
                        DataInputStream di = new DataInputStream((InputStream)in);
                        this.checkVersion(di);
                        this.loadCoreStreamHeader(di);
                    }
                    finally {
                        in.close();
                    }
                }
            }
            finally {
                this.archive.unlock(lock);
            }
        }
        catch (IOException ee) {
            this.close();
            throw new EngineException("Error.ReportDocmentOpenError", ee);
        }
    }

    private void loadCoreStreamHeader(DataInputStream di) throws IOException {
        ReportDocumentCoreInfo documentInfo = new ReportDocumentCoreInfo();
        this.loadCoreStreamHeader(di, documentInfo);
        if (this.checkpoint != documentInfo.checkpoint) {
            this.checkpoint = documentInfo.checkpoint;
            this.pageCount = documentInfo.pageCount;
            if (this.systemId == null) {
                this.systemId = documentInfo.systemId;
            }
        }
    }

    private void loadCoreStreamHeader(DataInputStream di, ReportDocumentCoreInfo documentInfo) throws IOException {
        if ("CORE_VERSION_UNKNOWN".equals(this.coreVersion)) {
            this.loadCoreStreamHeaderUnknown(di, documentInfo);
        } else if ("CORE_VERSION_0".equals(this.coreVersion) || "CORE_VERSION_1".equals(this.coreVersion) || "CORE_VERSION_2".equals(this.coreVersion)) {
            this.loadCoreStreamHeaderV0(di, documentInfo);
        } else {
            throw new IOException("unsupported core stream version: " + this.coreVersion);
        }
    }

    private void loadCoreStreamHeaderUnknown(DataInputStream coreStream, ReportDocumentCoreInfo documentInfo) throws IOException {
        documentInfo.checkpoint = 0;
        documentInfo.pageCount = 0L;
        if (!this.archive.exists("/checkpoint")) {
            documentInfo.checkpoint = -1;
            this.initializePageHintReader();
            if (this.pageHintReader != null) {
                documentInfo.pageCount = this.pageHintReader.getTotalPage();
            }
        } else {
            RAInputStream in = this.archive.getStream("/checkpoint");
            try {
                DataInputStream di = new DataInputStream((InputStream)in);
                documentInfo.checkpoint = IOUtil.readInt((InputStream)di);
                documentInfo.pageCount = IOUtil.readLong((DataInputStream)di);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        documentInfo.systemId = IOUtil.readString((DataInputStream)coreStream);
    }

    private void loadCoreStreamHeaderV0(DataInputStream di, ReportDocumentCoreInfo documentInfo) throws IOException {
        documentInfo.checkpoint = 0;
        documentInfo.pageCount = 0L;
        documentInfo.checkpoint = IOUtil.readInt((InputStream)di);
        documentInfo.pageCount = IOUtil.readLong((DataInputStream)di);
        documentInfo.systemId = IOUtil.readString((DataInputStream)di);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCoreStreamLazily() {
        if (!this.coreStreamLoaded) {
            ReportDocumentReader reportDocumentReader = this;
            synchronized (reportDocumentReader) {
                if (!this.coreStreamLoaded) {
                    try {
                        this.loadCoreStream();
                    }
                    catch (IOException ee) {
                        logger.log(Level.SEVERE, "Failed to load core stream", ee);
                    }
                }
            }
        }
    }

    @Override
    public synchronized void refresh() {
        try {
            this.loadCoreStream();
        }
        catch (IOException ee) {
            logger.log(Level.SEVERE, "Failed to refresh", ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCoreStream() throws IOException {
        Object lock = this.archive.lock("/core");
        try {
            Object object = lock;
            synchronized (object) {
                RAInputStream in = this.archive.getStream("/core");
                try {
                    DataInputStream di = new DataInputStream((InputStream)in);
                    this.checkVersion(di);
                    this.loadCoreStream(di);
                    this.coreStreamLoaded = true;
                }
                finally {
                    in.close();
                }
            }
        }
        finally {
            this.archive.unlock(lock);
        }
    }

    private void loadCoreStream(DataInputStream di) throws IOException {
        ReportDocumentCoreInfo documentInfo = new ReportDocumentCoreInfo();
        this.loadCoreStreamHeader(di, documentInfo);
        this.loadCoreStreamBody(di, documentInfo);
        this.checkpoint = documentInfo.checkpoint;
        this.pageCount = documentInfo.pageCount;
        this.globalVariables = documentInfo.globalVariables;
        this.parameters = documentInfo.parameters;
        if (this.checkpoint == -1) {
            if (this.indexReader == null) {
                this.indexReader = documentInfo.indexReader;
            } else if (documentInfo.indexReader != null) {
                documentInfo.indexReader.close();
            }
            if (this.tocReader == null) {
                this.tocReader = documentInfo.tocReader;
            } else if (documentInfo.tocReader != null) {
                documentInfo.tocReader.close();
            }
        }
    }

    private void loadCoreStreamBody(DataInputStream di, ReportDocumentCoreInfo documentInfo) throws IOException {
        if ("CORE_VERSION_UNKNOWN".equals(this.coreVersion)) {
            this.loadCoreStreamBodyUnknown(di, documentInfo);
        } else if ("CORE_VERSION_0".equals(this.coreVersion) || "CORE_VERSION_1".equals(this.coreVersion)) {
            this.loadCoreStreamBodyV0(di, documentInfo);
        } else if ("CORE_VERSION_2".equals(this.coreVersion)) {
            this.loadCoreStreamBodyV2(di, documentInfo);
        } else {
            throw new IOException("unsupported core stream version: " + this.coreVersion);
        }
    }

    protected void loadCoreStreamBodyUnknown(DataInputStream coreStream, ReportDocumentCoreInfo documentInfo) throws IOException {
        ClassLoader loader = this.getClassLoader();
        Map originalParameters = IOUtil.readMap((DataInputStream)coreStream, (ClassLoader)loader);
        documentInfo.parameters = this.convertToCompatibleParameter(originalParameters);
        documentInfo.globalVariables = (HashMap)IOUtil.readMap((DataInputStream)coreStream, (ClassLoader)loader);
        if (documentInfo.checkpoint == -1) {
            documentInfo.indexReader = new DocumentIndexReader(0, this.archive);
        }
    }

    protected void loadCoreStreamBodyV0(DataInputStream coreStream, ReportDocumentCoreInfo documentInfo) throws IOException {
        ClassLoader loader = this.getClassLoader();
        Map originalParameters = IOUtil.readMap((DataInputStream)coreStream, (ClassLoader)loader);
        documentInfo.parameters = this.convertToCompatibleParameter(originalParameters);
        documentInfo.globalVariables = (HashMap)IOUtil.readMap((DataInputStream)coreStream, (ClassLoader)loader);
        if (documentInfo.checkpoint == -1) {
            HashMap<String, Long> bookmarks = this.readMap(coreStream);
            documentInfo.tocReader = new TOCReader(coreStream, this.getClassLoader());
            HashMap<String, Long> reportletsIndexById = this.readMap(coreStream);
            HashMap<String, Long> reportletsIndexByBookmark = this.readMap(coreStream);
            documentInfo.indexReader = new DocumentIndexReader(1, reportletsIndexByBookmark, reportletsIndexById, bookmarks);
        }
    }

    protected void loadCoreStreamBodyV2(DataInputStream coreStream, ReportDocumentCoreInfo documentInfo) throws IOException {
        ClassLoader loader = this.getClassLoader();
        Map originalParameters = IOUtil.readMap((DataInputStream)coreStream, (ClassLoader)loader);
        documentInfo.parameters = this.convertToCompatibleParameter(originalParameters);
        documentInfo.globalVariables = (HashMap)IOUtil.readMap((DataInputStream)coreStream, (ClassLoader)loader);
        if (documentInfo.checkpoint == -1) {
            documentInfo.indexReader = new DocumentIndexReader(2, this.archive);
        }
    }

    private HashMap<String, Long> readMap(DataInputStream di) throws IOException {
        HashMap<String, Long> map = new HashMap<String, Long>();
        long count = IOUtil.readLong((DataInputStream)di);
        long i = 0L;
        while (i < count) {
            String bookmark = IOUtil.readString((DataInputStream)di);
            long pageNumber = IOUtil.readLong((DataInputStream)di);
            map.put(bookmark, new Long(pageNumber));
            ++i;
        }
        return map;
    }

    private HashMap convertToCompatibleParameter(Map parameters) {
        if (parameters == null) {
            return null;
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : parameters.entrySet()) {
            Object[] values;
            Object key = entry.getKey();
            Object valueObj = entry.getValue();
            ParameterAttribute paramAttr = null;
            if (valueObj instanceof ParameterAttribute) {
                paramAttr = (ParameterAttribute)valueObj;
            } else if (valueObj instanceof Object[] && (values = (Object[])valueObj).length == 2) {
                Object value = values[0];
                String displayText = (String)values[1];
                paramAttr = new ParameterAttribute(value, displayText);
            }
            if (paramAttr == null) {
                paramAttr = new ParameterAttribute(valueObj, null);
            }
            result.put(key, paramAttr);
        }
        return result;
    }

    protected void checkVersion(DataInputStream di) throws IOException {
        String tag = IOUtil.readString((DataInputStream)di);
        if (!"reportdocument".equals(tag)) {
            throw new IOException("unknown report document tag" + tag);
        }
        String docVersion = IOUtil.readString((DataInputStream)di);
        if (docVersion == null) {
            throw new IOException("invalid core stream format");
        }
        if (!docVersion.startsWith("CORE_VERSION_")) {
            this.coreVersion = "CORE_VERSION_UNKNOWN";
        } else if ("CORE_VERSION_0".equals(docVersion) || "CORE_VERSION_1".equals(docVersion) || "CORE_VERSION_2".equals(docVersion)) {
            this.coreVersion = docVersion;
            docVersion = IOUtil.readString((DataInputStream)di);
            if ("CORE_VERSION_1".equals(this.coreVersion) || "CORE_VERSION_2".equals(this.coreVersion)) {
                this.properties = IOUtil.readMap((DataInputStream)di);
            }
        } else {
            throw new IOException("unknown core stream version" + tag);
        }
        String[] supportedVersions = new String[]{"1.0.0", "2.1.0", "2.1.3-2.2RC0"};
        boolean supportedVersion = false;
        int i = 0;
        while (i < supportedVersions.length) {
            if (supportedVersions[i].equals(docVersion)) {
                supportedVersion = true;
                break;
            }
            ++i;
        }
        if (!supportedVersion) {
            throw new IOException("unsupport report document version " + docVersion);
        }
        String extensions = (String)this.properties.get("BIRT_ENGINE_EXTENSIONS");
        if (extensions != null && extensions.length() > 0) {
            String[] extIds;
            String[] stringArray = extIds = extensions.split(",");
            int n = extIds.length;
            int n2 = 0;
            while (n2 < n) {
                String extId = stringArray[n2];
                IReportEngineExtension ext = this.engine.getEngineExtension(extId);
                if (ext == null) {
                    throw new IOException("unsupported report extension:" + extId);
                }
                ++n2;
            }
        }
        if (this.properties.get("BIRT ENGINE VERSION") == null) {
            if ("1.0.0".equals(docVersion)) {
                this.properties.put("BIRT ENGINE VERSION", "2.0.0");
            } else if ("2.1.0".equals(docVersion)) {
                this.properties.put("BIRT ENGINE VERSION", "2.1.0");
            } else if ("2.1.3-2.2RC0".equals(docVersion)) {
                this.properties.put("BIRT ENGINE VERSION", "2.1.3");
            }
        }
        String version = this.getVersion();
        if (this.properties.get("extraction") == null) {
            if ("2.0.0".equals(docVersion) || "2.1.0".equals(version)) {
                this.properties.put("extraction", "0");
            } else {
                this.properties.put("extraction", "1");
            }
        }
        if (this.properties.get("page hint version") == null) {
            this.properties.put("page hint version", "2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.tocReader != null) {
            try {
                this.tocReader.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Failed to close the tocReader", ex);
            }
            this.tocReader = null;
        }
        if (this.indexReader != null) {
            try {
                this.indexReader.close();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "failed to close the index reader", ex);
            }
            this.indexReader = null;
        }
        if (this.pageHintReader != null) {
            this.pageHintReader.close();
            this.pageHintReader = null;
        }
        if (this.archive != null) {
            if (!this.sharedArchive) {
                try {
                    this.archive.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Failed to close the archive", ex);
                }
            }
            this.archive = null;
        }
        if (this.extensions != null) {
            for (Map.Entry<String, IReportDocumentExtension> entry : this.extensions.entrySet()) {
                String name = entry.getKey();
                IReportDocumentExtension extension = entry.getValue();
                if (extension == null) continue;
                try {
                    extension.close();
                }
                catch (EngineException ex) {
                    logger.log(Level.SEVERE, "Failed to close the extension " + name, (Throwable)((Object)ex));
                }
            }
            this.extensions.clear();
            this.extensions = null;
        }
        if (this.applicationClassLoader != null) {
            this.applicationClassLoader.close();
        }
        if (this.engineCacheEntry != null) {
            LinkedObjectManager<ReportDocumentReader> manager = this.engineCacheEntry.getManager();
            LinkedObjectManager<ReportDocumentReader> linkedObjectManager = manager;
            synchronized (linkedObjectManager) {
                manager.remove(this.engineCacheEntry);
            }
        }
    }

    public InputStream getOriginalDesignStream() {
        try {
            return this.archive.getStream("/original_design");
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to open the design!", ex);
            return null;
        }
    }

    public InputStream getDesignStream(boolean isOriginal) {
        try {
            if (isOriginal && this.archive.exists("/original_design")) {
                return this.archive.getStream("/original_design");
            }
            return this.archive.getStream("/design");
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to open the design!", ex);
            return null;
        }
    }

    private ReportRunnable getReportRunnable(boolean isOriginal, String systemId) {
        ReportRunnable reportRunnable;
        block17: {
            if (!isOriginal && this.preparedRunnable != null) {
                return this.preparedRunnable;
            }
            reportRunnable = null;
            String name = null;
            name = systemId == null ? this.archive.getName() : systemId;
            InputStream stream = this.getDesignStream(isOriginal);
            if (stream != null) {
                try {
                    try {
                        reportRunnable = (ReportRunnable)this.engine.openReportDesign(name, stream, this.moduleOptions);
                        reportRunnable.setPrepared(!isOriginal);
                        stream.close();
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "Failed to get the report runnable", ex);
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block17;
                        }
                        catch (IOException iOException) {}
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (!isOriginal && this.preparedRunnable == null) {
            this.preparedRunnable = reportRunnable;
        }
        return reportRunnable;
    }

    @Override
    public synchronized IReportRunnable getReportRunnable() {
        if (this.reportRunnable == null) {
            this.reportRunnable = this.getReportRunnable(true, this.systemId);
        }
        return this.reportRunnable.cloneRunnable();
    }

    @Override
    public synchronized IReportRunnable getPreparedRunnable() {
        if (this.preparedRunnable == null) {
            this.preparedRunnable = this.getReportRunnable(false, this.systemId);
        }
        return this.preparedRunnable.cloneRunnable();
    }

    @Override
    public Map getParameterValues() {
        this.loadCoreStreamLazily();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.parameters != null) {
            for (Map.Entry entry : this.parameters.entrySet()) {
                String name = (String)entry.getKey();
                ParameterAttribute value = (ParameterAttribute)entry.getValue();
                result.put(name, value.getValue());
            }
        }
        return result;
    }

    @Override
    public Map getParameterDisplayTexts() {
        this.loadCoreStreamLazily();
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.parameters != null) {
            for (Map.Entry entry : this.parameters.entrySet()) {
                String name = (String)entry.getKey();
                ParameterAttribute value = (ParameterAttribute)entry.getValue();
                result.put(name, value.getDisplayText());
            }
        }
        return result;
    }

    @Override
    public long getPageCount() {
        return this.pageCount;
    }

    public IPageHint getPageHint(long pageNumber) {
        this.initializePageHintReader();
        if (this.pageHintReader != null) {
            try {
                return this.pageHintReader.getPageHint(pageNumber);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Failed to load page hint " + pageNumber, ex);
            }
        }
        return null;
    }

    @Override
    public long getPageNumber(String bookmark) {
        if (!this.isComplete()) {
            return -1L;
        }
        this.loadCoreStreamLazily();
        if (this.indexReader != null) {
            try {
                return this.indexReader.getPageOfBookmark(bookmark);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "failed to load the page number of bookmark:" + bookmark, ex);
            }
        }
        return -1L;
    }

    @Override
    public List<String> getBookmarks() {
        if (!this.isComplete()) {
            return null;
        }
        this.loadCoreStreamLazily();
        if (this.indexReader != null) {
            try {
                return this.indexReader.getBookmarks();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "failed to load the bookmark list", ex);
            }
        }
        return null;
    }

    public List<BookmarkContent> getBookmarkContents() {
        if (!this.isComplete()) {
            return null;
        }
        this.loadCoreStreamLazily();
        if (this.indexReader != null) {
            try {
                return this.indexReader.getBookmarkContents();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "failed to load the bookmark info list", ex);
            }
        }
        return null;
    }

    @Override
    public List<IBookmarkInfo> getBookmarkInfos(Locale locale) throws EngineException {
        ArrayList<IBookmarkInfo> results = new ArrayList<IBookmarkInfo>();
        if (this.indexReader != null) {
            List<BookmarkContent> bookmarks;
            block7: {
                bookmarks = this.indexReader.getBookmarkContents();
                if (bookmarks != null) break block7;
                return null;
            }
            try {
                ReportDesignHandle report = this.getReportDesign();
                for (BookmarkContent bookmark : bookmarks) {
                    long designId = bookmark.getElementId();
                    DesignElementHandle handle = report.getElementByID(designId);
                    if (handle == null) continue;
                    String elementType = handle.getName();
                    String displayName = null;
                    if (handle instanceof ReportItemHandle) {
                        displayName = ((ReportItemHandle)handle).getBookmarkDisplayName();
                    }
                    if (locale != null && handle instanceof ReportElementHandle) {
                        ReportElementHandle elementHandle = (ReportElementHandle)handle;
                        displayName = ModuleUtil.getExternalizedValue((DesignElementHandle)elementHandle, (String)bookmark.getBookmark(), (String)displayName, (ULocale)ULocale.forLocale((Locale)locale));
                    }
                    results.add(new BookmarkInfo(bookmark.getBookmark(), displayName, elementType));
                }
            }
            catch (IOException ex) {
                throw new EngineException("exception when fetching bookmarks", ex);
            }
        }
        return results;
    }

    public long getBookmark(String bookmark) {
        if (!this.isComplete()) {
            return -1L;
        }
        this.loadCoreStreamLazily();
        if (this.indexReader != null) {
            try {
                return this.indexReader.getOffsetOfBookmark(bookmark);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "failed to load the offset of bookmark:" + bookmark, ex);
            }
        }
        return -1L;
    }

    @Override
    public ITOCTree getTOCTree(String format, ULocale locale) {
        return this.getTOCTree(format, locale, TimeZone.getDefault());
    }

    @Override
    public ITOCTree getTOCTree(String format, ULocale locale, TimeZone timeZone) {
        try {
            ITreeNode root = this.getTOCTree();
            if (root != null) {
                ReportDesignHandle report = ((ReportRunnable)this.getOnPreparedRunnable()).getReport();
                return new TOCView(root, report, locale, timeZone, format);
            }
        }
        catch (EngineException ex) {
            logger.log(Level.WARNING, ex.getMessage(), (Throwable)((Object)ex));
        }
        return null;
    }

    @Override
    public TOCNode findTOC(String tocNodeId) {
        ITOCTree tree = this.getTOCTree("viewer", ULocale.getDefault());
        if (tree != null) {
            return tree.findTOC(tocNodeId);
        }
        return null;
    }

    @Override
    public List findTOCByName(String tocName) {
        ITOCTree tree = this.getTOCTree("viewer", ULocale.getDefault());
        if (tree != null) {
            return tree.findTOCByValue(tocName);
        }
        return null;
    }

    @Override
    public List getChildren(String tocNodeId) {
        TOCNode node = this.findTOC(tocNodeId);
        if (node != null) {
            return node.getChildren();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePageHintReader() {
        if (this.pageHintReader != null) {
            return;
        }
        ReportDocumentReader reportDocumentReader = this;
        synchronized (reportDocumentReader) {
            if (this.pageHintReader != null) {
                return;
            }
            try {
                this.pageHintReader = new PageHintReader(this);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "can't open the page hint stream", ex);
            }
        }
    }

    @Override
    public String getName() {
        return this.archive.getName();
    }

    @Override
    public Map getGlobalVariables(String option) {
        this.loadCoreStreamLazily();
        return this.globalVariables;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getPageNumber(InstanceID iid) {
        if (!this.isComplete()) {
            return -1L;
        }
        this.initializePageHintReader();
        if (this.pageHintReader == null) {
            return -1L;
        }
        int version = this.pageHintReader.getVersion();
        try {
            if (version == 0) {
                long offset = this.getInstanceOffset(iid);
                if (offset == -1L) {
                    return -1L;
                }
                long totalPage = this.pageHintReader.getTotalPage();
                long pageNumber = 1L;
                while (pageNumber <= totalPage) {
                    IPageHint hint = this.pageHintReader.getPageHint(pageNumber);
                    PageSection section = hint.getSection(0);
                    if (offset >= section.startOffset) {
                        return pageNumber;
                    }
                    ++pageNumber;
                }
            } else if (version == 1) {
                long offset = this.getInstanceOffset(iid);
                if (offset == -1L) {
                    return -1L;
                }
                long totalPage = this.pageHintReader.getTotalPage();
                long pageNumber = 1L;
                while (pageNumber <= totalPage) {
                    IPageHint hint = this.pageHintReader.getPageHint(pageNumber);
                    int sectionCount = hint.getSectionCount();
                    int i = 0;
                    while (i < sectionCount) {
                        PageSection section = hint.getSection(i);
                        if (section.startOffset <= offset && offset <= section.endOffset) {
                            return pageNumber;
                        }
                        ++i;
                    }
                    ++pageNumber;
                }
            } else if (version == 2 || version == 3 || version == 4 || version == 5 || version == 6) {
                long totalPage = this.pageHintReader.getTotalPage();
                long pageNumber = 1L;
                while (pageNumber <= totalPage) {
                    IPageHint hint = this.pageHintReader.getPageHint(pageNumber);
                    int sectionCount = hint.getSectionCount();
                    Fragment fragment = new Fragment(new InstanceIDComparator());
                    int i = 0;
                    while (i < sectionCount) {
                        PageSection section = hint.getSection(i);
                        fragment.addSection(section.starts, section.ends);
                        ++i;
                    }
                    fragment.build();
                    if (fragment.inFragment(iid)) {
                        return pageNumber;
                    }
                    ++pageNumber;
                }
            }
        }
        catch (IOException iOException) {}
        return -1L;
    }

    @Override
    public long getInstanceOffset(InstanceID iid) {
        if (!this.isComplete()) {
            return -1L;
        }
        if (iid == null) {
            return -1L;
        }
        this.loadCoreStreamLazily();
        if (this.indexReader != null) {
            try {
                long offset = this.indexReader.getOffsetOfInstance(iid.toUniqueString());
                if (offset == -1L) {
                    offset = this.indexReader.getOffsetOfInstance(iid.toString());
                }
                return offset;
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "failed to get the offset of instance:" + iid.toUniqueString(), ex);
            }
        }
        return -1L;
    }

    @Override
    public long getBookmarkOffset(String bookmark) {
        if (!this.isComplete()) {
            return -1L;
        }
        if (bookmark == null) {
            return -1L;
        }
        this.loadCoreStreamLazily();
        if (this.indexReader != null) {
            try {
                return this.indexReader.getOffsetOfBookmark(bookmark);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "failed to get the offset of bookmark:" + bookmark, ex);
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassLoader getClassLoader() {
        if (this.applicationClassLoader != null) {
            return this.applicationClassLoader;
        }
        ReportDocumentReader reportDocumentReader = this;
        synchronized (reportDocumentReader) {
            if (this.applicationClassLoader == null) {
                this.applicationClassLoader = AccessController.doPrivileged(new PrivilegedAction<ApplicationClassLoader>(){

                    @Override
                    public ApplicationClassLoader run() {
                        return new ApplicationClassLoader(ReportDocumentReader.this.engine, ReportDocumentReader.this.getOnPreparedRunnable(), ReportDocumentReader.this.engine.getConfig().getAppContext());
                    }
                });
            }
        }
        return this.applicationClassLoader;
    }

    @Override
    public boolean isComplete() {
        return this.checkpoint == -1;
    }

    @Override
    public ReportDesignHandle getReportDesign() {
        IReportRunnable reportRunnable = this.getReportRunnable();
        if (reportRunnable != null) {
            return (ReportDesignHandle)reportRunnable.getDesignHandle();
        }
        return null;
    }

    @Override
    public Report getReportIR(ReportDesignHandle designHandle) {
        try {
            RAInputStream stream = this.archive.getStream("/design.ir");
            EngineIRReader reader = new EngineIRReader();
            Report reportIR = reader.read((InputStream)stream);
            reportIR.setVersion(this.getVersion());
            reader.link(reportIR, designHandle);
            return reportIR;
        }
        catch (IOException ioex) {
            logger.log(Level.FINE, "Failed to load the engine IR", ioex);
            return null;
        }
    }

    @Override
    public IReportRunnable getOnPreparedRunnable() {
        return this.getReportRunnable(false, this.systemId);
    }

    @Override
    public InputStream getDesignStream() {
        return this.getDesignStream(true);
    }

    private InstanceID loadInstanceID(ReportContentReaderV3 reader, long offset) throws IOException {
        IContent content = reader.readContent(offset);
        if (content != null) {
            InstanceID pid;
            InstanceID iid = content.getInstanceID();
            DocumentExtension ext = (DocumentExtension)content.getExtension(0);
            long parentOffset = ext.getParent();
            if (parentOffset != -1L && (pid = this.loadInstanceID(reader, parentOffset)) != null) {
                return new InstanceID(pid, iid);
            }
            return iid;
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public InstanceID getBookmarkInstance(String bookmark) {
        if (bookmark == null || bookmark.length() == 0) {
            return null;
        }
        long offset = this.getBookmarkOffset(bookmark);
        if (offset < 0L) {
            return null;
        }
        try {
            RAInputStream is = this.archive.getStream("/content/content.dat");
            try {
                ReportContentReaderV3 reader = new ReportContentReaderV3(new ReportContent(), is, this.applicationClassLoader);
                try {
                    InstanceID instanceID = this.loadInstanceID(reader, offset);
                    reader.close();
                    return instanceID;
                }
                catch (Throwable throwable) {
                    reader.close();
                    throw throwable;
                }
            }
            finally {
                is.close();
            }
        }
        catch (IOException ioe) {
            logger.log(Level.FINE, "Failed to get the instance ID of the bookmark: " + bookmark, ioe);
            return null;
        }
    }

    @Override
    public boolean isReporltetDocument() throws IOException {
        return this.loadReportletStream();
    }

    @Override
    public String getReportletBookmark() throws IOException {
        if (this.loadReportletStream()) {
            return this.reportletBookmark;
        }
        return null;
    }

    @Override
    public InstanceID getReportletInstanceID() throws IOException {
        if (this.loadReportletStream()) {
            return InstanceID.parse(this.reportletInstanceID);
        }
        return null;
    }

    private boolean loadReportletStream() throws IOException {
        if (this.isReportlet == null) {
            if (this.archive.exists("/reportletDocument")) {
                RAInputStream in = this.archive.getInputStream("/reportletDocument");
                try {
                    int version = in.readInt();
                    if (version != 0) {
                        throw new IOException("unsupported reportlet document " + version);
                    }
                    int size = in.readInt();
                    byte[] bytes = new byte[size];
                    in.readFully(bytes, 0, size);
                    DataInputStream s = new DataInputStream(new ByteArrayInputStream(bytes));
                    this.reportletBookmark = IOUtil.readString((DataInputStream)s);
                    this.reportletInstanceID = IOUtil.readString((DataInputStream)s);
                    this.isReportlet = Boolean.TRUE;
                }
                finally {
                    in.close();
                }
            } else {
                this.isReportlet = Boolean.FALSE;
            }
        }
        return this.isReportlet;
    }

    @Override
    public synchronized IReportDocumentExtension getDocumentExtension(String name) throws EngineException {
        IReportEngineExtension engineExtension;
        IReportDocumentExtension extension = this.extensions.get(name);
        if (extension == null && (engineExtension = this.engine.getEngineExtension(name)) != null) {
            extension = engineExtension.createDocumentExtension(this);
            this.extensions.put(name, extension);
        }
        return extension;
    }

    @Override
    public synchronized ITreeNode getTOCTree() throws EngineException {
        if (!this.isComplete()) {
            return null;
        }
        this.loadCoreStreamLazily();
        try {
            if (this.tocReader == null) {
                this.tocReader = new TOCReader(this.archive, this.getClassLoader());
            }
            return this.tocReader.readTree();
        }
        catch (IOException ex) {
            throw new EngineException("failed to load toc tree", ex);
        }
    }

    public void setEngineCacheEntry(LinkedObjectManager.LinkedEntry<ReportDocumentReader> entry) {
        this.engineCacheEntry = entry;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    protected class ReportDocumentCoreInfo {
        int checkpoint;
        long pageCount;
        String systemId;
        HashMap globalVariables;
        HashMap parameters;
        ITOCReader tocReader;
        IDocumentIndexReader indexReader;

        protected ReportDocumentCoreInfo() {
        }
    }
}

