/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.dom;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.AbstractStyle;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.w3c.dom.css.CSSValue;

public class ComputedStyle
extends AbstractStyle {
    Map<String, ComputedStyle> cachedStyles = new HashMap<String, ComputedStyle>();
    boolean[] caculated;
    CSSStylableElement elt;
    CSSValue[] values;

    public ComputedStyle(CSSStylableElement elt) {
        super(elt.getCSSEngine());
        this.elt = elt;
    }

    public CSSValue getProperty(int index) {
        if (this.values == null) {
            this.values = new CSSValue[59];
            this.caculated = new boolean[59];
        }
        if (this.caculated[index]) {
            return this.values[index];
        }
        Value cv = this.resolveProperty(index);
        this.values[index] = cv;
        this.caculated[index] = true;
        return cv;
    }

    protected Value resolveProperty(int index) {
        IStyle s;
        CSSStylableElement parent = (CSSStylableElement)this.elt.getParent();
        IStyle pcs = null;
        if (parent != null) {
            pcs = parent.getComputedStyle();
        }
        Value sv = (s = this.elt.getStyle()) != null ? (Value)s.getProperty(index) : null;
        Value cv = this.engine.resolveStyle(this.elt, index, sv, pcs);
        return cv;
    }

    public boolean isEmpty() {
        return false;
    }

    public void setProperty(int index, CSSValue value) {
        this.caculated[index] = false;
        this.values[index] = null;
        this.elt.getStyle().setProperty(index, value);
    }

    public void addCachedStyle(String styleClass, ComputedStyle style) {
        this.cachedStyles.put(styleClass, style);
    }

    public ComputedStyle getCachedStyle(String styleClass) {
        return this.cachedStyles.get(styleClass);
    }
}

