/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import java.util.logging.Level;
import java.util.logging.Logger;

public class XMLEncodeUtil {
    protected static Logger logger = Logger.getLogger(XMLEncodeUtil.class.getName());
    protected static final char[] XML_TEXT_ENCODE = new char[]{'&', '<'};
    protected static final char[] XML_ATTR_ENCODE = new char[]{'&', '<', '>', '\"', '\r', '\n', '\t'};
    protected static final String MESSAGE_MISSING_LOW_SURROGATE = "Missing low surrogate for: 0x{0}";
    protected static final String MESSAGE_UNMATCH_SURROGATE = "Unmatch surrogate parie: 0x{0}, 0x{1}";
    protected static final String MESSAGE_INVALID_CHARACTER = "Invalid XML character:0x{0}";
    protected static final String MESSAGE_INVALID_SURROGATE = "Invalid XML surrogate pair:0x{0}, 0x{1}";

    protected static boolean isValidCodePoint(int ch) {
        return ch == 9 || ch == 10 || ch == 13 || ch >= 32 && ch <= 55295 || ch >= 57344 && ch <= 65533 || ch >= 65536 && ch <= 0x10FFFF;
    }

    protected static int testEscape(char[] chars, char[] encodings) {
        int index = 0;
        int length = chars.length;
        while (index < length) {
            char c1;
            if (Character.isHighSurrogate(c1 = chars[index++])) {
                if (index < length) {
                    int cp;
                    char c2;
                    if (Character.isLowSurrogate(c2 = chars[index++]) && XMLEncodeUtil.isValidCodePoint(cp = Character.toCodePoint(c1, c2))) continue;
                    return index - 2;
                }
                return index - 1;
            }
            if (XMLEncodeUtil.isValidCodePoint(c1)) {
                if (encodings == null) continue;
                char[] cArray = encodings;
                int n = encodings.length;
                int n2 = 0;
                while (n2 < n) {
                    char ch = cArray[n2];
                    if (c1 == ch) {
                        return index - 1;
                    }
                    ++n2;
                }
                continue;
            }
            return index - 1;
        }
        return length;
    }

    public static String encodeText(String s) {
        char[] chars = s.toCharArray();
        int length = chars.length;
        int index = XMLEncodeUtil.testEscape(chars, XML_TEXT_ENCODE);
        if (index >= length) {
            return s;
        }
        StringBuilder sb = new StringBuilder(2 * length);
        sb.append(chars, 0, index);
        while (index < length) {
            char c;
            if (Character.isHighSurrogate(c = chars[index++])) {
                index += XMLEncodeUtil.decodeSurrogate(c, chars, index, sb);
                continue;
            }
            if (XMLEncodeUtil.isValidCodePoint(c)) {
                if (c == '&') {
                    sb.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    sb.append("&lt;");
                    continue;
                }
                sb.append(c);
                continue;
            }
            logger.log(Level.WARNING, MESSAGE_INVALID_CHARACTER, c);
        }
        return sb.toString();
    }

    public static String encodeAttr(String s) {
        char[] chars = s.toCharArray();
        int length = chars.length;
        int index = XMLEncodeUtil.testEscape(chars, XML_ATTR_ENCODE);
        if (index >= length) {
            return s;
        }
        StringBuilder sb = new StringBuilder(2 * length);
        sb.append(chars, 0, index);
        while (index < length) {
            char c;
            if (Character.isHighSurrogate(c = chars[index++])) {
                index += XMLEncodeUtil.decodeSurrogate(c, chars, index, sb);
                continue;
            }
            if (XMLEncodeUtil.isValidCodePoint(c)) {
                if (c == '&') {
                    sb.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    sb.append("&lt;");
                    continue;
                }
                if (c == '\"') {
                    sb.append("&#34;");
                    continue;
                }
                if (c == '\r') {
                    sb.append("&#13;");
                    continue;
                }
                if (c == '\n') {
                    sb.append("&#10;");
                    continue;
                }
                if (c == '\t') {
                    sb.append("&#9;");
                    continue;
                }
                sb.append(c);
                continue;
            }
            logger.log(Level.WARNING, MESSAGE_INVALID_CHARACTER, c);
        }
        return sb.toString();
    }

    public static String encodeCdata(String s) {
        char[] chars = s.toCharArray();
        int length = chars.length;
        int index = XMLEncodeUtil.testEscape(chars, null);
        if (index >= length) {
            return s;
        }
        StringBuilder sb = new StringBuilder(2 * length);
        sb.append(chars, 0, index);
        while (index < length) {
            char c;
            if (Character.isHighSurrogate(c = chars[index++])) {
                index += XMLEncodeUtil.decodeSurrogate(c, chars, index, sb);
                continue;
            }
            if (XMLEncodeUtil.isValidCodePoint(c)) {
                sb.append(c);
                continue;
            }
            logger.log(Level.WARNING, MESSAGE_INVALID_CHARACTER, c);
        }
        return sb.toString();
    }

    protected static int decodeSurrogate(char c, char[] chars, int offset, StringBuilder sb) {
        if (Character.isHighSurrogate(c)) {
            if (offset < chars.length) {
                char nc = chars[offset];
                if (Character.isLowSurrogate(nc)) {
                    int cp = Character.toCodePoint(c, nc);
                    if (XMLEncodeUtil.isValidCodePoint(cp)) {
                        sb.append(c);
                        sb.append(nc);
                        return 1;
                    }
                    logger.log(Level.INFO, MESSAGE_INVALID_SURROGATE, new Object[]{new Integer(c), new Integer(nc)});
                }
                logger.log(Level.INFO, MESSAGE_UNMATCH_SURROGATE, new Object[]{new Integer(c), new Integer(nc)});
            }
            logger.log(Level.INFO, MESSAGE_MISSING_LOW_SURROGATE, new Object[]{new Integer(c)});
        }
        logger.log(Level.INFO, MESSAGE_INVALID_CHARACTER, c);
        return 0;
    }
}

