/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.content.ItemExecutorWrapper;
import org.eclipse.birt.report.engine.layout.content.LineStackingExecutor;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockContainerLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLineAreaLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFTextBlockContainerLM
extends PDFBlockContainerLM
implements IBlockStackingLayoutManager {
    protected int widows = 0;
    protected int orphans = 0;
    protected int current = 0;
    protected int size = 0;
    protected ArrayList lines = new ArrayList();
    protected boolean finished = false;

    public PDFTextBlockContainerLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        this.child = new PDFLineAreaLM(context, this, new LineStackingExecutor(new ItemExecutorWrapper(executor, content), executor));
        this.widows = this.getWidows();
        this.orphans = this.getOrphans();
    }

    protected boolean traverseChildren() throws BirtException {
        if (!this.finished) {
            if (!this.traverseSingleChild()) {
                this.finished = true;
            } else {
                return true;
            }
        }
        if (!this.layoutLines()) {
            this.clearCache();
            return false;
        }
        return true;
    }

    protected boolean layoutLines() {
        Iterator iter = this.lines.iterator();
        while (iter.hasNext()) {
            boolean keepWithNext = false;
            IArea area = (IArea)iter.next();
            if (this.current < this.orphans - 1 || this.current > this.size - this.widows - 1) {
                keepWithNext = true;
            }
            if (!super.addArea(area, false, keepWithNext)) {
                return true;
            }
            iter.remove();
            ++this.current;
        }
        return false;
    }

    protected void closeExecutor() {
    }

    public boolean addArea(IArea area, boolean keepWithPrevious, boolean keepWithNext) {
        this.lines.add(area);
        ++this.size;
        return true;
    }

    protected int getWidows() {
        IStyle style = this.content.getStyle();
        String widows = style.getWidows();
        if (widows != null) {
            try {
                return Integer.parseInt(widows);
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.WARNING, "invalid widows: {0}", widows);
            }
        }
        return 0;
    }

    protected int getOrphans() {
        IStyle style = this.content.getStyle();
        String orphans = style.getOrphans();
        if (orphans != null) {
            try {
                return Integer.parseInt(orphans);
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.WARNING, "invalid orphans: {0}", orphans);
            }
        }
        return 0;
    }

    protected class WOManager {
        protected int widows;
        protected int orphans;
        protected boolean isFirst;
        protected int maxHeight;
        protected PDFBlockStackingLM.CompositeArea lines = new PDFBlockStackingLM.CompositeArea();

        public WOManager(int widows, int orphans, int maxHeight) {
            this.widows = widows;
            this.orphans = orphans;
            this.maxHeight = maxHeight;
        }

        public void add(IArea area) {
            this.lines.add(area);
        }

        public boolean isEmpty() {
            return this.lines.isEmpty();
        }

        protected void makeWOAvailable() {
        }

        protected PDFBlockStackingLM.CompositeArea getAreas(int minCount, int maxCount, int minHeight, int maxHeight) {
            return null;
        }

        public PDFBlockStackingLM.CompositeArea getAreas(int heightHint) {
            int size = this.lines.size();
            if (this.isFirst) {
                this.isFirst = false;
                if (size <= this.widows + this.orphans) {
                    return this.getAreas(size, size, heightHint, this.maxHeight);
                }
                return this.getAreas(this.widows, size - this.orphans, heightHint, this.maxHeight);
            }
            if (size <= this.orphans) {
                return this.getAreas(this.orphans, this.orphans, heightHint, this.maxHeight);
            }
            return this.getAreas(1, size - this.orphans, heightHint, this.maxHeight);
        }
    }
}

