/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.util.HashMap;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEmitterAdapter;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.ILayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.CellArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ImageAreaLayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.LineArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ListArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ListGroupArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.RootArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.RowArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableGroupArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TemplateAreaLayout;

public class AreaFactory {
    protected int nestCount = 0;
    protected LayoutEmitterAdapter emitter;
    protected HashMap<Object, AbstractArea> areaCache = new HashMap();

    public AreaFactory(LayoutEmitterAdapter emitter) {
        this.emitter = emitter;
    }

    public LineArea createLineArea(ContainerArea parent, LayoutContext context) {
        LineArea line = new LineArea(parent, context);
        return line;
    }

    public ILayout createLayout(ContainerArea parent, LayoutContext context, IContent content) {
        switch (content.getContentType()) {
            case 3: 
            case 6: 
            case 11: {
                if (PropertyUtil.isInlineElement(content)) {
                    DimensionType width = content.getWidth();
                    if (width != null) {
                        return new BlockTextArea(parent, context, content);
                    }
                    return new InlineTextArea(parent, context, content);
                }
                return new BlockTextArea(parent, context, content);
            }
            case 5: {
                return new ImageAreaLayout(parent, context, (IImageContent)content);
            }
            case 12: {
                int type = ((IAutoTextContent)content).getType();
                if (type == 0 || type == 2) {
                    context.addUnresolvedContent(content);
                    return new TemplateAreaLayout(parent, context, content);
                }
                if (PropertyUtil.isInlineElement(content)) {
                    return new InlineTextArea(parent, context, content);
                }
                return new BlockTextArea(parent, context, content);
            }
        }
        return null;
    }

    public AbstractArea createArea(ContainerArea parent, LayoutContext context, IContent content) {
        Object design;
        IStyle inlineStyle;
        AbstractArea area = null;
        if (this.nestCount > 0 && ((inlineStyle = content.getInlineStyle()) == null || inlineStyle.isEmpty()) && (design = content.getGenerateBy()) != null) {
            AbstractArea cache = this.areaCache.get(design);
            if (cache != null) {
                area = cache.cloneArea();
            } else {
                area = this.createNewArea(parent, context, content);
                this.areaCache.put(design, area);
            }
        }
        if (area == null) {
            area = this.createNewArea(parent, context, content);
        }
        return area;
    }

    public void startListing() {
        ++this.nestCount;
    }

    public void endListing() {
        --this.nestCount;
    }

    protected AbstractArea createNewArea(ContainerArea parent, LayoutContext context, IContent content) {
        switch (content.getContentType()) {
            case 1: {
                return new CellArea(parent, context, content);
            }
            case 2: {
                if (PropertyUtil.isInlineElement(content)) {
                    return new InlineContainerArea(parent, context, content);
                }
                return new BlockContainerArea(parent, context, content);
            }
            case 13: {
                if (PropertyUtil.isInlineElement(content)) {
                    return new ListArea(parent, context, content);
                }
                return new ListArea(parent, context, content);
            }
            case 3: 
            case 6: 
            case 11: {
                break;
            }
            case 4: {
                ContainerArea area = PropertyUtil.isInlineElement(content) ? new InlineContainerArea(parent, context, content) : new BlockContainerArea(parent, context, content);
                if (context.isFixedLayout()) {
                    area.setPageBreakInside(IStyle.AVOID_VALUE);
                }
                return area;
            }
            case 5: {
                break;
            }
            case 7: {
                return new RootArea(context, content, this.emitter);
            }
            case 8: {
                return new RowArea(parent, context, content);
            }
            case 9: {
                break;
            }
            case 10: {
                return new TableArea(parent, context, content);
            }
            case 12: {
                break;
            }
            case 14: {
                break;
            }
            case 16: {
                return new ListGroupArea(parent, context, content);
            }
            case 17: {
                return new TableGroupArea(parent, context, content);
            }
        }
        return null;
    }

    protected CellArea createCellArea(ICellContent cellContent, ContainerArea parent) {
        return new CellArea();
    }

    public static IImageArea createImageArea(IImageContent image, ContainerArea parent) {
        return null;
    }

    public static IArea createTableGroupArea(IContent group, ContainerArea parent) {
        return null;
    }

    public static IArea createTemplateArea(IAutoTextContent autoText, ContainerArea parent) {
        return null;
    }
}

