/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.util.ArrayList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.ILayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockTextRenderListener;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.SizeBasedContent;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextAreaLayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextLineArea;

public class BlockTextArea
extends BlockContainerArea
implements ILayout {
    private BlockTextRenderListener listener = null;

    public BlockTextArea(ContainerArea parent, LayoutContext context, IContent content) {
        super(parent, context, content);
        SizeBasedContent hint;
        InstanceID id;
        if (context.isInHtmlRender() && (id = content.getInstanceID()) != null && (hint = context.getHtmlLayoutContext().getPageHintManager().getSizeBasedContentMapping().get(id.toUniqueString())) != null) {
            parent.width = hint.width;
            this.listener = new BlockTextRenderListener(this, hint.offsetInContent, hint.dimension);
        }
    }

    public BlockTextArea(BlockTextArea area) {
        super(area);
    }

    public void layout() throws BirtException {
        this.initialize();
        TextLineArea line = new TextLineArea(this, this.context);
        line.initialize();
        line.setTextIndent((ITextContent)this.content);
        TextAreaLayout text = new TextAreaLayout(line, this.context, this.content);
        text.initialize();
        if (this.context.isInHtmlRender()) {
            text.addListener(this.listener);
        }
        text.layout();
        text.close();
        line.close();
        this.close();
    }

    protected BlockTextArea getSplitArea(ArrayList ablatedChildren, int newHeight) {
        BlockTextArea newArea = (BlockTextArea)super.getSplitArea(ablatedChildren, newHeight);
        this.addToExtension(newArea);
        return newArea;
    }

    public BlockTextArea cloneArea() {
        BlockTextArea newArea = new BlockTextArea(this);
        return newArea;
    }

    public void close() throws BirtException {
        super.close();
        this.addToExtension(this);
        this.updateTextContent();
    }

    private void addToExtension(BlockTextArea area) {
        if (this.context.isFixedLayout() && this.context.getEngineTaskType() == 1) {
            ArrayList<BlockTextArea> list = (ArrayList<BlockTextArea>)this.content.getExtension(1);
            if (list == null) {
                list = new ArrayList<BlockTextArea>();
                this.content.setExtension(1, list);
            }
            if (area.finished) {
                if (list.isEmpty() || list.size() > 0 && !((BlockTextArea)list.get((int)(list.size() - 1))).finished) {
                    list.add(area);
                }
            } else if (list.size() > 0 && ((BlockTextArea)list.get((int)(list.size() - 1))).finished) {
                list.add(list.size() - 1, area);
            } else {
                list.add(area);
            }
        }
    }

    private void updateTextContent() {
        if (this.context.isInHtmlRender()) {
            ((ITextContent)this.content).setText(this.listener.getSplitText());
        }
    }

    protected void update() throws BirtException {
        if (this.parent != null) {
            if (this.context.isFixedLayout() && this.getContentHeight() > this.specifiedHeight && this.specifiedHeight > 0) {
                this.setContentHeight(this.specifiedHeight);
                this.setNeedClip(true);
            }
            if (!this.isInInlineStacking && this.context.isAutoPageBreak()) {
                int aHeight = this.getAllocatedHeight();
                int size = this.children.size();
                if (aHeight + this.parent.getAbsoluteBP() > this.context.getMaxBP() && size > 1) {
                    IStyle style = this.content.getComputedStyle();
                    int widow = Math.min(size, PropertyUtil.getIntValue(style.getProperty(30)));
                    int orphan = Math.min(size, PropertyUtil.getIntValue(style.getProperty(43)));
                    int i = 0;
                    while (i < size) {
                        TextLineArea line = (TextLineArea)this.children.get(i);
                        if (i > 0 && i < orphan) {
                            line.setPageBreakBefore(IStyle.AVOID_VALUE);
                        } else if (i > size - widow) {
                            line.setPageBreakBefore(IStyle.AVOID_VALUE);
                        }
                        ++i;
                    }
                }
                while (aHeight + this.parent.getAbsoluteBP() >= this.context.getMaxBP()) {
                    this.parent.autoPageBreak();
                    aHeight = this.getAllocatedHeight();
                }
            }
            this.parent.update(this);
        }
    }
}

