/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.internal.content.wrap.AbstractContentWrapper;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineTextExtension;
import org.eclipse.birt.report.engine.nLayout.area.impl.PageArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.SizeBasedContent;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableArea;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedLayoutPageHintGenerator {
    protected SizeBasedContent startContent = null;
    protected SizeBasedContent currentContent = null;
    protected HTMLLayoutContext htmlLayoutContext = null;
    private ArrayList<SizeBasedContent[]> fixedLayoutPageHints = new ArrayList();
    protected HashSet<String> tableIds = new HashSet();
    HashMap<String, UnresolvedRowHint> htmlUnresolvedRowHints = null;
    HashMap<String, UnresolvedRowHint> currentPageUnresolvedRowHints = null;
    HashMap<String, UnresolvedRowHint> docUnresolvedRowHints = new HashMap();
    protected LayoutContext context;

    public FixedLayoutPageHintGenerator(LayoutContext context) {
        this.context = context;
        this.htmlLayoutContext = context.getHtmlLayoutContext();
    }

    public ArrayList getPageHint() {
        return this.fixedLayoutPageHints;
    }

    public void addUnresolvedRowHint(String tableId, UnresolvedRowHint hint) {
        if (this.currentPageUnresolvedRowHints == null) {
            this.currentPageUnresolvedRowHints = new HashMap();
        }
        this.currentPageUnresolvedRowHints.put(this.htmlLayoutContext.getPageHintManager().getHintMapKey(tableId), hint);
    }

    public void resetRowHint() {
        this.docUnresolvedRowHints.clear();
        if (this.currentPageUnresolvedRowHints != null) {
            this.docUnresolvedRowHints.putAll(this.currentPageUnresolvedRowHints);
            this.currentPageUnresolvedRowHints.clear();
        }
    }

    public List<UnresolvedRowHint> getUnresolvedRowHints() {
        ArrayList<UnresolvedRowHint> unresolvedRowHintsList = new ArrayList<UnresolvedRowHint>();
        for (String key : this.getTableKeys()) {
            UnresolvedRowHint hint;
            if (this.docUnresolvedRowHints != null && (hint = this.docUnresolvedRowHints.get(key)) != null) {
                unresolvedRowHintsList.add(hint);
                continue;
            }
            hint = this.htmlUnresolvedRowHints.get(key);
            if (hint == null) continue;
            unresolvedRowHintsList.add(hint);
        }
        return unresolvedRowHintsList;
    }

    public void generatePageHints(IPageContent page) throws BirtException {
        PageArea pageArea = (PageArea)page.getExtension(1);
        if (pageArea != null) {
            this.reset();
            this.htmlUnresolvedRowHints = this.htmlLayoutContext.getPageHintManager().getUnresolvedRowHints();
            Iterator<IArea> i = pageArea.getBody().getChildren();
            while (i.hasNext()) {
                IArea child = i.next();
                this.traverse(child);
            }
        }
        if (this.startContent != null && this.currentContent != null) {
            this.fixedLayoutPageHints.add(new SizeBasedContent[]{this.startContent, this.currentContent});
        }
    }

    private void traverse(IArea area) {
        String bookmark;
        if (area instanceof ContainerArea) {
            if (area instanceof TableArea) {
                this.tableIds.add(((TableArea)area).getContent().getInstanceID().toUniqueString());
            }
            ContainerArea container = (ContainerArea)area;
            if (container.content != null && !container.isDummy && container.content.getInstanceID() != null) {
                this.start(container);
            }
            if (!(container.content instanceof ForeignContent)) {
                Iterator<IArea> i = container.getChildren();
                while (i.hasNext()) {
                    IArea child = i.next();
                    this.traverse(child);
                }
            }
        }
        if ((bookmark = area.getBookmark()) != null) {
            this.context.addBookmarkMap(this.context.getPageNumber(), bookmark);
        }
    }

    private void start(ContainerArea area) {
        if (this.startContent == null) {
            this.currentContent = this.startContent = this.createSizeBasedContent(area);
        } else if (this.currentContent != null) {
            if (InstanceIDComparator.isNextWith(this.currentContent.content, area.content)) {
                if (this.currentContent.dimension > 0) {
                    this.fixedLayoutPageHints.add(new SizeBasedContent[]{this.startContent, this.currentContent});
                    this.currentContent = this.startContent = this.createSizeBasedContent(area);
                    return;
                }
                this.currentContent = this.createSizeBasedContent(area);
            } else if (!InstanceIDComparator.equals(this.currentContent.content, area.content)) {
                this.fixedLayoutPageHints.add(new SizeBasedContent[]{this.startContent, this.currentContent});
                this.currentContent = this.startContent = this.createSizeBasedContent(area);
            }
        }
    }

    private SizeBasedContent createSizeBasedContent(ContainerArea area) {
        SizeBasedContent sizeBasedContent = new SizeBasedContent();
        sizeBasedContent.content = area.content instanceof AbstractContentWrapper ? ((AbstractContentWrapper)area.content).getContent() : area.content;
        if (area instanceof BlockTextArea) {
            BlockTextArea blockText = (BlockTextArea)area;
            sizeBasedContent.floatPos = 0;
            ArrayList list = (ArrayList)area.content.getExtension(1);
            if (list.size() > 1) {
                Iterator i = list.iterator();
                int offsetInContent = 0;
                int lastHeight = 0;
                while (i.hasNext()) {
                    offsetInContent += lastHeight;
                    BlockTextArea current = (BlockTextArea)i.next();
                    if (current == area) break;
                    lastHeight = current.getContentHeight();
                }
                sizeBasedContent.offsetInContent = offsetInContent;
                sizeBasedContent.dimension = blockText.getContentHeight();
                sizeBasedContent.width = blockText.getWidth();
            } else if (list.size() == 1) {
                sizeBasedContent.offsetInContent = 0;
                if (((BlockTextArea)list.get((int)0)).finished) {
                    sizeBasedContent.dimension = -1;
                    sizeBasedContent.width = -1;
                } else {
                    sizeBasedContent.dimension = blockText.getContentHeight();
                    sizeBasedContent.width = blockText.getWidth();
                }
            } else {
                sizeBasedContent.offsetInContent = 0;
                sizeBasedContent.dimension = -1;
                sizeBasedContent.width = -1;
            }
        } else if (area instanceof InlineTextArea) {
            InlineTextArea inlineText = (InlineTextArea)area;
            InlineTextExtension ext = (InlineTextExtension)area.content.getExtension(1);
            ext.updatePageHintInfo(inlineText);
            sizeBasedContent.floatPos = ext.getFloatPos();
            sizeBasedContent.offsetInContent = ext.getOffsetInContent();
            sizeBasedContent.dimension = ext.getDimension();
            sizeBasedContent.width = ext.getWidthRestrict();
        } else {
            sizeBasedContent.floatPos = -1;
            sizeBasedContent.offsetInContent = -1;
            sizeBasedContent.dimension = -1;
            sizeBasedContent.width = -1;
        }
        return sizeBasedContent;
    }

    private void reset() {
        this.startContent = null;
        this.currentContent = null;
        this.tableIds = new HashSet();
        this.fixedLayoutPageHints.clear();
    }

    private Collection<String> getTableKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (String tableId : this.tableIds) {
            String key = this.htmlLayoutContext.getPageHintManager().getHintMapKey(tableId);
            keys.add(key);
        }
        return keys;
    }

    static class InstanceIDComparator {
        InstanceIDComparator() {
        }

        static boolean isNextWith(IContent content1, IContent content2) {
            if (content1 == null || content2 == null || content1 == content2) {
                return false;
            }
            InstanceID id1 = content1.getInstanceID();
            InstanceID id2 = content2.getInstanceID();
            if (id1 == null || id2 == null) {
                return false;
            }
            if (id2.getUniqueID() == 0L) {
                IContent parent2 = (IContent)content2.getParent();
                if (parent2 instanceof IListBandContent || parent2 instanceof ITableBandContent) {
                    InstanceID pid2 = parent2.getInstanceID();
                    if (pid2 == null) {
                        return false;
                    }
                    if (pid2.getUniqueID() == 0L) {
                        return InstanceIDComparator.isNextWith(content1, parent2);
                    }
                    if (!content1.isLastChild()) {
                        return false;
                    }
                    IContent parent1 = (IContent)content1.getParent();
                    while (parent1.isLastChild()) {
                        parent1 = (IContent)parent1.getParent();
                    }
                    if (parent1 instanceof IListBandContent || parent1 instanceof ITableBandContent) {
                        return InstanceIDComparator.isSibling(parent1, parent2);
                    }
                    return false;
                }
                return InstanceIDComparator.equals(content1, parent2);
            }
            if (content1.hasChildren()) {
                return false;
            }
            if (content1.isLastChild()) {
                IContent parent1 = (IContent)content1.getParent();
                while (parent1.isLastChild()) {
                    parent1 = (IContent)parent1.getParent();
                }
                if (parent1 instanceof IListBandContent || parent1 instanceof ITableBandContent) {
                    return false;
                }
                return InstanceIDComparator.isSibling(parent1, content2);
            }
            return InstanceIDComparator.isSibling(content1, content2);
        }

        static boolean isSibling(IContent content1, IContent content2) {
            if (content1 == null || content2 == null || content1 == content2) {
                return false;
            }
            InstanceID id1 = content1.getInstanceID();
            InstanceID id2 = content2.getInstanceID();
            if (id1 == null || id2 == null) {
                return false;
            }
            if (id1.getUniqueID() + 1L == id2.getUniqueID()) {
                IContent parent1 = (IContent)content1.getParent();
                IContent parent2 = (IContent)content2.getParent();
                return InstanceIDComparator.equals(parent1, parent2);
            }
            return false;
        }

        static boolean equals(IContent content1, IContent content2) {
            if (content1 == content2) {
                return true;
            }
            if (content1 == null) {
                return content2 == null;
            }
            if (content2 == null) {
                return false;
            }
            InstanceID id1 = content1.getInstanceID();
            InstanceID id2 = content2.getInstanceID();
            if (id1 == null || id2 == null) {
                return false;
            }
            if (id1.getUniqueID() == id2.getUniqueID()) {
                IContent parent1 = (IContent)content1.getParent();
                IContent parent2 = (IContent)content2.getParent();
                return InstanceIDComparator.equals(parent1, parent2);
            }
            return false;
        }
    }
}

