/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class StylePropertyMapping {
    protected static final HashMap nameMapping = new HashMap();
    protected static IElementDefn styleDefn;

    static {
        nameMapping.put("fontFamily", new Integer(55));
        nameMapping.put("fontStyle", new Integer(45));
        nameMapping.put("fontVariant", new Integer(34));
        nameMapping.put("fontWeight", new Integer(33));
        nameMapping.put("fontSize", new Integer(44));
        nameMapping.put("color", new Integer(26));
        nameMapping.put("backgroundColor", new Integer(25));
        nameMapping.put("backgroundImage", new Integer(49));
        nameMapping.put("backgroundRepeat", new Integer(15));
        nameMapping.put("backgroundAttachment", new Integer(52));
        nameMapping.put("backgroundPositionX", new Integer(39));
        nameMapping.put("backgroundPositionY", new Integer(50));
        nameMapping.put("wordSpacing", new Integer(51));
        nameMapping.put("letterSpacing", new Integer(56));
        nameMapping.put("textUnderline", new Integer(53));
        nameMapping.put("textOverline", new Integer(37));
        nameMapping.put("textLineThrough", new Integer(28));
        nameMapping.put("verticalAlign", new Integer(38));
        nameMapping.put("textTransform", new Integer(35));
        nameMapping.put("textAlign", new Integer(24));
        nameMapping.put("textIndent", new Integer(21));
        nameMapping.put("lineHeight", new Integer(22));
        nameMapping.put("whiteSpace", new Integer(36));
        nameMapping.put("marginTop", new Integer(2));
        nameMapping.put("marginBottom", new Integer(16));
        nameMapping.put("marginLeft", new Integer(0));
        nameMapping.put("marginRight", new Integer(1));
        nameMapping.put("paddingTop", new Integer(10));
        nameMapping.put("paddingBottom", new Integer(9));
        nameMapping.put("paddingLeft", new Integer(7));
        nameMapping.put("paddingRight", new Integer(12));
        nameMapping.put("borderTopWidth", new Integer(6));
        nameMapping.put("borderBottomWidth", new Integer(23));
        nameMapping.put("borderLeftWidth", new Integer(31));
        nameMapping.put("borderRightWidth", new Integer(8));
        nameMapping.put("borderTopColor", new Integer(14));
        nameMapping.put("borderBottomColor", new Integer(20));
        nameMapping.put("borderLeftColor", new Integer(29));
        nameMapping.put("borderRightColor", new Integer(4));
        nameMapping.put("borderTopStyle", new Integer(46));
        nameMapping.put("borderBottomStyle", new Integer(32));
        nameMapping.put("borderLeftStyle", new Integer(40));
        nameMapping.put("borderRightStyle", new Integer(19));
        nameMapping.put("display", new Integer(54));
        nameMapping.put("orphans", new Integer(43));
        nameMapping.put("widows", new Integer(30));
        nameMapping.put("pageBreakAfter", new Integer(58));
        nameMapping.put("pageBreakBefore", new Integer(47));
        nameMapping.put("pageBreakInside", new Integer(57));
        nameMapping.put("masterPage", new Integer(42));
        nameMapping.put("showIfBlank", new Integer(48));
        nameMapping.put("canShrink", new Integer(13));
        nameMapping.put("numberAlign", new Integer(11));
        nameMapping.put("bidiTextDirection", new Integer(5));
        nameMapping.put("data-format", 3);
    }

    protected static IElementDefn getStyleDefn() {
        if (styleDefn != null) {
            return styleDefn;
        }
        styleDefn = MetaDataDictionary.getInstance().getElement("Style");
        assert (styleDefn != null);
        return styleDefn;
    }

    public static boolean canInherit(String name) {
        IElementPropertyDefn defn = StylePropertyMapping.getStyleDefn().getProperty(name);
        if (defn != null) {
            return defn.canInherit();
        }
        return false;
    }

    public static Object getDefaultValue(String name) {
        IElementPropertyDefn defn = StylePropertyMapping.getStyleDefn().getProperty(name);
        if (defn != null) {
            return defn.getDefault();
        }
        return null;
    }

    public static Object getDefaultValue(String name, ReportDesignHandle handle) {
        Object value = StylePropertyMapping.getDefaultValue(name);
        if (value == null && handle != null && handle.isDirectionRTL() && "bidiTextDirection".equals(name)) {
            return "rtl";
        }
        return value;
    }

    public static Object getDefaultValue(int index) {
        return StylePropertyMapping.getDefaultValue(nameMapping.get(new Integer(index)).toString());
    }

    public static int getPropertyID(String name) {
        int id = -1;
        Object obj = nameMapping.get(name);
        if (obj instanceof Integer) {
            id = (Integer)obj;
        }
        return id;
    }

    public static Set getPropertyMapping() {
        return nameMapping.entrySet();
    }
}

