/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.filter;

import org.eclipse.wst.wsdl.ui.internal.filter.AbstractExtensibilityElementFilter;
import org.w3c.dom.Element;

public class SoapExtensiblityElementFilter
extends AbstractExtensibilityElementFilter {
    public boolean isValidContext(Element parentElement, String localName) {
        boolean result = false;
        if (parentElement != null) {
            String parentElementName = parentElement.getLocalName();
            String parentNamespaceURI = parentElement.getNamespaceURI();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(parentNamespaceURI)) {
                if ("binding".equals(parentElementName)) {
                    result = "binding".equals(localName);
                } else if (this.isWSDLBindingOperation(parentElement)) {
                    result = "operation".equals(localName);
                } else if (this.isWSDLBindingOperation(parentElement.getParentNode())) {
                    if ("input".equals(parentElementName) || "output".equals(parentElementName)) {
                        result = "header".equals(localName) || "body".equals(localName);
                    } else if ("fault".equals(parentElementName)) {
                        result = "fault".equals(localName);
                    }
                } else if ("port".equals(parentElementName)) {
                    result = "address".equals(localName);
                }
            } else if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(parentNamespaceURI)) {
                if ("header".equals(parentElementName)) {
                    result = "headerfault".equals(localName);
                }
            } else if ("http://schemas.xmlsoap.org/wsdl/mime/".equals(parentNamespaceURI) && "part".equals(parentElementName)) {
                result = "body".equals(localName);
            }
        }
        return result;
    }
}

