/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.extension.FormPageDef;
import org.eclipse.birt.report.designer.ui.editors.extension.IExtensionConstants;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class EditorContributorManager
implements IExtensionConstants {
    private volatile HashMap editorContributorMap;
    private static volatile EditorContributorManager instance = null;

    private EditorContributorManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EditorContributorManager getInstance() {
        if (instance != null) return instance;
        Class<ExtensionPointManager> clazz = ExtensionPointManager.class;
        synchronized (ExtensionPointManager.class) {
            if (instance != null) return instance;
            instance = new EditorContributorManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditorContributor[] getEditorContributors() {
        EditorContributorManager editorContributorManager = this;
        synchronized (editorContributorManager) {
            block4: {
                if (this.editorContributorMap != null) break block4;
                this.createEditorContributorMap();
                if (this.editorContributorMap != null) break block4;
                return null;
            }
        }
        return this.editorContributorMap.values().toArray(new EditorContributor[this.editorContributorMap.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditorContributor getEditorContributor(String targetEditorId) {
        assert (targetEditorId != null);
        EditorContributorManager editorContributorManager = this;
        synchronized (editorContributorManager) {
            block5: {
                if (this.editorContributorMap != null) break block5;
                this.createEditorContributorMap();
                if (this.editorContributorMap != null) break block5;
                return null;
            }
        }
        return (EditorContributor)this.editorContributorMap.get(targetEditorId);
    }

    public FormPageDef getFormPageDef(String targetEditorId, String pageId) {
        assert (targetEditorId != null);
        assert (pageId != null);
        int index = this.findFormPageIndex(targetEditorId, pageId);
        if (index != -1) {
            return this.getFormPageDef(targetEditorId, index);
        }
        return null;
    }

    public int findFormPageIndex(String targetEditorId, String pageId) {
        List formPageDefList;
        assert (targetEditorId != null);
        assert (pageId != null);
        EditorContributor editorContributor = this.getEditorContributor(targetEditorId);
        if (editorContributor != null && (formPageDefList = editorContributor.formPageList) != null) {
            int i = 0;
            while (i < formPageDefList.size()) {
                FormPageDef formPageDef = (FormPageDef)formPageDefList.get(i);
                if (formPageDef != null && pageId.equals(formPageDef.id)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public FormPageDef getFormPageDef(String targetEditorId, int index) {
        assert (targetEditorId != null);
        EditorContributor editorContributor = this.getEditorContributor(targetEditorId);
        if (editorContributor != null && editorContributor.formPageList != null && index >= 0 && index < editorContributor.formPageList.size()) {
            return (FormPageDef)editorContributor.formPageList.get(index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEditorContributorMap() {
        EditorContributorManager editorContributorManager = this;
        synchronized (editorContributorManager) {
            this.editorContributorMap = new HashMap();
            for (IExtension extension : this.getExtensionElements("org.eclipse.birt.report.designer.ui.editors.multiPageEditorContributor")) {
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    EditorContributor editorContributor = this.createEditorContributor(elements[i]);
                    if (!this.editorContributorMap.containsKey(editorContributor.targetEditorId)) {
                        this.editorContributorMap.put(editorContributor.targetEditorId, editorContributor);
                    } else {
                        EditorContributor exsitContributor = (EditorContributor)this.editorContributorMap.get(editorContributor.targetEditorId);
                        exsitContributor.merge(editorContributor);
                    }
                    ++i;
                }
            }
        }
    }

    private EditorContributor createEditorContributor(IConfigurationElement element) {
        EditorContributor editorContributor = new EditorContributor();
        editorContributor.targetEditorId = this.loadStringAttribute(element, "targetEditorId");
        editorContributor.formPageList = EditorContributorManager.sortFormPageList(this.createFormPageDefList(element));
        return editorContributor;
    }

    private static List sortFormPageList(List formPageList) {
        ArrayList olist = new ArrayList(formPageList.size());
        olist.addAll(formPageList);
        ArrayList<FormPageDef> rlist = new ArrayList<FormPageDef>(olist.size());
        ArrayList<FormPageDef> unlist = new ArrayList<FormPageDef>();
        boolean resolved = true;
        while (olist.size() > 0 && resolved) {
            int relativePosition;
            FormPageDef element;
            resolved = false;
            int i = 0;
            while (i < olist.size()) {
                element = (FormPageDef)olist.get(i);
                if (element.relative == null) {
                    rlist.add(element);
                    resolved = true;
                } else {
                    relativePosition = EditorContributorManager.getRelativeElementPosition(element, rlist);
                    if (relativePosition == -1) {
                        relativePosition = EditorContributorManager.getRelativeElementPosition(element, olist);
                        if (relativePosition == -1) {
                            rlist.add(element);
                            resolved = true;
                        } else {
                            unlist.add(element);
                        }
                    } else {
                        rlist.add(relativePosition + element.position, element);
                        resolved = true;
                    }
                }
                ++i;
            }
            unlist.removeAll(rlist);
            Iterator itr = unlist.iterator();
            while (itr.hasNext()) {
                element = (FormPageDef)itr.next();
                relativePosition = EditorContributorManager.getRelativeElementPosition(element, rlist);
                if (relativePosition == -1) continue;
                rlist.add(relativePosition + element.position, element);
                itr.remove();
                resolved = true;
            }
            olist.removeAll(rlist);
        }
        rlist.addAll(unlist);
        return rlist;
    }

    private static int getRelativeElementPosition(FormPageDef element, List list) {
        String relativeId = element.relative;
        int i = 0;
        for (FormPageDef formPage : list) {
            if (formPage.id.equals(relativeId)) {
                return list.indexOf(formPage);
            }
            ++i;
        }
        return -1;
    }

    private List createFormPageDefList(IConfigurationElement element) {
        ArrayList<FormPageDef> formPageDefList = new ArrayList<FormPageDef>();
        ArrayList<String> keyList = new ArrayList<String>();
        IConfigurationElement[] elements = element.getChildren();
        int i = 0;
        while (i < elements.length) {
            FormPageDef formPageDef = new FormPageDef(elements[i]);
            if (!keyList.contains(formPageDef.id)) {
                formPageDefList.add(formPageDef);
                keyList.add(formPageDef.id);
            }
            ++i;
        }
        return formPageDefList;
    }

    private List getExtensionElements(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return Collections.EMPTY_LIST;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(id);
        if (extensionPoint == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(extensionPoint.getExtensions());
    }

    private String loadStringAttribute(IConfigurationElement element, String attributeName) {
        return element.getAttribute(attributeName);
    }

    public static class EditorContributor {
        public String targetEditorId;
        public List formPageList;

        public boolean merge(EditorContributor contributor) {
            assert (this.targetEditorId != null);
            boolean changed = false;
            if (this.targetEditorId.equals(contributor.targetEditorId)) {
                boolean needResort = false;
                for (FormPageDef incomingPage : contributor.formPageList) {
                    FormPageDef exsitPage = this.getPage(incomingPage.id);
                    if (exsitPage == null) {
                        this.formPageList.add(incomingPage);
                        needResort = true;
                        changed = true;
                        continue;
                    }
                    if (exsitPage.priority > incomingPage.priority) continue;
                    int index = this.formPageList.indexOf(exsitPage);
                    this.formPageList.set(index, incomingPage);
                    changed = true;
                }
                if (needResort) {
                    this.formPageList = EditorContributorManager.sortFormPageList(this.formPageList);
                }
            }
            return changed;
        }

        public FormPageDef getPage(int index) {
            return (FormPageDef)this.formPageList.get(index);
        }

        public FormPageDef getPage(String id) {
            for (FormPageDef page : this.formPageList) {
                if (!page.id.equals(id)) continue;
                return page;
            }
            return null;
        }
    }
}

