/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathDiv;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathPlus;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.UntypedAtomic;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XDTDayTimeDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XDTYearMonthDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;

public class FnAvg
extends Function {
    public FnAvg() {
        super(new QName("avg"), 1);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnAvg.avg(args);
    }

    public static ResultSequence avg(Collection args) throws DynamicError {
        ResultSequence arg = FnAvg.get_arg(args);
        if (arg.empty()) {
            return ResultSequenceFactory.create_new();
        }
        int elems = 0;
        MathPlus total = null;
        ListIterator i = arg.iterator();
        while (i.hasNext()) {
            AnyType at = (AnyType)i.next();
            if (!(at instanceof MathPlus)) {
                DynamicError.throw_type_error();
            }
            if (total == null) {
                total = (MathPlus)((Object)at);
            } else {
                ResultSequence res = total.plus(ResultSequenceFactory.create_new(at));
                assert (res.size() == 1);
                total = (MathPlus)((Object)res.first());
            }
            ++elems;
        }
        if (!(total instanceof MathDiv)) {
            DynamicError.throw_type_error();
        }
        MathDiv avg = (MathDiv)((Object)total);
        ResultSequence res = avg.div(ResultSequenceFactory.create_new(new XSDouble(elems)));
        return res;
    }

    public static ResultSequence get_arg(Collection args) throws DynamicError {
        assert (args.size() == 1);
        ResultSequence arg = (ResultSequence)args.iterator().next();
        if (arg.empty()) {
            return arg;
        }
        AnyType first = arg.first();
        Class durtype = null;
        durtype = first instanceof XDTDayTimeDuration ? XDTDayTimeDuration.class : (first instanceof XDTYearMonthDuration ? XDTYearMonthDuration.class : null);
        if (durtype != null) {
            ListIterator i = arg.iterator();
            while (i.hasNext()) {
                AnyType at = (AnyType)i.next();
                if (durtype.isInstance(at)) continue;
                DynamicError.throw_type_error();
            }
            return arg;
        }
        ResultSequence rs = ResultSequenceFactory.create_new();
        ListIterator i = arg.iterator();
        while (i.hasNext()) {
            AnyType at = (AnyType)i.next();
            XSDouble d = null;
            if (at instanceof UntypedAtomic) {
                d = XSDouble.parse_double(((UntypedAtomic)at).string_value());
            } else if (at instanceof NumericType) {
                d = XSDouble.parse_double(((NumericType)at).string_value());
            } else {
                DynamicError.throw_type_error();
            }
            if (d == null) {
                throw DynamicError.cant_cast(null);
            }
            rs.add(d);
        }
        return rs;
    }
}

