/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.util.bidi.profile;

import java.util.Properties;
import org.eclipse.birt.report.data.bidi.utils.core.BidiFormat;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.bidi.profile.AdvancedBidiDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class BidiSettingsSupport {
    private Button bidiButton;
    private BidiFormat metadataBidiFormat = null;
    private BidiFormat contentBidiFormat = null;

    public BidiSettingsSupport() {
        String bidiFormatString = JdbcPlugin.getDefault().getPluginPreferences().getString("report.data.oda.bidi.jdbc.ui.externalbidiformat");
        this.contentBidiFormat = this.metadataBidiFormat = new BidiFormat(bidiFormatString);
    }

    public void drawBidiSettingsButton(Composite parent, Properties props) {
        this.initBidiFormats(props);
        this.bidiButton = new Button(parent, 8);
        this.bidiButton.setText(JdbcPlugin.getResourceString("wizard.label.bidiSettings"));
        this.bidiButton.setLayoutData((Object)new GridData(3));
        this.bidiButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BidiSettingsSupport.this.doSetAdvancedBidiSettings();
            }
        });
    }

    private void doSetAdvancedBidiSettings() {
        AdvancedBidiDialog dlg = new AdvancedBidiDialog(this);
        dlg.open();
    }

    public BidiFormat getContentBidiFormat() {
        return this.contentBidiFormat;
    }

    public BidiFormat getMetadataBidiFormat() {
        return this.metadataBidiFormat;
    }

    public void setBidiFormats(BidiFormat metadataBidiFormat, BidiFormat contentBidiFormat) {
        this.contentBidiFormat = contentBidiFormat;
        this.metadataBidiFormat = metadataBidiFormat;
    }

    public Properties getBidiFormats() {
        Properties p = new Properties();
        BidiFormat externalDefaultBDiFormat = new BidiFormat(JdbcPlugin.getDefault().getPluginPreferences().getString("report.data.oda.bidi.jdbc.ui.externalbidiformat"));
        if (this.contentBidiFormat != null) {
            p.setProperty("contentBidiFormatStr", this.contentBidiFormat.getBiDiFormatString());
        } else {
            p.setProperty("contentBidiFormatStr", externalDefaultBDiFormat.getBiDiFormatString());
        }
        if (this.metadataBidiFormat != null) {
            p.setProperty("metadataBidiFormatStr", this.metadataBidiFormat.getBiDiFormatString());
        } else {
            p.setProperty("metadataBidiFormatStr", externalDefaultBDiFormat.getBiDiFormatString());
        }
        return p;
    }

    private void initBidiFormats(Properties props) {
        BidiFormat contentFormat = null;
        BidiFormat metadataFormat = null;
        if (props == null) {
            return;
        }
        String str = props.getProperty("contentBidiFormatStr");
        contentFormat = str != null && !str.equals("") ? new BidiFormat(str) : new BidiFormat("ILYNN");
        str = props.getProperty("metadataBidiFormatStr");
        metadataFormat = str != null && !str.equals("") ? new BidiFormat(str) : new BidiFormat("ILYNN");
        this.setBidiFormats(metadataFormat, contentFormat);
    }

    public Properties addBidiProperties(Properties props) {
        if (props != null) {
            if (this.contentBidiFormat != null) {
                props.setProperty("contentBidiFormatStr", this.contentBidiFormat.toString());
            }
            if (this.metadataBidiFormat != null) {
                props.setProperty("metadataBidiFormatStr", this.metadataBidiFormat.toString());
            }
        }
        return props;
    }
}

