/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.model.listener.TreeChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSupport
implements Serializable {
    protected final Model source;
    private transient GenericListenerList[] genericListeners = EMPTY_GENERIC_LISTENERS;
    private static final GenericListenerList[] EMPTY_GENERIC_LISTENERS = new GenericListenerList[0];
    private AspectChild[] aspectChildren = EMPTY_ASPECT_CHILDREN;
    private static final AspectChild[] EMPTY_ASPECT_CHILDREN = new AspectChild[0];
    private static final long serialVersionUID = 1L;
    protected static final Class<StateChangeListener> STATE_CHANGE_LISTENER_CLASS = StateChangeListener.class;
    protected static final Class<PropertyChangeListener> PROPERTY_CHANGE_LISTENER_CLASS = PropertyChangeListener.class;
    protected static final Class<CollectionChangeListener> COLLECTION_CHANGE_LISTENER_CLASS = CollectionChangeListener.class;
    protected static final Class<ListChangeListener> LIST_CHANGE_LISTENER_CLASS = ListChangeListener.class;
    protected static final Class<TreeChangeListener> TREE_CHANGE_LISTENER_CLASS = TreeChangeListener.class;
    private static final Object[] EMPTY_TREE_PATH = new Object[0];

    public ChangeSupport(Model source) {
        if (source == null) {
            throw new NullPointerException();
        }
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ChangeListener> void addListener(Class<T> listenerClass, T listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            GenericListenerList gll = this.getGenericListenerList(listenerClass);
            if (gll == null) {
                this.addGenericListenerList(listenerClass, listener);
            } else {
                gll.addListener(listener);
            }
        }
    }

    protected GenericListenerList getGenericListenerList(Class<? extends ChangeListener> listenerClass) {
        GenericListenerList[] genericListenerListArray = this.genericListeners;
        int n = this.genericListeners.length;
        int n2 = 0;
        while (n2 < n) {
            GenericListenerList gll = genericListenerListArray[n2];
            if (gll.listenerClass == listenerClass) {
                return gll;
            }
            ++n2;
        }
        return null;
    }

    protected <T extends ChangeListener> GenericListenerList addGenericListenerList(Class<T> listenerClass, T listener) {
        GenericListenerList gll = new GenericListenerList(listenerClass, listener);
        this.genericListeners = CollectionTools.add(this.genericListeners, gll);
        return gll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ChangeListener> void addListener(String aspectName, Class<T> listenerClass, T listener) {
        if (aspectName == null || listener == null) {
            throw new NullPointerException();
        }
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ChangeSupport child = this.getChild(aspectName);
            if (child == null) {
                child = this.addChild(aspectName);
            }
            child.addListener(listenerClass, listener);
        }
    }

    protected ChangeSupport getChild(String aspectName) {
        if (aspectName == null) {
            return null;
        }
        AspectChild[] aspectChildArray = this.aspectChildren;
        int n = this.aspectChildren.length;
        int n2 = 0;
        while (n2 < n) {
            AspectChild aspectChild = aspectChildArray[n2];
            if (aspectChild.aspectName.equals(aspectName)) {
                return aspectChild.child;
            }
            ++n2;
        }
        return null;
    }

    protected ChangeSupport addChild(String aspectName) {
        ChangeSupport child = this.buildChild();
        this.aspectChildren = CollectionTools.add(this.aspectChildren, new AspectChild(aspectName, child));
        return child;
    }

    protected ChangeSupport buildChild() {
        return new Child(this.source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ChangeListener> void removeListener(Class<T> listenerClass, T listener) {
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            GenericListenerList gll = this.getGenericListenerList(listenerClass);
            if (gll == null) {
                this.handleUnregisteredListener(listener);
            } else if (!gll.removeListener(listener)) {
                this.handleUnregisteredListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ChangeListener> void removeListener(String aspectName, Class<T> listenerClass, T listener) {
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ChangeSupport child = this.getChild(aspectName);
            if (child == null) {
                this.handleUnregisteredListener(listener);
            } else {
                child.removeListener(listenerClass, listener);
            }
        }
    }

    protected <T extends ChangeListener> void handleUnregisteredListener(T listener) {
        throw new IllegalArgumentException("listener not registered: " + listener);
    }

    protected ChangeListener[] getListeners(Class<? extends ChangeListener> listenerClass) {
        GenericListenerList gll = this.getGenericListenerList(listenerClass);
        return gll == null ? null : gll.listeners;
    }

    protected synchronized <T extends ChangeListener> boolean hasAnyListeners(Class<T> listenerClass) {
        GenericListenerList gll = this.getGenericListenerList(listenerClass);
        return gll != null && gll.hasListeners();
    }

    protected <T extends ChangeListener> boolean hasNoListeners(Class<T> listenerClass) {
        return !this.hasAnyListeners(listenerClass);
    }

    protected synchronized boolean hasAnyListeners(Class<? extends ChangeListener> listenerClass, String aspectName) {
        if (this.hasAnyListeners(listenerClass)) {
            return true;
        }
        ChangeSupport child = this.getChild(aspectName);
        return child != null && child.hasAnyListeners(listenerClass);
    }

    protected <T extends ChangeListener> boolean hasNoListeners(Class<T> listenerClass, String aspectName) {
        return !this.hasAnyListeners(listenerClass, aspectName);
    }

    protected void aspectChanged(String aspectName) {
    }

    public void addStateChangeListener(StateChangeListener listener) {
        this.addListener(STATE_CHANGE_LISTENER_CLASS, listener);
    }

    public void removeStateChangeListener(StateChangeListener listener) {
        this.removeListener(STATE_CHANGE_LISTENER_CLASS, listener);
    }

    public boolean hasAnyStateChangeListeners() {
        return this.hasAnyListeners(STATE_CHANGE_LISTENER_CLASS);
    }

    private StateChangeListener[] getStateChangeListeners() {
        return (StateChangeListener[])this.getListeners(STATE_CHANGE_LISTENER_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStateChanged(StateChangeEvent event) {
        StateChangeListener[] targets = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            StateChangeListener[] stateChangeListeners = this.getStateChangeListeners();
            if (stateChangeListeners != null) {
                targets = (StateChangeListener[])stateChangeListeners.clone();
            }
        }
        if (targets != null) {
            StateChangeListener[] stateChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                StateChangeListener target = stateChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getStateChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.stateChanged(event);
                }
                ++n2;
            }
        }
        this.aspectChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStateChanged() {
        StateChangeListener[] targets = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            StateChangeListener[] stateChangeListeners = this.getStateChangeListeners();
            if (stateChangeListeners != null) {
                targets = (StateChangeListener[])stateChangeListeners.clone();
            }
        }
        if (targets != null) {
            StateChangeEvent event = null;
            StateChangeListener[] stateChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                StateChangeListener target = stateChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getStateChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new StateChangeEvent(this.source);
                    }
                    target.stateChanged(event);
                }
                ++n2;
            }
        }
        this.aspectChanged(null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addListener(PROPERTY_CHANGE_LISTENER_CLASS, listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.addListener(propertyName, PROPERTY_CHANGE_LISTENER_CLASS, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.removeListener(PROPERTY_CHANGE_LISTENER_CLASS, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.removeListener(propertyName, PROPERTY_CHANGE_LISTENER_CLASS, listener);
    }

    public boolean hasAnyPropertyChangeListeners(String propertyName) {
        return this.hasAnyListeners(PROPERTY_CHANGE_LISTENER_CLASS, propertyName);
    }

    public boolean hasAnyPropertyChangeListeners() {
        return this.hasAnyListeners(PROPERTY_CHANGE_LISTENER_CLASS);
    }

    private PropertyChangeListener[] getPropertyChangeListeners() {
        return (PropertyChangeListener[])this.getListeners(PROPERTY_CHANGE_LISTENER_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChanged(PropertyChangeEvent event) {
        if (this.valuesAreEqual(event.getOldValue(), event.getNewValue())) {
            return;
        }
        String propertyName = event.getPropertyName();
        PropertyChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            PropertyChangeListener[] propertyChangeListeners = this.getPropertyChangeListeners();
            if (propertyChangeListeners != null) {
                targets = (PropertyChangeListener[])propertyChangeListeners.clone();
            }
            child = this.getChild(propertyName);
        }
        if (targets != null) {
            PropertyChangeListener[] propertyChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                PropertyChangeListener target = propertyChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getPropertyChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.propertyChanged(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.firePropertyChanged(event);
        }
        this.aspectChanged(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        if (this.valuesAreEqual(oldValue, newValue)) {
            return;
        }
        PropertyChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            PropertyChangeListener[] propertyChangeListeners = this.getPropertyChangeListeners();
            if (propertyChangeListeners != null) {
                targets = (PropertyChangeListener[])propertyChangeListeners.clone();
            }
            child = this.getChild(propertyName);
        }
        PropertyChangeEvent event = null;
        if (targets != null) {
            PropertyChangeListener[] propertyChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                PropertyChangeListener target = propertyChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getPropertyChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
                    }
                    target.propertyChanged(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.firePropertyChanged(propertyName, oldValue, newValue);
            } else {
                child.firePropertyChanged(event);
            }
        }
        this.aspectChanged(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChanged(String propertyName, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        PropertyChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            PropertyChangeListener[] propertyChangeListeners = this.getPropertyChangeListeners();
            if (propertyChangeListeners != null) {
                targets = (PropertyChangeListener[])propertyChangeListeners.clone();
            }
            child = this.getChild(propertyName);
        }
        PropertyChangeEvent event = null;
        if (targets != null) {
            PropertyChangeListener[] propertyChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                PropertyChangeListener target = propertyChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getPropertyChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
                    }
                    target.propertyChanged(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.firePropertyChanged(propertyName, oldValue, newValue);
            } else {
                child.firePropertyChanged(event);
            }
        }
        this.aspectChanged(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChanged(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue == newValue) {
            return;
        }
        PropertyChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            PropertyChangeListener[] propertyChangeListeners = this.getPropertyChangeListeners();
            if (propertyChangeListeners != null) {
                targets = (PropertyChangeListener[])propertyChangeListeners.clone();
            }
            child = this.getChild(propertyName);
        }
        PropertyChangeEvent event = null;
        if (targets != null) {
            PropertyChangeListener[] propertyChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                PropertyChangeListener target = propertyChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getPropertyChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
                    }
                    target.propertyChanged(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.firePropertyChanged(propertyName, oldValue, newValue);
            } else {
                child.firePropertyChanged(event);
            }
        }
        this.aspectChanged(propertyName);
    }

    public void addCollectionChangeListener(CollectionChangeListener listener) {
        this.addListener(COLLECTION_CHANGE_LISTENER_CLASS, listener);
    }

    public void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.addListener(collectionName, COLLECTION_CHANGE_LISTENER_CLASS, listener);
    }

    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        this.removeListener(COLLECTION_CHANGE_LISTENER_CLASS, listener);
    }

    public void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.removeListener(collectionName, COLLECTION_CHANGE_LISTENER_CLASS, listener);
    }

    public boolean hasAnyCollectionChangeListeners(String collectionName) {
        return this.hasAnyListeners(COLLECTION_CHANGE_LISTENER_CLASS, collectionName);
    }

    public boolean hasAnyCollectionChangeListeners() {
        return this.hasAnyListeners(COLLECTION_CHANGE_LISTENER_CLASS);
    }

    private CollectionChangeListener[] getCollectionChangeListeners() {
        return (CollectionChangeListener[])this.getListeners(COLLECTION_CHANGE_LISTENER_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(CollectionChangeEvent event) {
        if (event.itemsSize() == 0) {
            return;
        }
        String collectionName = event.getCollectionName();
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.getCollectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.getChild(collectionName);
        }
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getCollectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.itemsAdded(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireItemsAdded(event);
        }
        this.aspectChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(String collectionName, Collection<?> addedItems) {
        if (addedItems.isEmpty()) {
            return;
        }
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.getCollectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.getChild(collectionName);
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getCollectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new CollectionChangeEvent(this.source, collectionName, addedItems);
                    }
                    target.itemsAdded(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsAdded(collectionName, addedItems);
            } else {
                child.fireItemsAdded(event);
            }
        }
        this.aspectChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemAdded(String collectionName, Object addedItem) {
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.getCollectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.getChild(collectionName);
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getCollectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new CollectionChangeEvent(this.source, collectionName, Collections.singleton(addedItem));
                    }
                    target.itemsAdded(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemAdded(collectionName, addedItem);
            } else {
                child.fireItemsAdded(event);
            }
        }
        this.aspectChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(CollectionChangeEvent event) {
        if (event.itemsSize() == 0) {
            return;
        }
        String collectionName = event.getCollectionName();
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.getCollectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.getChild(collectionName);
        }
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getCollectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.itemsRemoved(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireItemsRemoved(event);
        }
        this.aspectChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(String collectionName, Collection<?> removedItems) {
        if (removedItems.isEmpty()) {
            return;
        }
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.getCollectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.getChild(collectionName);
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getCollectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new CollectionChangeEvent(this.source, collectionName, removedItems);
                    }
                    target.itemsRemoved(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsRemoved(collectionName, removedItems);
            } else {
                child.fireItemsRemoved(event);
            }
        }
        this.aspectChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemRemoved(String collectionName, Object removedItem) {
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.getCollectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.getChild(collectionName);
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getCollectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new CollectionChangeEvent(this.source, collectionName, Collections.singleton(removedItem));
                    }
                    target.itemsRemoved(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemRemoved(collectionName, removedItem);
            } else {
                child.fireItemsRemoved(event);
            }
        }
        this.aspectChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCollectionCleared(CollectionChangeEvent event) {
        String collectionName = event.getCollectionName();
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.getCollectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.getChild(collectionName);
        }
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getCollectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.collectionCleared(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireCollectionCleared(event);
        }
        this.aspectChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCollectionCleared(String collectionName) {
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.getCollectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.getChild(collectionName);
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getCollectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new CollectionChangeEvent(this.source, collectionName);
                    }
                    target.collectionCleared(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireCollectionCleared(collectionName);
            } else {
                child.fireCollectionCleared(event);
            }
        }
        this.aspectChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCollectionChanged(CollectionChangeEvent event) {
        String collectionName = event.getCollectionName();
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.getCollectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.getChild(collectionName);
        }
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getCollectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.collectionChanged(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireCollectionChanged(event);
        }
        this.aspectChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCollectionChanged(String collectionName) {
        CollectionChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            CollectionChangeListener[] collectionChangeListeners = this.getCollectionChangeListeners();
            if (collectionChangeListeners != null) {
                targets = (CollectionChangeListener[])collectionChangeListeners.clone();
            }
            child = this.getChild(collectionName);
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            CollectionChangeListener[] collectionChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                CollectionChangeListener target = collectionChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getCollectionChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new CollectionChangeEvent(this.source, collectionName);
                    }
                    target.collectionChanged(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireCollectionChanged(collectionName);
            } else {
                child.fireCollectionChanged(event);
            }
        }
        this.aspectChanged(collectionName);
    }

    public <E> boolean addItemToCollection(E item, Collection<E> collection, String collectionName) {
        if (collection.add(item)) {
            this.fireItemAdded(collectionName, item);
            return true;
        }
        return false;
    }

    public <E> boolean addItemsToCollection(E[] items, Collection<E> collection, String collectionName) {
        return items.length != 0 && this.addItemsToCollection_(new ArrayIterator<E>(items), collection, collectionName);
    }

    public <E> boolean addItemsToCollection(Collection<? extends E> items, Collection<E> collection, String collectionName) {
        return !items.isEmpty() && this.addItemsToCollection_(items.iterator(), collection, collectionName);
    }

    public <E> boolean addItemsToCollection(Iterable<? extends E> items, Collection<E> collection, String collectionName) {
        return this.addItemsToCollection(items.iterator(), collection, collectionName);
    }

    public <E> boolean addItemsToCollection(Iterator<? extends E> items, Collection<E> collection, String collectionName) {
        return items.hasNext() && this.addItemsToCollection_(items, collection, collectionName);
    }

    protected <E> boolean addItemsToCollection_(Iterator<? extends E> items, Collection<E> collection, String collectionName) {
        ArrayList<E> addedItems = null;
        while (items.hasNext()) {
            E item = items.next();
            if (!collection.add(item)) continue;
            if (addedItems == null) {
                addedItems = new ArrayList<E>();
            }
            addedItems.add(item);
        }
        if (addedItems != null) {
            this.fireItemsAdded(collectionName, addedItems);
            return true;
        }
        return false;
    }

    public boolean removeItemFromCollection(Object item, Collection<?> collection, String collectionName) {
        if (collection.remove(item)) {
            this.fireItemRemoved(collectionName, item);
            return true;
        }
        return false;
    }

    public boolean removeItemsFromCollection(Object[] items, Collection<?> collection, String collectionName) {
        return items.length != 0 && !collection.isEmpty() && this.removeItemsFromCollection_(new ArrayIterator<Object>(items), collection, collectionName);
    }

    public boolean removeItemsFromCollection(Collection<?> items, Collection<?> collection, String collectionName) {
        return !items.isEmpty() && !collection.isEmpty() && this.removeItemsFromCollection_(items.iterator(), collection, collectionName);
    }

    public boolean removeItemsFromCollection(Iterable<?> items, Collection<?> collection, String collectionName) {
        return this.removeItemsFromCollection(items.iterator(), collection, collectionName);
    }

    public boolean removeItemsFromCollection(Iterator<?> items, Collection<?> collection, String collectionName) {
        return items.hasNext() && !collection.isEmpty() && this.removeItemsFromCollection_(items, collection, collectionName);
    }

    protected boolean removeItemsFromCollection_(Iterator<?> items, Collection<?> collection, String collectionName) {
        HashBag<?> removedItems = CollectionTools.collection(items);
        removedItems.retainAll(collection);
        boolean changed = collection.removeAll(removedItems);
        if (!removedItems.isEmpty()) {
            this.fireItemsRemoved(collectionName, removedItems);
        }
        return changed;
    }

    public boolean retainItemsInCollection(Object[] items, Collection<?> collection, String collectionName) {
        if (collection.isEmpty()) {
            return false;
        }
        if (items.length == 0) {
            return this.clearCollection_(collection, collectionName);
        }
        return this.retainItemsInCollection_(new ArrayIterator<Object>(items), collection, collectionName);
    }

    public boolean retainItemsInCollection(Collection<?> items, Collection<?> collection, String collectionName) {
        if (collection.isEmpty()) {
            return false;
        }
        if (items.isEmpty()) {
            return this.clearCollection_(collection, collectionName);
        }
        return this.retainItemsInCollection_(items.iterator(), collection, collectionName);
    }

    public boolean retainItemsInCollection(Iterable<?> items, Collection<?> collection, String collectionName) {
        return this.retainItemsInCollection(items.iterator(), collection, collectionName);
    }

    public boolean retainItemsInCollection(Iterator<?> items, Collection<?> collection, String collectionName) {
        if (collection.isEmpty()) {
            return false;
        }
        if (!items.hasNext()) {
            return this.clearCollection_(collection, collectionName);
        }
        return this.retainItemsInCollection_(items, collection, collectionName);
    }

    protected boolean retainItemsInCollection_(Iterator<?> items, Collection<?> collection, String collectionName) {
        HashBag<?> retainedItems = CollectionTools.collection(items);
        HashBag<?> removedItems = CollectionTools.collection(collection);
        removedItems.removeAll(retainedItems);
        boolean changed = collection.retainAll(retainedItems);
        if (!removedItems.isEmpty()) {
            this.fireItemsRemoved(collectionName, removedItems);
        }
        return changed;
    }

    public boolean clearCollection(Collection<?> collection, String collectionName) {
        if (collection.isEmpty()) {
            return false;
        }
        return this.clearCollection_(collection, collectionName);
    }

    protected boolean clearCollection_(Collection<?> collection, String collectionName) {
        collection.clear();
        this.fireCollectionCleared(collectionName);
        return true;
    }

    public <E> boolean synchronizeCollection(Collection<E> newCollection, Collection<E> collection, String collectionName) {
        if (newCollection.isEmpty()) {
            return this.clearCollection(collection, collectionName);
        }
        if (collection.isEmpty()) {
            return this.addItemsToCollection_(newCollection.iterator(), collection, collectionName);
        }
        return this.synchronizeCollection_(newCollection, collection, collectionName);
    }

    public <E> boolean synchronizeCollection(Iterator<E> newCollection, Collection<E> collection, String collectionName) {
        if (!newCollection.hasNext()) {
            return this.clearCollection(collection, collectionName);
        }
        if (collection.isEmpty()) {
            return this.addItemsToCollection_(newCollection, collection, collectionName);
        }
        return this.synchronizeCollection_(CollectionTools.collection(newCollection), collection, collectionName);
    }

    protected <E> boolean synchronizeCollection_(Collection<E> newCollection, Collection<E> collection, String collectionName) {
        boolean changed = false;
        HashBag<E> removeItems = new HashBag<E>(collection);
        removeItems.removeAll(newCollection);
        changed |= this.removeItemsFromCollection((Collection<?>)removeItems, (Collection<?>)collection, collectionName);
        HashBag<E> addItems = new HashBag<E>(newCollection);
        addItems.removeAll(collection);
        return changed |= this.addItemsToCollection((Collection<? extends E>)addItems, collection, collectionName);
    }

    public void addListChangeListener(ListChangeListener listener) {
        this.addListener(LIST_CHANGE_LISTENER_CLASS, listener);
    }

    public void addListChangeListener(String listName, ListChangeListener listener) {
        this.addListener(listName, LIST_CHANGE_LISTENER_CLASS, listener);
    }

    public void removeListChangeListener(ListChangeListener listener) {
        this.removeListener(LIST_CHANGE_LISTENER_CLASS, listener);
    }

    public void removeListChangeListener(String listName, ListChangeListener listener) {
        this.removeListener(listName, LIST_CHANGE_LISTENER_CLASS, listener);
    }

    public boolean hasAnyListChangeListeners(String listName) {
        return this.hasAnyListeners(LIST_CHANGE_LISTENER_CLASS, listName);
    }

    public boolean hasAnyListChangeListeners() {
        return this.hasAnyListeners(LIST_CHANGE_LISTENER_CLASS);
    }

    private ListChangeListener[] getListChangeListeners() {
        return (ListChangeListener[])this.getListeners(LIST_CHANGE_LISTENER_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(ListChangeEvent event) {
        if (event.itemsSize() == 0) {
            return;
        }
        String listName = event.getListName();
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.getListChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.getChild(listName);
        }
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getListChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.itemsAdded(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireItemsAdded(event);
        }
        this.aspectChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(String listName, int index, List<?> addedItems) {
        if (addedItems.isEmpty()) {
            return;
        }
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.getListChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.getChild(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getListChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName, index, addedItems);
                    }
                    target.itemsAdded(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsAdded(listName, index, addedItems);
            } else {
                child.fireItemsAdded(event);
            }
        }
        this.aspectChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemAdded(String listName, int index, Object addedItem) {
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.getListChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.getChild(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getListChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName, index, Collections.singletonList(addedItem));
                    }
                    target.itemsAdded(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemAdded(listName, index, addedItem);
            } else {
                child.fireItemsAdded(event);
            }
        }
        this.aspectChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(ListChangeEvent event) {
        if (event.itemsSize() == 0) {
            return;
        }
        String listName = event.getListName();
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.getListChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.getChild(listName);
        }
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getListChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.itemsRemoved(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireItemsRemoved(event);
        }
        this.aspectChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(String listName, int index, List<?> removedItems) {
        if (removedItems.isEmpty()) {
            return;
        }
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.getListChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.getChild(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getListChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName, index, removedItems);
                    }
                    target.itemsRemoved(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsRemoved(listName, index, removedItems);
            } else {
                child.fireItemsRemoved(event);
            }
        }
        this.aspectChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemRemoved(String listName, int index, Object removedItem) {
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.getListChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.getChild(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getListChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName, index, Collections.singletonList(removedItem));
                    }
                    target.itemsRemoved(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemRemoved(listName, index, removedItem);
            } else {
                child.fireItemsRemoved(event);
            }
        }
        this.aspectChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsReplaced(ListChangeEvent event) {
        if (event.itemsSize() == 0) {
            return;
        }
        String listName = event.getListName();
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.getListChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.getChild(listName);
        }
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getListChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.itemsReplaced(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireItemsReplaced(event);
        }
        this.aspectChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsReplaced(String listName, int index, List<?> newItems, List<?> replacedItems) {
        if (newItems.isEmpty()) {
            return;
        }
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.getListChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.getChild(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getListChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName, index, newItems, replacedItems);
                    }
                    target.itemsReplaced(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsReplaced(listName, index, newItems, replacedItems);
            } else {
                child.fireItemsReplaced(event);
            }
        }
        this.aspectChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemReplaced(String listName, int index, Object newItem, Object replacedItem) {
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.getListChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.getChild(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getListChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName, index, Collections.singletonList(newItem), Collections.singletonList(replacedItem));
                    }
                    target.itemsReplaced(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemReplaced(listName, index, newItem, replacedItem);
            } else {
                child.fireItemsReplaced(event);
            }
        }
        this.aspectChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsMoved(ListChangeEvent event) {
        if (event.getTargetIndex() == event.getSourceIndex()) {
            return;
        }
        String listName = event.getListName();
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.getListChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.getChild(listName);
        }
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getListChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.itemsMoved(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireItemsMoved(event);
        }
        this.aspectChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsMoved(String listName, int targetIndex, int sourceIndex, int length) {
        if (targetIndex == sourceIndex) {
            return;
        }
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.getListChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.getChild(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getListChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName, targetIndex, sourceIndex, length);
                    }
                    target.itemsMoved(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsMoved(listName, targetIndex, sourceIndex, length);
            } else {
                child.fireItemsMoved(event);
            }
        }
        this.aspectChanged(listName);
    }

    public void fireItemMoved(String listName, int targetIndex, int sourceIndex) {
        this.fireItemsMoved(listName, targetIndex, sourceIndex, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireListCleared(ListChangeEvent event) {
        String listName = event.getListName();
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.getListChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.getChild(listName);
        }
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getListChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.listCleared(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireListCleared(event);
        }
        this.aspectChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireListCleared(String listName) {
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.getListChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.getChild(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getListChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName);
                    }
                    target.listCleared(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireListCleared(listName);
            } else {
                child.fireListCleared(event);
            }
        }
        this.aspectChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireListChanged(ListChangeEvent event) {
        String listName = event.getListName();
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.getListChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.getChild(listName);
        }
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getListChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.listChanged(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireListChanged(event);
        }
        this.aspectChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireListChanged(String listName) {
        ListChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ListChangeListener[] listChangeListeners = this.getListChangeListeners();
            if (listChangeListeners != null) {
                targets = (ListChangeListener[])listChangeListeners.clone();
            }
            child = this.getChild(listName);
        }
        ListChangeEvent event = null;
        if (targets != null) {
            ListChangeListener[] listChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                ListChangeListener target = listChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getListChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new ListChangeEvent(this.source, listName);
                    }
                    target.listChanged(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireListChanged(listName);
            } else {
                child.fireListChanged(event);
            }
        }
        this.aspectChanged(listName);
    }

    public <E> void addItemToList(int index, E item, List<E> list, String listName) {
        list.add(index, item);
        this.fireItemAdded(listName, index, item);
    }

    public <E> boolean addItemToList(E item, List<E> list, String listName) {
        if (list.add(item)) {
            this.fireItemAdded(listName, list.size() - 1, item);
            return true;
        }
        return false;
    }

    public <E> boolean addItemsToList(int index, E[] items, List<E> list, String listName) {
        return items.length != 0 && this.addItemsToList_(index, Arrays.asList(items), list, listName);
    }

    public <E> boolean addItemsToList(int index, Collection<? extends E> items, List<E> list, String listName) {
        return !items.isEmpty() && this.addItemsToList_(index, this.convertToList(items), list, listName);
    }

    protected <E> boolean addItemsToList_(int index, List<? extends E> items, List<E> list, String listName) {
        if (list.addAll(index, items)) {
            this.fireItemsAdded(listName, index, items);
            return true;
        }
        return false;
    }

    public <E> boolean addItemsToList(int index, Iterable<? extends E> items, List<E> list, String listName) {
        return this.addItemsToList(index, items.iterator(), list, listName);
    }

    public <E> boolean addItemsToList(int index, Iterator<? extends E> items, List<E> list, String listName) {
        if (!items.hasNext()) {
            return false;
        }
        ArrayList<? extends E> addedItems = CollectionTools.list(items);
        if (list.addAll(index, addedItems)) {
            this.fireItemsAdded(listName, index, addedItems);
            return true;
        }
        return false;
    }

    public <E> boolean addItemsToList(E[] items, List<E> list, String listName) {
        return items.length != 0 && this.addItemsToList_(Arrays.asList(items), list, listName);
    }

    public <E> boolean addItemsToList(Collection<? extends E> items, List<E> list, String listName) {
        return !items.isEmpty() && this.addItemsToList_(this.convertToList(items), list, listName);
    }

    protected <E> List<? extends E> convertToList(Collection<? extends E> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList<E>(collection);
    }

    protected <E> boolean addItemsToList_(List<? extends E> items, List<E> list, String listName) {
        int index = list.size();
        if (list.addAll(items)) {
            this.fireItemsAdded(listName, index, items);
            return true;
        }
        return false;
    }

    public <E> boolean addItemsToList(Iterable<? extends E> items, List<E> list, String listName) {
        return this.addItemsToList(items.iterator(), list, listName);
    }

    public <E> boolean addItemsToList(Iterator<? extends E> items, List<E> list, String listName) {
        if (!items.hasNext()) {
            return false;
        }
        return this.addItemsToList_(items, list, listName);
    }

    protected <E> boolean addItemsToList_(Iterator<? extends E> items, List<E> list, String listName) {
        ArrayList<? extends E> addedItems = CollectionTools.list(items);
        int index = list.size();
        if (list.addAll(addedItems)) {
            this.fireItemsAdded(listName, index, addedItems);
            return true;
        }
        return false;
    }

    public <E> E removeItemFromList(int index, List<E> list, String listName) {
        E item = list.remove(index);
        this.fireItemRemoved(listName, index, item);
        return item;
    }

    public boolean removeItemFromList(Object item, List<?> list, String listName) {
        int index = list.indexOf(item);
        if (index == -1) {
            return false;
        }
        list.remove(index);
        this.fireItemRemoved(listName, index, item);
        return true;
    }

    public <E> List<E> removeItemsFromList(int index, int length, List<E> list, String listName) {
        if (length == 0) {
            return Collections.emptyList();
        }
        return this.removeItemsFromList_(index, length, list, listName);
    }

    protected <E> List<E> removeItemsFromList_(int index, int length, List<E> list, String listName) {
        List<E> subList = list.subList(index, index + length);
        ArrayList<E> removedItems = new ArrayList<E>(subList);
        subList.clear();
        this.fireItemsRemoved(listName, index, removedItems);
        return removedItems;
    }

    public boolean removeItemsFromList(Object[] items, List<?> list, String listName) {
        return items.length != 0 && !list.isEmpty() && this.removeItemsFromList_(new ArrayIterator<Object>(items), list, listName);
    }

    public boolean removeItemsFromList(Collection<?> items, List<?> list, String listName) {
        return !items.isEmpty() && !list.isEmpty() && this.removeItemsFromList_(items.iterator(), list, listName);
    }

    public boolean removeItemsFromList(Iterable<?> items, List<?> list, String listName) {
        return this.removeItemsFromList(items.iterator(), list, listName);
    }

    public boolean removeItemsFromList(Iterator<?> items, List<?> list, String listName) {
        return items.hasNext() && !list.isEmpty() && this.removeItemsFromList_(items, list, listName);
    }

    protected boolean removeItemsFromList_(Iterator<?> items, List<?> list, String listName) {
        boolean changed = false;
        while (items.hasNext()) {
            changed |= this.removeItemFromList(items.next(), list, listName);
        }
        return changed;
    }

    public boolean retainItemsInList(Object[] items, List<?> list, String listName) {
        if (list.isEmpty()) {
            return false;
        }
        if (items.length == 0) {
            return this.clearList_(list, listName);
        }
        return this.retainItemsInList_(new ArrayIterator<Object>(items), list, listName);
    }

    public boolean retainItemsInList(Collection<?> items, List<?> list, String listName) {
        if (list.isEmpty()) {
            return false;
        }
        if (items.isEmpty()) {
            return this.clearList_(list, listName);
        }
        return this.retainItemsInList_(items.iterator(), list, listName);
    }

    public boolean retainItemsInList(Iterable<?> items, List<?> list, String listName) {
        return this.retainItemsInList(items.iterator(), list, listName);
    }

    public boolean retainItemsInList(Iterator<?> items, List<?> list, String listName) {
        if (list.isEmpty()) {
            return false;
        }
        if (!items.hasNext()) {
            return this.clearList_(list, listName);
        }
        return this.retainItemsInList_(items, list, listName);
    }

    protected boolean retainItemsInList_(Iterator<?> items, List<?> list, String listName) {
        HashBag<?> retainedItems = CollectionTools.collection(items);
        HashBag<?> removedItems = CollectionTools.collection(list);
        removedItems.removeAll(retainedItems);
        return this.removeItemsFromList((Collection<?>)removedItems, list, listName);
    }

    public <E> E setItemInList(int index, E item, List<E> list, String listName) {
        E replacedItem = list.set(index, item);
        if (this.valuesAreDifferent(item, replacedItem)) {
            this.fireItemReplaced(listName, index, item, replacedItem);
        }
        return replacedItem;
    }

    public <E> int replaceItemInList(E oldItem, E newItem, List<E> list, String listName) {
        if (list.isEmpty()) {
            return -1;
        }
        int index = list.indexOf(oldItem);
        if (index != -1 && this.valuesAreDifferent(oldItem, newItem)) {
            list.set(index, newItem);
            this.fireItemReplaced(listName, index, newItem, oldItem);
        }
        return index;
    }

    public <E> List<E> setItemsInList(int index, E[] items, List<E> list, String listName) {
        if (items.length == 0) {
            return Collections.emptyList();
        }
        return this.setItemsInList_(index, Arrays.asList(items), list, listName);
    }

    public <E> List<E> setItemsInList(int index, List<? extends E> items, List<E> list, String listName) {
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        return this.setItemsInList_(index, items, list, listName);
    }

    protected <E> List<E> setItemsInList_(int index, List<? extends E> items, List<E> list, String listName) {
        List<E> subList = list.subList(index, index + items.size());
        ArrayList<E> replacedItems = new ArrayList<E>(subList);
        int i = 0;
        while (i < items.size()) {
            E newItem = items.get(i);
            E oldItem = subList.set(i, newItem);
            if (this.valuesAreDifferent(oldItem, newItem)) {
                this.fireItemReplaced(listName, index + i, newItem, oldItem);
            }
            ++i;
        }
        return replacedItems;
    }

    public <E> boolean moveItemsInList(int targetIndex, int sourceIndex, int length, List<E> list, String listName) {
        if (targetIndex == sourceIndex || length == 0) {
            return false;
        }
        CollectionTools.move(list, targetIndex, sourceIndex, length);
        this.fireItemsMoved(listName, targetIndex, sourceIndex, length);
        return true;
    }

    public <E> boolean moveItemInList(int targetIndex, int sourceIndex, List<E> list, String listName) {
        if (targetIndex == sourceIndex) {
            return false;
        }
        CollectionTools.move(list, targetIndex, sourceIndex);
        this.fireItemMoved(listName, targetIndex, sourceIndex);
        return true;
    }

    public boolean clearList(List<?> list, String listName) {
        if (list.isEmpty()) {
            return false;
        }
        return this.clearList_(list, listName);
    }

    protected boolean clearList_(List<?> list, String listName) {
        list.clear();
        this.fireListCleared(listName);
        return true;
    }

    public <E> boolean synchronizeList(List<E> newList, List<E> list, String listName) {
        if (newList.isEmpty()) {
            return this.clearList(list, listName);
        }
        if (list.isEmpty()) {
            return this.addItemsToList_(newList, list, listName);
        }
        return this.synchronizeList_(newList, list, listName);
    }

    public <E> boolean synchronizeList(Iterator<E> newList, List<E> list, String listName) {
        if (!newList.hasNext()) {
            return this.clearList(list, listName);
        }
        if (list.isEmpty()) {
            return this.addItemsToList_(newList, list, listName);
        }
        return this.synchronizeList_(CollectionTools.list(newList), list, listName);
    }

    protected <E> boolean synchronizeList_(List<E> newList, List<E> oldList, String listName) {
        int newSize = newList.size();
        int oldSize = oldList.size();
        boolean changed = false;
        int min = Math.min(newSize, oldSize);
        int i = 0;
        while (i < min) {
            E newItem = newList.get(i);
            E oldItem = oldList.set(i, newItem);
            if (this.valuesAreDifferent(oldItem, newItem)) {
                changed = true;
                this.fireItemReplaced(listName, i, newItem, oldItem);
            }
            ++i;
        }
        if (newSize == oldSize) {
            return changed;
        }
        if (newSize < oldSize) {
            this.removeItemsFromList_(newSize, oldSize - newSize, oldList, listName);
            return true;
        }
        this.addItemsToList_(newList.subList(oldSize, newSize), oldList, listName);
        return true;
    }

    public void addTreeChangeListener(TreeChangeListener listener) {
        this.addListener(TREE_CHANGE_LISTENER_CLASS, listener);
    }

    public void addTreeChangeListener(String treeName, TreeChangeListener listener) {
        this.addListener(treeName, TREE_CHANGE_LISTENER_CLASS, listener);
    }

    public void removeTreeChangeListener(TreeChangeListener listener) {
        this.removeListener(TREE_CHANGE_LISTENER_CLASS, listener);
    }

    public void removeTreeChangeListener(String treeName, TreeChangeListener listener) {
        this.removeListener(treeName, TREE_CHANGE_LISTENER_CLASS, listener);
    }

    public boolean hasAnyTreeChangeListeners(String treeName) {
        return this.hasAnyListeners(TREE_CHANGE_LISTENER_CLASS, treeName);
    }

    public boolean hasAnyTreeChangeListeners() {
        return this.hasAnyListeners(TREE_CHANGE_LISTENER_CLASS);
    }

    private TreeChangeListener[] getTreeChangeListeners() {
        return (TreeChangeListener[])this.getListeners(TREE_CHANGE_LISTENER_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeAdded(TreeChangeEvent event) {
        String treeName = event.getTreeName();
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.getTreeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.getChild(treeName);
        }
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getTreeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.nodeAdded(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireNodeAdded(event);
        }
        this.aspectChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeAdded(String treeName, Object[] path) {
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.getTreeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.getChild(treeName);
        }
        TreeChangeEvent event = null;
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getTreeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new TreeChangeEvent(this.source, treeName, path);
                    }
                    target.nodeAdded(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireNodeAdded(treeName, path);
            } else {
                child.fireNodeAdded(event);
            }
        }
        this.aspectChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeRemoved(TreeChangeEvent event) {
        String treeName = event.getTreeName();
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.getTreeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.getChild(treeName);
        }
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getTreeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.nodeRemoved(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireNodeRemoved(event);
        }
        this.aspectChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeRemoved(String treeName, Object[] path) {
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.getTreeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.getChild(treeName);
        }
        TreeChangeEvent event = null;
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getTreeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new TreeChangeEvent(this.source, treeName, path);
                    }
                    target.nodeRemoved(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireNodeRemoved(treeName, path);
            } else {
                child.fireNodeRemoved(event);
            }
        }
        this.aspectChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeCleared(TreeChangeEvent event) {
        String treeName = event.getTreeName();
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.getTreeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.getChild(treeName);
        }
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getTreeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.treeCleared(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireTreeCleared(event);
        }
        this.aspectChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeCleared(String treeName, Object[] path) {
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.getTreeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.getChild(treeName);
        }
        TreeChangeEvent event = null;
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getTreeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new TreeChangeEvent(this.source, treeName, path);
                    }
                    target.treeCleared(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireTreeCleared(treeName, path);
            } else {
                child.fireTreeCleared(event);
            }
        }
        this.aspectChanged(treeName);
    }

    public void fireTreeCleared(String treeName) {
        this.fireTreeCleared(treeName, EMPTY_TREE_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged(TreeChangeEvent event) {
        String treeName = event.getTreeName();
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.getTreeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.getChild(treeName);
        }
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getTreeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    target.treeChanged(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            child.fireTreeChanged(event);
        }
        this.aspectChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged(String treeName, Object[] path) {
        TreeChangeListener[] targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            TreeChangeListener[] treeChangeListeners = this.getTreeChangeListeners();
            if (treeChangeListeners != null) {
                targets = (TreeChangeListener[])treeChangeListeners.clone();
            }
            child = this.getChild(treeName);
        }
        TreeChangeEvent event = null;
        if (targets != null) {
            TreeChangeListener[] treeChangeListenerArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                boolean stillListening;
                TreeChangeListener target = treeChangeListenerArray[n2];
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = CollectionTools.contains(this.getTreeChangeListeners(), (Object)target);
                }
                if (stillListening) {
                    if (event == null) {
                        event = new TreeChangeEvent(this.source, treeName, path);
                    }
                    target.treeChanged(event);
                }
                ++n2;
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireTreeChanged(treeName, path);
            } else {
                child.fireTreeChanged(event);
            }
        }
        this.aspectChanged(treeName);
    }

    public void fireTreeChanged(String treeName) {
        this.fireTreeChanged(treeName, EMPTY_TREE_PATH);
    }

    public boolean valuesAreEqual(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    public boolean valuesAreDifferent(Object value1, Object value2) {
        return !this.valuesAreEqual(value1, value2);
    }

    public boolean elementsAreEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (!this.valuesAreDifferent(iterator1.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public boolean elementsAreDifferent(Iterator<?> iterator1, Iterator<?> iterator2) {
        return !this.elementsAreEqual(iterator1, iterator2);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.source);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int len = this.genericListeners.length;
        int i = 0;
        while (i < len) {
            this.writeObject(s, this.genericListeners[i]);
            ++i;
        }
        s.writeObject(null);
    }

    private void writeObject(ObjectOutputStream s, GenericListenerList gll) throws IOException {
        boolean first = true;
        int len = gll.listeners.length;
        int i = 0;
        while (i < len) {
            ChangeListener listener = gll.listeners[i];
            if (listener instanceof Serializable) {
                if (first) {
                    first = false;
                    s.writeObject(gll.listenerClass);
                }
                s.writeObject(listener);
            }
            ++i;
        }
        if (!first) {
            s.writeObject(null);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object o;
        s.defaultReadObject();
        this.genericListeners = EMPTY_GENERIC_LISTENERS;
        while ((o = s.readObject()) != null) {
            Class listenerClass = (Class)o;
            GenericListenerList gll = null;
            while ((o = s.readObject()) != null) {
                if (gll == null) {
                    gll = this.addGenericListenerList_(listenerClass, (ChangeListener)o);
                    continue;
                }
                gll.addListener((ChangeListener)o);
            }
        }
    }

    private <T extends ChangeListener> GenericListenerList addGenericListenerList_(Class<T> listenerClass, ChangeListener listener) {
        return this.addGenericListenerList(listenerClass, listener);
    }

    private static class AspectChild
    implements Serializable {
        final String aspectName;
        final ChangeSupport child;
        private static final long serialVersionUID = 1L;

        AspectChild(String aspectName, ChangeSupport child) {
            this.aspectName = aspectName;
            this.child = child;
        }

        public String toString() {
            return StringTools.buildToStringFor(this, this.aspectName);
        }
    }

    protected static class Child
    extends ChangeSupport {
        private static final long serialVersionUID = 1L;

        public Child(Model source) {
            super(source);
        }

        protected ChangeSupport buildChild() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenericListenerList {
        final Class<? extends ChangeListener> listenerClass;
        ChangeListener[] listeners;

        <T extends ChangeListener> GenericListenerList(Class<T> listenerClass, T listener) {
            this.listenerClass = listenerClass;
            this.listeners = (ChangeListener[])Array.newInstance(listenerClass, 1);
            this.listeners[0] = listener;
        }

        void addListener(ChangeListener listener) {
            this.listeners = CollectionTools.add(this.listeners, listener);
        }

        boolean removeListener(ChangeListener listener) {
            int len = this.listeners.length;
            if (len == 0) {
                return false;
            }
            try {
                this.listeners = CollectionTools.remove(this.listeners, listener);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return false;
            }
            return this.listeners.length + 1 == len;
        }

        boolean hasListeners() {
            return this.listeners.length > 0;
        }

        public String toString() {
            return StringTools.buildToStringFor(this, ClassTools.shortNameFor(this.listenerClass));
        }
    }
}

